/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.BindingContext;

public class RenameParameterToMatchOverriddenMethodFix
extends JetIntentionAction<JetParameter> {
    private final JetParameter parameter;
    private String parameterFromSuperclassName;

    public RenameParameterToMatchOverriddenMethodFix(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "<init>"));
        }
        super(parameter);
        this.parameter = parameter;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        BindingContext context2 = ResolvePackage.analyzeFully(this.parameter);
        VariableDescriptor parameterDescriptor = context2.get(BindingContext.VALUE_PARAMETER, this.parameter);
        if (parameterDescriptor == null) {
            return false;
        }
        for (CallableDescriptor callableDescriptor : parameterDescriptor.getOverriddenDescriptors()) {
            if (this.parameterFromSuperclassName == null) {
                this.parameterFromSuperclassName = callableDescriptor.getName().asString();
                continue;
            }
            if (this.parameterFromSuperclassName.equals(callableDescriptor.getName().asString())) continue;
            return false;
        }
        return this.parameterFromSuperclassName != null;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("rename.parameter.to.match.overridden.method", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("rename.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "invoke"));
        }
        new RenameProcessor(project, (PsiElement)this.parameter, this.parameterFromSuperclassName, false, false).run();
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetParameter parameter = QuickFixUtil.getParentElementOfType(diagnostic, JetParameter.class);
                return parameter == null ? null : new RenameParameterToMatchOverriddenMethodFix(parameter);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RenameParameterToMatchOverriddenMethodFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

