/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;

public class JetPrimaryConstructorParameterTableModel
extends JetCallableParameterTableModel {
    public JetPrimaryConstructorParameterTableModel(JetMethodDescriptor methodDescriptor, PsiElement context2) {
        super(methodDescriptor, context2, new ColumnInfo[]{new ValVarColumn(), new ParameterTableModelBase.NameColumn(context2.getProject()), new ParameterTableModelBase.TypeColumn(context2.getProject(), (FileType)JetFileType.INSTANCE), new ParameterTableModelBase.DefaultValueColumn(context2.getProject(), (FileType)JetFileType.INSTANCE)});
    }

    public static boolean isValVarColumn(ColumnInfo column) {
        return column instanceof ValVarColumn;
    }

    protected static class ValVarColumn
    extends ParameterTableModelBase.ColumnInfoBase<JetParameterInfo, ParameterTableModelItemBase<JetParameterInfo>, JetValVar> {
        public ValVarColumn() {
            super(JetRefactoringBundle.message("column.name.val.var", new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<JetParameterInfo> item) {
            return !item.isEllipsisType() && ((JetParameterInfo)item.parameter).getIsNewParameter();
        }

        public JetValVar valueOf(ParameterTableModelItemBase<JetParameterInfo> item) {
            return ((JetParameterInfo)item.parameter).getValOrVar();
        }

        public void setValue(ParameterTableModelItemBase<JetParameterInfo> item, JetValVar value2) {
            ((JetParameterInfo)item.parameter).setValOrVar(value2);
        }

        public TableCellRenderer doCreateRenderer(ParameterTableModelItemBase<JetParameterInfo> item) {
            return new ComboBoxTableRenderer((Object[])JetValVar.values());
        }

        public TableCellEditor doCreateEditor(ParameterTableModelItemBase<JetParameterInfo> item) {
            return new ComboBoxCellEditor(new JComboBox());
        }

        public int getWidth(JTable table) {
            return table.getFontMetrics(table.getFont()).stringWidth(this.getName()) + 8;
        }
    }
}

