/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiRange;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ExtractionEnginePackage$duplicateUtil$c7eb9daa {
    @Nullable
    public static final RangeHighlighter highlight(@JetValueParameter(name="$receiver") JetPsiRange $receiver, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextRange textRange = $receiver.getTextRange();
        ArrayList highlighters = new ArrayList();
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (textAttributes == null) {
            Intrinsics.throwNpe();
        }
        TextAttributes attributes = textAttributes;
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, (Collection)highlighters);
        return (RangeHighlighter)KotlinPackage.firstOrNull((List)highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangeHighlighter preview(@JetValueParameter(name="$receiver") JetPsiRange $receiver, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        RangeHighlighter rangeHighlighter2 = ExtractionEnginePackage$duplicateUtil$c7eb9daa.highlight($receiver, project, editor);
        if (rangeHighlighter2 != null) {
            void destination;
            void $receiver2;
            void $receiver3;
            RangeHighlighter $receiver4 = rangeHighlighter2;
            RangeHighlighter it = $receiver4;
            int startOffset = $receiver.getTextRange().getStartOffset();
            Object[] objectArray = CodeFoldingManager.getInstance((Project)project).getFoldRegionsAtOffset(editor, startOffset);
            void var7_7 = $receiver3;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver2).length; ++i) {
                void element = $receiver2[i];
                FoldRegion it2 = (FoldRegion)element;
                if (!(!it2.isExpanded())) continue;
                destination.add(element);
            }
            List foldedRegions = (List)destination;
            if (!foldedRegions.isEmpty()) {
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(foldedRegions){
                    final /* synthetic */ List $foldedRegions;

                    public final void run() {
                        Iterable $receiver = this.$foldedRegions;
                        for (T element : $receiver) {
                            FoldRegion it = (FoldRegion)element;
                            it.setExpanded(true);
                        }
                    }
                    {
                        this.$foldedRegions = list;
                    }
                });
            }
            editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
            rangeHighlighter = it;
        } else {
            rangeHighlighter = null;
        }
        return rangeHighlighter;
    }

    /*
     * WARNING - void declaration
     */
    public static final void processDuplicates(@JetValueParameter(name="duplicateReplacers") @NotNull Map<JetPsiRange, ? extends Function0<? extends Unit>> duplicateReplacers, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="editor") @NotNull Editor editor) {
        int answer;
        int n;
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        int size = duplicateReplacers.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ExtractionEnginePackage$duplicateUtil$c7eb9daa.preview((JetPsiRange)KotlinPackage.first((Iterable)duplicateReplacers.keySet()), project, editor);
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            n = Messages.YES;
        } else {
            Object[] objectArray = new Object[2];
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            if (applicationNamesInfo == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = applicationNamesInfo.getProductName();
            objectArray[1] = duplicateReplacers.size();
            n = answer = Messages.showYesNoDialog((Project)project, (String)JetRefactoringBundle.message("0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.declaration", objectArray), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon());
        }
        if (answer != 0) {
            return;
        }
        boolean showAll = false;
        block5: for (IndexedValue indexedValue : KotlinPackage.withIndex((Iterable)duplicateReplacers.entrySet())) {
            void replacer;
            Boolean bl;
            void pattern;
            Map.Entry entry;
            int i = indexedValue.component1();
            Map.Entry entry2 = entry = (Map.Entry)indexedValue.component2();
            JetPsiRange jetPsiRange = (JetPsiRange)KotlinPackage.component1((Map.Entry)entry2);
            Function0 function0 = (Function0)KotlinPackage.component2((Map.Entry)entry2);
            entry2 = null;
            if (!pattern.isValid()) continue;
            RangeHighlighter highlighter = ExtractionEnginePackage$duplicateUtil$c7eb9daa.preview((JetPsiRange)pattern, project, editor);
            Application application2 = ApplicationManager.getApplication();
            if (application2 == null) {
                Intrinsics.throwNpe();
            }
            if (!application2.isUnitTestMode() && size > 1 && !showAll) {
                RangeHighlighter promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{i + 1, size}), project);
                promptDialog.show();
                switch (promptDialog.getExitCode()) {
                    case 3: {
                        showAll = true;
                        break;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            if (highlighter != null) {
                void $receiver;
                RangeHighlighter it = (RangeHighlighter)$receiver;
                bl = HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, it);
            } else {
                bl = null;
            }
            String string = MethodDuplicatesHandler.REFACTORING_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
            ApplicationPackage.executeWriteCommand(project, string, (Function0<? extends Unit>)replacer);
        }
    }

    public static final void processDuplicatesSilently(@JetValueParameter(name="duplicateReplacers") @NotNull Map<JetPsiRange, ? extends Function0<? extends Unit>> duplicateReplacers, @JetValueParameter(name="project") @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = MethodDuplicatesHandler.REFACTORING_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
        ApplicationPackage.executeWriteCommand(project, string, (Function0<? extends Unit>)((Function0)new Function0<Unit>(duplicateReplacers){
            final /* synthetic */ Map $duplicateReplacers;

            public final void invoke() {
                Iterable $receiver = this.$duplicateReplacers.values();
                for (T element : $receiver) {
                    Function0 it = (Function0)element;
                    it.invoke();
                }
            }
            {
                this.$duplicateReplacers = map2;
                super(0);
            }
        }));
    }
}

