/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClass;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

public class RenameJetClassProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/rename/RenameJetClassProcessor", "canProcessElement"));
        }
        return element instanceof JetClassOrObject || element instanceof KotlinLightClass || element instanceof JetSecondaryConstructor;
    }

    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        return RenameJetClassProcessor.getJetClassOrObject(element, true, editor);
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        String nameWithoutExtensions;
        JetFile file;
        VirtualFile virtualFile;
        JetClassOrObject classOrObject = RenameJetClassProcessor.getJetClassOrObject(element, false, null);
        if (classOrObject != null && (virtualFile = (file = classOrObject.getContainingJetFile()).getVirtualFile()) != null && (nameWithoutExtensions = virtualFile.getNameWithoutExtension()).equals(classOrObject.getName())) {
            allRenames.put((PsiElement)file, newName + "." + virtualFile.getExtension());
        }
    }

    @Nullable
    private static JetClassOrObject getJetClassOrObject(@Nullable PsiElement element, boolean showErrors, @Nullable Editor editor) {
        if (element instanceof KotlinLightClass) {
            if (element instanceof KotlinLightClassForExplicitDeclaration) {
                return ((KotlinLightClassForExplicitDeclaration)element).getOrigin();
            }
            if (element instanceof KotlinLightClassForPackage) {
                if (showErrors) {
                    CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JetBundle.message("rename.kotlin.package.class.error", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), null);
                }
                return null;
            }
            assert (false) : "Should not be suggested to rename element of type " + element.getClass() + " " + element;
        } else if (element instanceof JetSecondaryConstructor) {
            return (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)element, JetClassOrObject.class);
        }
        return (JetClassOrObject)element;
    }
}

