/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtil;

public class UnsupportedAbiVersionNotificationPanelProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"unsupported.abi.version");
    private final Project project;
    private final Runnable updateNotifications;

    public UnsupportedAbiVersionNotificationPanelProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "<init>"));
        }
        this.updateNotifications = new Runnable(){

            @Override
            public void run() {
                UnsupportedAbiVersionNotificationPanelProvider.this.updateNotifications();
            }
        };
        this.project = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                UnsupportedAbiVersionNotificationPanelProvider.this.updateNotifications();
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                UnsupportedAbiVersionNotificationPanelProvider.this.updateNotifications();
            }
        });
    }

    @Nullable
    public static EditorNotificationPanel checkAndCreate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "checkAndCreate"));
        }
        Collection<VirtualFile> badRoots = KotlinRuntimeLibraryUtil.getLibraryRootsWithAbiIncompatibleKotlinClasses(project);
        if (!badRoots.isEmpty()) {
            return new UnsupportedAbiVersionNotificationPanelProvider(project).doCreate(badRoots);
        }
        return null;
    }

    private EditorNotificationPanel doCreate(final Collection<VirtualFile> badRoots) {
        ErrorNotificationPanel answer = new ErrorNotificationPanel();
        Collection<Library> kotlinLibraries = KotlinRuntimeLibraryUtil.findKotlinLibraries(this.project);
        final Collection badRuntimeLibraries = Collections2.filter(kotlinLibraries, (Predicate)new Predicate<Library>(){

            public boolean apply(@Nullable Library library) {
                assert (library != null) : "library should be non null";
                VirtualFile runtimeJar = JavaRuntimePresentationProvider.getRuntimeJar(library);
                return badRoots.contains(KotlinRuntimeLibraryUtil.getLocalJar(runtimeJar));
            }
        });
        if (!badRuntimeLibraries.isEmpty()) {
            int otherBadRootsCount = badRoots.size() - badRuntimeLibraries.size();
            String text = MessageFormat.format("<html><b>{0,choice,0#|1#|1<Some }Kotlin runtime librar{0,choice,0#|1#y|1<ies}</b>{1,choice,0#|1# and one other jar|1< and {1} other jars} {1,choice,0#has|0<have} an unsupported format</html>", badRuntimeLibraries.size(), otherBadRootsCount);
            String actionLabelText = MessageFormat.format("Update {0,choice,0#|1#|1<all }Kotlin runtime librar{0,choice,0#|1#y|1<ies} ", badRuntimeLibraries.size());
            answer.setText(text);
            answer.createActionLabel(actionLabelText, new Runnable(){

                @Override
                public void run() {
                    KotlinRuntimeLibraryUtil.updateLibraries(UnsupportedAbiVersionNotificationPanelProvider.this.project, badRuntimeLibraries);
                }
            });
            if (otherBadRootsCount > 0) {
                this.createShowPathsActionLabel(answer, "Show all");
            }
        } else if (badRoots.size() == 1) {
            final VirtualFile root = badRoots.iterator().next();
            String presentableName = root.getPresentableName();
            answer.setText("<html>Kotlin library <b>'" + presentableName + "'</b> " + "has an unsupported format. Please update the library or the plugin</html>");
            answer.createActionLabel("Go to " + presentableName, new Runnable(){

                @Override
                public void run() {
                    UnsupportedAbiVersionNotificationPanelProvider.navigateToLibraryRoot(UnsupportedAbiVersionNotificationPanelProvider.this.project, root);
                }
            });
        } else {
            answer.setText("Some Kotlin libraries attached to this project have unsupported format. Please update the libraries or the plugin");
            this.createShowPathsActionLabel(answer, "Show paths");
        }
        return answer;
    }

    private static void navigateToLibraryRoot(Project project, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "navigateToLibraryRoot"));
        }
        new OpenFileDescriptor(project, root).navigate(true);
    }

    private void createShowPathsActionLabel(EditorNotificationPanel answer, String labelText) {
        final Ref label = new Ref(null);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)UnsupportedAbiVersionNotificationPanelProvider.this.project).tryRunReadActionInSmartMode((Computable)new Computable<Object>(){

                    public Object compute() {
                        Collection<VirtualFile> badRoots = KotlinRuntimeLibraryUtil.getLibraryRootsWithAbiIncompatibleKotlinClasses(UnsupportedAbiVersionNotificationPanelProvider.this.project);
                        assert (!badRoots.isEmpty()) : "This action should only be called when bad roots are present";
                        LibraryRootsPopupModel listPopupModel = new LibraryRootsPopupModel("Unsupported format", UnsupportedAbiVersionNotificationPanelProvider.this.project, badRoots);
                        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)listPopupModel);
                        popup.showUnderneathOf((Component)label.get());
                        return null;
                    }
                }, "Can't show all paths during index update");
            }
        };
        label.set((Object)answer.createActionLabel(labelText, action));
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider", "createNotificationPanel"));
        }
        try {
            if (DumbService.isDumb((Project)this.project)) {
                return null;
            }
            if (file.getFileType() != JetFileType.INSTANCE) {
                return null;
            }
            if (CompilerManager.getInstance((Project)this.project).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.project);
            if (module == null) {
                return null;
            }
            KotlinProjectConfigurator configurator = ConfigureKotlinInProjectUtils.getConfiguratorByName("java");
            assert (configurator != null) : "Configurator should exists java";
            if (!configurator.isConfigured(module)) {
                return null;
            }
            return UnsupportedAbiVersionNotificationPanelProvider.checkAndCreate(this.project);
        }
        catch (ProcessCanceledException e) {
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.project).runWhenSmart(this.updateNotifications);
        }
        return null;
    }

    private void updateNotifications() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!UnsupportedAbiVersionNotificationPanelProvider.this.project.isDisposed()) {
                    EditorNotifications.getInstance((Project)UnsupportedAbiVersionNotificationPanelProvider.this.project).updateAllNotifications();
                }
            }
        });
    }

    private static class ErrorNotificationPanel
    extends EditorNotificationPanel {
        public ErrorNotificationPanel() {
            this.myLabel.setIcon(AllIcons.General.Error);
        }
    }

    private static class LibraryRootsPopupModel
    extends BaseListPopupStep<VirtualFile> {
        private final Project project;

        public LibraryRootsPopupModel(@NotNull String title, @NotNull Project project, @NotNull Collection<VirtualFile> roots) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$LibraryRootsPopupModel", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$LibraryRootsPopupModel", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$LibraryRootsPopupModel", "<init>"));
            }
            super(title, (Object[])roots.toArray(new VirtualFile[roots.size()]));
            this.project = project;
        }

        @NotNull
        public String getTextFor(VirtualFile root) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)this.project.getBaseDir(), (char)'/');
            String string = relativePath != null ? relativePath : root.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/UnsupportedAbiVersionNotificationPanelProvider$LibraryRootsPopupModel", "getTextFor"));
            }
            return string;
        }

        public Icon getIconFor(VirtualFile aValue) {
            if (aValue.isDirectory()) {
                return AllIcons.Nodes.Folder;
            }
            return AllIcons.FileTypes.Archive;
        }

        public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
            UnsupportedAbiVersionNotificationPanelProvider.navigateToLibraryRoot(this.project, selectedValue);
            return FINAL_CHOICE;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }
    }
}

