/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.SpecialExpressionConverter;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"?\u0006)\u0011Sk]1hKB\u0013xnY3tg&tw-\u0012=qe\u0016\u001c8/[8o\u0007>tg/\u001a:uKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UJZ'bD;tC\u001e,\u0007K]8dKN\u001c\u0018N\\4\u000b5M\u0003XmY5bY\u0016C\bO]3tg&|gnQ8om\u0016\u0014H/\u001a:\u000b\rqJg.\u001b;?\u0015-\u0001(o\\2fgNLgnZ:\u000b\u00075\u000b\u0007O\u0003\u0006Qg&,E.Z7f]RT1aY8n\u0015!Ig\u000e^3mY&T'b\u00019tS*Q1i\u001c7mK\u000e$\u0018n\u001c8\u000b\u001fU\u001b\u0018mZ3Qe>\u001cWm]:j]\u001eTAA[1wC*!Q\u000f^5m\u001599W\r\u001e)s_\u000e,7o]5oONT\u0011cY8om\u0016\u0014H/\u0012=qe\u0016\u001c8/[8o\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u000e!NLW\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u001b\r|G-Z\"p]Z,'\u000f^3s\u00155\u0019u\u000eZ3D_:4XM\u001d;fe*QQ\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007\u0005\u001cH\u000fi\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0019A1\u0001\u0005\u0004\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\n!1QA\u0001\u0003\u0006\u0011\u001b)1\u0001b\u0003\t\u000b1\u0001Qa\u0001C\u0004\u0011\u001da\u0001!B\u0002\u0005\u0005!=A\u0002A\u0003\u0002\u0011!)!\u0001b\u0004\t\u0012\u0015\u0011A\u0001\u0003E\u0005\u000b\r!Y\u0001#\u0006\r\u0001\u0015\u0019A1\u0001E\f\u0019\u0001)!\u0001b\u0001\t\u001a\u0015\u0019AA\u0003\u0005\r\u0019\u0001)!\u0001\u0002\u0006\t\u0019\u0015\u0011A1\u0002E\u000b\u000b\t!\u0019\u0001c\u0006\u0005\u00011\u0015\u0011DA\u0003\u0002\u0011\ri3\u0004\u00021\u00051\u0011\tc\"B\u0001\t\t%\u0019\u0011BA\u0003\u0002\u0011\u0019Iq!\u0003\u0004\u0006\u0003!5\u0011bA\u0005\u0003\u000b\u0005Aq!V\u0002\t\u000b\r!A!C\u0001\t\u00125\u0019A!C\u0005\u0002\u0011#i[\u0004\u0002\u0005\u0019\u0014u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t\u00175\u0011Q!\u0001E\n!\u000e\u0005\u0011eA\u0003\u0002\u0011+a\t!U\u0002\b\t'I\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\rk\u0003*y\u0004Br\u00011\u000fi*\u0003\u0002\u0001\t\t5qQ!\u0001\u0005\u0005\u0013\rI!!B\u0001\t\r%9\u0011BB\u0003\u0002\u0011\u001bI1!\u0003\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\u0005\u0015\t\u0001RA)\u0004\u000b\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\u0002"})
public final class UsageProcessingExpressionConverter
implements SpecialExpressionConverter {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Map<PsiElement, ? extends Collection<? extends UsageProcessing>> processings;

    static {
        $kotlinClass = Reflection.createKotlinClass(UsageProcessingExpressionConverter.class);
    }

    @Override
    @Nullable
    public Expression convertExpression(@JetValueParameter(name="expression") @NotNull PsiExpression expression2, @JetValueParameter(name="codeConverter") @NotNull CodeConverter codeConverter) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
        if (this.processings.isEmpty()) {
            return null;
        }
        PsiExpression psiExpression = expression2;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement psiElement = ((PsiReferenceExpression)expression2).resolve();
            if (!(psiElement instanceof PsiVariable)) {
                psiElement = null;
            }
            PsiVariable psiVariable = (PsiVariable)psiElement;
            if (psiVariable == null) {
                return null;
            }
            PsiVariable target = psiVariable;
            Collection<? extends UsageProcessing> collection = this.processings.get(target);
            if (collection == null) {
                return null;
            }
            Collection<? extends UsageProcessing> forTarget = collection;
            for (UsageProcessing usageProcessing : forTarget) {
                ConvertedCodeProcessor convertedCodeProcessor2 = usageProcessing.getConvertedCodeProcessor();
                Expression converted2 = convertedCodeProcessor2 != null ? convertedCodeProcessor2.convertVariableUsage((PsiReferenceExpression)expression2, codeConverter) : null;
                if (converted2 == null) continue;
                return converted2;
            }
            return null;
        }
        if (psiExpression instanceof PsiMethodCallExpression) {
            PsiElement psiElement = ((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
            if (!(psiElement instanceof PsiMethod)) {
                psiElement = null;
            }
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (psiMethod == null) {
                return null;
            }
            PsiMethod target = psiMethod;
            Collection<? extends UsageProcessing> collection = this.processings.get(target);
            if (collection == null) {
                return null;
            }
            Collection<? extends UsageProcessing> forTarget = collection;
            for (UsageProcessing usageProcessing : forTarget) {
                ConvertedCodeProcessor convertedCodeProcessor3 = usageProcessing.getConvertedCodeProcessor();
                Expression converted3 = convertedCodeProcessor3 != null ? convertedCodeProcessor3.convertMethodUsage((PsiMethodCallExpression)expression2, codeConverter) : null;
                if (converted3 == null) continue;
                return converted3;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public final Map<PsiElement, Collection<? extends UsageProcessing>> getProcessings() {
        return this.processings;
    }

    public UsageProcessingExpressionConverter(@JetValueParameter(name="processings") @NotNull Map<PsiElement, ? extends Collection<? extends UsageProcessing>> processings) {
        Intrinsics.checkParameterIsNotNull(processings, (String)"processings");
        this.processings = processings;
    }
}

