/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public abstract class JavaMemberImpl<Psi extends PsiMember>
extends JavaElementImpl<Psi>
implements JavaMember,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    protected JavaMemberImpl(@NotNull Psi psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "<init>"));
        }
        super(psiMember);
    }

    @Override
    @NotNull
    public Name getName() {
        String name2 = ((PsiMember)this.getPsi()).getName();
        assert (name2 != null && Name.isValidIdentifier(name2)) : "Member must have a name: " + ((PsiMember)this.getPsi()).getText();
        Name name3 = Name.identifier(name2);
        if (name3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "getName"));
        }
        return name3;
    }

    @Override
    @NotNull
    public JavaClass getContainingClass() {
        PsiClass psiClass = ((PsiMember)this.getPsi()).getContainingClass();
        assert (psiClass != null) : "Member must have a containing class: " + this.getPsi();
        JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
        if (javaClassImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "getContainingClass"));
        }
        return javaClassImpl;
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = JavaElementUtil.getVisibility(this);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        Collection<JavaAnnotation> collection = JavaElementUtil.getAnnotations(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "getAnnotations"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/structure/impl/JavaMemberImpl", "findAnnotation"));
        }
        return JavaElementUtil.findAnnotation(this, fqName2);
    }
}

