/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;

public class JetParameterElementType
extends JetStubElementType<KotlinParameterStub, JetParameter> {
    public JetParameterElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "<init>"));
        }
        super(debugName, JetParameter.class, KotlinParameterStub.class);
    }

    public KotlinParameterStub createStub(@NotNull JetParameter psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "createStub"));
        }
        FqName fqName2 = psi.getFqName();
        StringRef fqNameRef = StringRef.fromString((String)(fqName2 != null ? fqName2.asString() : null));
        return new KotlinParameterStubImpl((StubElement<? extends PsiElement>)parentStub, fqNameRef, StringRef.fromString((String)psi.getName()), psi.isMutable(), psi.hasValOrVarNode(), psi.hasDefaultValue());
    }

    public void serialize(@NotNull KotlinParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isMutable());
        dataStream.writeBoolean(stub.hasValOrVarNode());
        dataStream.writeBoolean(stub.hasDefaultValue());
        FqName name2 = stub.getFqName();
        dataStream.writeName(name2 != null ? name2.asString() : null);
    }

    @NotNull
    public KotlinParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "deserialize"));
        }
        StringRef name2 = dataStream.readName();
        boolean isMutable = dataStream.readBoolean();
        boolean hasValOrValNode = dataStream.readBoolean();
        boolean hasDefaultValue = dataStream.readBoolean();
        StringRef fqName2 = dataStream.readName();
        KotlinParameterStubImpl kotlinParameterStubImpl = new KotlinParameterStubImpl((StubElement<? extends PsiElement>)parentStub, fqName2, name2, isMutable, hasValOrValNode, hasDefaultValue);
        if (kotlinParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetParameterElementType", "deserialize"));
        }
        return kotlinParameterStubImpl;
    }
}

