/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypedef;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.resolveUtil.ResolveUtilPackage$checkTraitRequirements$720eb856;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"H\u0016)\u0019B*\u0019>z)>\u0004Hi\\<o\u0003:\fG.\u001f>fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\rE>$\u0017PU3t_24XM\u001d\u0006\r\u0005>$\u0017PU3t_24XM\u001d\u0006\u0014I\u0016\u001cG.\u0019:bi&|gNU3t_24XM\u001d\u0006\u0014\t\u0016\u001cG.\u0019:bi&|gNU3t_24XM\u001d\u0006\u0019I\u0016\u001cG.\u0019:bi&|gnU2pa\u0016\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007#fG2\f'/\u0019;j_:\u001c6m\u001c9f!J|g/\u001b3fe*!A.\u0019>z\u0015E1\u0017\u000e\\3TG>\u0004X\r\u0015:pm&$WM\u001d\u0006\u0012\r&dWmU2pa\u0016\u0004&o\u001c<jI\u0016\u0014(b\u00067buf$Um\u00197be\u0006$\u0018n\u001c8SKN|GN^3s\u0015]a\u0015M_=EK\u000ed\u0017M]1uS>t'+Z:pYZ,'O\u0003\tn_\u0012,H.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*\u0001Rj\u001c3vY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\tpm\u0016\u0014Hn\\1e%\u0016\u001cx\u000e\u001c<fe*\u0001rJ^3sY>\fGMU3t_24XM\u001d\u0006\u0011_Z,'O]5eKJ+7o\u001c7wKJT\u0001c\u0014<feJLG-\u001a*fg>dg/\u001a:\u000b5Q|\u0007\u000fT3wK2$Um]2sSB$xN\u001d)s_ZLG-\u001a:\u000b5Q{\u0007\u000fT3wK2$Um]2sSB$xN\u001d)s_ZLG-\u001a:\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJTqBV1sS\u0006t7-Z\"iK\u000e\\WM\u001d\u0006\u0014C:\fG.\u001f>f\t\u0016\u001cG.\u0019:bi&|gn\u001d\u0006\u0014i>\u0004Hi\\<o\u0003:\fG._:jg6{G-\u001a\u0006\u0014)>\u0004Hi\\<o\u0003:\fG._:jg6{G-\u001a\u0006\rI\u0016\u001cG.\u0019:bi&|gn\u001d\u0006\u000b\u0007>dG.Z2uS>t'B\u0003)tS\u0016cW-\\3oi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015EyW\u000f^3s\t\u0006$\u0018M\u00127po&sgm\u001c\u0006\r\t\u0006$\u0018M\u00127po&sgm\u001c\u0006\u0006G\u0006dGn\u001d\u0006\u000bg6\f'\u000f^2bgR\u001c(B\u0006+pa\u0012{wO\\!oC2L8/[:D_:$X\r\u001f;\u000b\t)\fg/\u0019\u0006\u0005kRLGNC\rde\u0016\fG/\u001a$v]\u000e$\u0018n\u001c8EKN\u001c'/\u001b9u_J\u001c(\"A2\u000b\u0013\u0019,hn\u0019;j_:\u001c(\u0002\u0002'jgRT\u0001CS3u\u001d\u0006lW\r\u001a$v]\u000e$\u0018n\u001c8\u000b\tUs\u0017\u000e\u001e\u0006\u001aGJ,\u0017\r^3Qe>\u0004XM\u001d;z\t\u0016\u001c8M]5qi>\u00148OC\bu_BdUM^3m\rFt\u0015-\\3t\u0015!iU\u000f\u001c;j[\u0006\u0004(BB4p_\u001edWM\u0003\u0004d_6lwN\u001c\u0006\bG>dG.Z2u\u0015\u00191\u0015OT1nK*!a.Y7f\u0015)QU\r^#mK6,g\u000e\u001e\u0006\u000baJ|\u0007/\u001a:uS\u0016\u001c(b\u0003&fiB\u0013x\u000e]3sifTQB]3hSN$XM]*d_B,'b\u00033fG2\f'/\u0019;j_:TaBS3u\t\u0016\u001cG.\u0019:bi&|gN\u0003\fsK\u001eL7\u000f^3s)>\u0004H*\u001a<fY\u001a\u000bh*Y7f\u0015MQU\r\u001e(b[\u0016$G)Z2mCJ\fG/[8o\u0015)!Wm]2sSB$xN\u001d\u0006\u0016\t\u0016\u001cG.\u0019:bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015i\u0011Xm]8mm\u0016\fE\u000e\u001c%fC\u0012,'o]%o\u00072\f7o]3t\u0015=\u0019X\r\u001e\"pIf\u0014Vm]8mm\u0016\u0014(BF:fi\u0012+7\r\\1sCRLwN\u001c*fg>dg/\u001a:\u000b7M,G\u000fR3dY\u0006\u0014\u0018\r^5p]N\u001bw\u000e]3Qe>4\u0018\u000eZ3s\u0015q!Um\u00197be\u0006$\u0018n\u001c8TG>\u0004X\r\u0015:pm&$WM]%na2TAc]3u\r&dWmU2pa\u0016\u0004&o\u001c<jI\u0016\u0014(BG:fi2\u000b'0\u001f#fG2\f'/\u0019;j_:\u0014Vm]8mm\u0016\u0014(bE:fi6{G-\u001e7f\t\u0016\u001c8M]5qi>\u0014(bE:fi>3XM\u001d7pC\u0012\u0014Vm]8mm\u0016\u0014(bE:fi>3XM\u001d:jI\u0016\u0014Vm]8mm\u0016\u0014(\"H:fiR{\u0007\u000fT3wK2$Um]2sSB$xN\u001d)s_ZLG-\u001a:\u000b\u0011M,G\u000f\u0016:bG\u0016T!c]3u-\u0006\u0014\u0018.\u00198dK\u000eCWmY6feZ\u001f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0003\u0011\u000ba\u0001!B\u0002\u0005\u0004!!A\u0002A\u0003\u0003\t\u0007AA!B\u0002\u0005\u0004!)A\u0002A\u0003\u0003\t\u0007AQ!\u0002\u0002\u0005\u0004!5Qa\u0001C\u0006\u0011\u0019a\u0001!\u0002\u0002\u0005\f!1Qa\u0001C\u0006\u0011\u001fa\u0001!\u0002\u0002\u0005\f!=Qa\u0001C\u0006\u0011#a\u0001!\u0002\u0002\u0005\f!EQA\u0001\u0003\u0002\u0011))1\u0001B\u0005\t\u00141\u0001QA\u0001\u0003\n\u0011')1\u0001b\u0001\t\u00171\u0001QA\u0001C\u0002\u0011-)1\u0001b\u0001\t\u00191\u0001QA\u0001C\u0002\u00111)1\u0001b\u0003\t\u001b1\u0001QA\u0001C\u0006\u00115)1\u0001b\u0001\t\u001d1\u0001QA\u0001C\u0002\u00119)!\u0001b\u0001\t\u001e\u0015\u0019AQ\u0004\u0005\u0010\u0019\u0001)!\u0001\"\b\t\u001f\u0015\u0019A1\u0001E\u0011\u0019\u0001)1\u0001\"\u0002\t$1\u0001Q!\u0001E\u0013\u000b\t!\u0011\u0003C\n\u0006\u0005\u0011\r\u0002rE\u0003\u0004\tIA!\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001\"F\u0003\u0003\tMAY#B\u0002\u0005(!%B\u0002A\u0003\u0004\t\u0007Aa\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001BF\u0003\u0003\t\u0007A\t#B\u0001\t.\u0015\u0011AA\u0006\u0005\u0018\u000b\t!i\u0003c\t\u0006\u0005\u0011\u001d\u0002\u0012F\u0003\u0004\t\u000bA\u0011\u0004\u0004\u0001\u0006\u0005\u0011\t\u0001rE\u0003\u0004\tcA\u0019\u0004\u0004\u0001\u0006\u0007\u0011\u0015\u0001B\u0007\u0007\u0001\u000b\t!i\u0003C\r\u0006\u0005\u0011\t\u0002\u0002H\u0003\u0003\tkAI$\u0002\u0002\u00057!iRa\u0001C\u001c\u0011oa\u0001!\u0002\u0002\u0005\u0003!qRa\u0001C\u001d\u0011wa\u0001!B\u0002\u00052!uB\u0002A\u0003\u0004\tcAy\u0004\u0004\u0001\u0006\u0005\u0011]\u0002rG\u0003\u0004\tcA\u0011\u0005\u0004\u0001\u0006\u0005\u0011E\u0002\"I\u0003\u0004\tcA!\u0005\u0004\u0001\u0006\u0007\u0011I\u0001b\t\u0007\u0001\u000b\t!\t\u0004\u0003\u0012\u0006\u0005\u0011I\u0001bI\u0003\u0004\t\u0017AY\u0005\u0004\u0001\u0006\u0005\u0011-\u00012\n\u0003\u0004\u0019\tI\"!B\u0001\t\u00075bA!1\u0007\u0019\b\u0005\u001aQ!\u0001E\u0004\u0019\u0003)6\u0001B\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0003.\u0019\u0011\tM\u0002'\u0003\"\u0007\u0015\t\u0001\u0012\u0002G\u0001+\u000e!Qa\u0001C\u0005\u0013\u0005AQ!\f\u0007\u0005\u00034AZ!I\u0002\u0006\u0003!1A\u0012A+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011\u001biC\u0002Ba\r1\u001d\t3!B\u0001\t\u000f1\u0005Qk\u0001\u0003\u0006\u0007\u00119\u0011\"\u0001E\b[1!\u0011\u0019\u0004\r\tC\r)\u0011\u0001\u0003\u0005\r\u0002U\u001bA!B\u0002\u0005\u0011%\t\u0001\u0012C\u0017\r\t\u0005g\u0001$C\u0011\u0004\u000b\u0005A\u0019\u0002$\u0001V\u0007\u0011)1\u0001B\u0005\n\u0003!QQ\u0006\u0004\u0003B\u001aaU\u0011eA\u0003\u0002\u0011+a\t!V\u0002\u0005\u000b\r!)\"C\u0001\t\u00175bA!1\u0007\u0019\u0018\u0005\u001aQ!\u0001E\f\u0019\u0003)6\u0001B\u0003\u0004\t/I\u0011\u0001\u0003\u0007.\u0019\u0011\tM\u0002'\u0007\"\u0007\u0015\t\u0001\u0012\u0004G\u0001+\u000e!Qa\u0001C\r\u0013\u0005AQ\"\f\u0007\u0005\u00034AZ\"I\u0002\u0006\u0003!mA\u0012A+\u0004\t\u0015\u0019A1D\u0005\u0002\u00119iC\u0002Ba\r1;\t3!B\u0001\t\u001f1\u0005Qk\u0001\u0003\u0006\u0007\u0011u\u0011\"\u0001E\u0010[)\"1\u0001g\b\u001e\u000e\u0011\u0001\u0001\u0002E\u0007\u0003\u000b\u0005A\u0001\u0003U\u0002\u0001;+!\u0001\u0001C\t\u000e\r\u0015\t\u0001\u0012E\u0005\u0004\u0013\t)\u0011\u0001#\nQ\u0007\u0003ij\u0001\u0002\u0001\t)5\u0011Q!\u0001\u0005\u0015!\u000e\t\u0011EA\u0003\u0002\u0011S\t6!\u0003C\u0010\u0013\u0005AQ#D\u0001\t,5\t\u0001bF\u0007\u0002\u0011_i\u000b\u0005B\u0001\u00190u5A\u0001\u0001\u0005\u0019\u001b\t)\u0011\u0001#\u000bQ\u0007\u0001i*\u0002\u0002\u0001\t251Q!\u0001\u0005\u0019\u0013\rI!!B\u0001\t3A\u001b\t!\t\u0002\u0006\u0003!M\u0012kA\u0004\u00050%\tA\u0001A\u0007\u0002\u0011Ui\u0011\u0001\u0003\u000e.e\u0011\t\u0001TGO\u0007\t\u0001A\u0001$\u0004\u0002\u0006\u0003!%\u0002k\u0001\u0001\u001e\u001e\u0011\u0001\u0001bG\u0007\u000b\u000b\u0005AA$C\u0002\n\u0005\u0015\t\u0001\"H\u0005\u0004\u0013\t)\u0011\u0001c\u000fQ\u0007\u0003i*\u0002\u0002\u0001\t?51Q!\u0001\u0005\u0019\u0013\rI!!B\u0001\t=A\u001b\u0011!\t\u0002\u0006\u0003!M\u0012kA\u0005\u00056%\tA\u0001A\u0007\u0002\u0011Ui\u0011\u0001#\u0010\u000e\u0003!QR6\b\u0003\u00021\u0001jj\u0001\u0002\u0001\t15\u0011Q!\u0001E\u0015!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0003j1!B\u0001\t?1\u0005\u0001k!\u0001\"\u0005\u0015\t\u00012G)\u0004\u000f\u0011\u0001\u0013\"\u0001\u0003\u0001\u001b\u0005AQ#D\u0001\t@5rC!\u0001M\";;!\u0001\u0001C\u000e\u000e\u0015\u0015\t\u0001\u0002H\u0005\u0004\u0013\t)\u0011\u0001C\u000f\n\u0007%\u0011Q!\u0001E\u001e!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0003j!!B\u0001\tAA\u001b\t!(\u0004\u0005\u0001!\u0015SBA\u0003\u0002\u0011\u0003\u00026!A\u0011\u0003\u000b\u0005A\u0019$U\u0002\n\t\u0007J\u0011\u0001\u0002\u0001\u000e\u0003!uR\"\u0001\u0005\"\u001b\u0005A\u0019%L\n\u0005\u0003a\u001dST\u0002\u0003\u0001\u0011ai!!B\u0001\t*A\u001b\u0001!\t\u0002\u0006\u0003!M\u0012kA\u0003\u0005H%\tA\u0001A\u0007\u0002\u0011Ui3\u0003b\u0002\u0019Iu5A\u0001\u0001E\u0004\u001b\t)\u0011\u0001c\u0002Q\u0007\u0001\t#!B\u0001\t4E\u001bQ\u0001\u0002\u0013\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005[M!9\u0001'\u0013\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005AI\u0001U\u0002\u0001C\t)\u0011\u0001c\rR\u0007\u0015!I%C\u0001\u0005\u00015\t\u0001\"B\u0017\u0014\t\u000fAR%(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\t\u00026\u0001A\u0011\u0003\u000b\u0005A\u0019$U\u0002\u0006\t\u0015J\u0011\u0001\u0002\u0001\u000e\u0003!\u0015Sf\u0005C\u00041\u0019jj\u0001\u0002\u0001\t\u000f5\u0011Q!\u0001\u0005\b!\u000e\u0001\u0011EA\u0003\u0002\u0011g\t6!\u0002\u0003'\u0013\u0005!\u0001!D\u0001\t\u00105\u001aBq\u0001M';\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\u001a#\u000e)AQJ\u0005\u0002\t\u0001i\u0011\u0001#\u0005.'\u0011\u001d\u0001dJO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!M\u0001k\u0001\u0001\"\u0005\u0015\t\u00012G)\u0004\u000b\u00119\u0013\"\u0001\u0003\u0001\u001b\u0005A!\"L\n\u0005\ba=ST\u0002\u0003\u0001\u0011+i!!B\u0001\t\u0016A\u001b\u0001!\t\u0002\u0006\u0003!M\u0012kA\u0003\u0005P%\tA\u0001A\u0007\u0002\u0011-i3\u0003b\u0002\u0019Qu5A\u0001\u0001E\f\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t#!B\u0001\t4E\u001bQ\u0001\u0002\u0015\n\u0003\u0011\u0001Q\"\u0001\u0005\r[M!9\u0001'\u0015\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005AI\u0002U\u0002\u0001C\t)\u0011\u0001c\rR\u0007\u0015!\t&C\u0001\u0005\u00015\t\u0001\"D\u0017\u0014\t\u000fA\u0012&(\u0004\u0005\u0001!mQBA\u0003\u0002\u00117\u00016\u0001A\u0011\u0003\u000b\u0005A\u0019$U\u0002\u0006\t%J\u0011\u0001\u0002\u0001\u000e\u0003!qQf\u0005C\u00041'jj\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001\u0005\u0010!\u000e\u0001\u0011EA\u0003\u0002\u0011g\t6!\u0002C*\u0013\u0005!\u0001!D\u0001\t UZQA\u0003\u0003d\u0002a\u0019\u0011EA\u0003\u0002\u0011\t\t6a\u0001\u0003\u0004\u0013\u0005!\u0001\u0001"})
public final class LazyTopDownAnalyzer {
    public static final /* synthetic */ KClass $kotlinClass;
    private BindingTrace trace;
    private DeclarationResolver declarationResolver;
    private OverrideResolver overrideResolver;
    private OverloadResolver overloadResolver;
    private VarianceChecker varianceChecker;
    private ModuleDescriptor moduleDescriptor;
    private LazyDeclarationResolver lazyDeclarationResolver;
    private BodyResolver bodyResolver;
    private TopLevelDescriptorProvider topLevelDescriptorProvider;
    private FileScopeProvider fileScopeProvider;
    private DeclarationScopeProvider declarationScopeProvider;

    static {
        $kotlinClass = Reflection.createKotlinClass(LazyTopDownAnalyzer.class);
    }

    @Inject
    public final void setLazyDeclarationResolver(@JetValueParameter(name="lazyDeclarationResolver") @NotNull LazyDeclarationResolver lazyDeclarationResolver) {
        Intrinsics.checkParameterIsNotNull((Object)lazyDeclarationResolver, (String)"lazyDeclarationResolver");
        this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Inject
    public final void setTopLevelDescriptorProvider(@JetValueParameter(name="topLevelDescriptorProvider") @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider) {
        Intrinsics.checkParameterIsNotNull((Object)topLevelDescriptorProvider, (String)"topLevelDescriptorProvider");
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
    }

    @Inject
    public final void setFileScopeProvider(@JetValueParameter(name="fileScopeProvider") @NotNull FileScopeProvider fileScopeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)fileScopeProvider, (String)"fileScopeProvider");
        this.fileScopeProvider = fileScopeProvider;
    }

    @Inject
    public final void setDeclarationScopeProvider(@JetValueParameter(name="declarationScopeProvider") @NotNull DeclarationScopeProviderImpl declarationScopeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)declarationScopeProvider, (String)"declarationScopeProvider");
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Inject
    public final void setTrace(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.trace = trace;
    }

    @Inject
    public final void setDeclarationResolver(@JetValueParameter(name="declarationResolver") @NotNull DeclarationResolver declarationResolver) {
        Intrinsics.checkParameterIsNotNull((Object)declarationResolver, (String)"declarationResolver");
        this.declarationResolver = declarationResolver;
    }

    @Inject
    public final void setOverrideResolver(@JetValueParameter(name="overrideResolver") @NotNull OverrideResolver overrideResolver) {
        Intrinsics.checkParameterIsNotNull((Object)overrideResolver, (String)"overrideResolver");
        this.overrideResolver = overrideResolver;
    }

    @Inject
    public final void setVarianceChecker(@JetValueParameter(name="varianceChecker") @NotNull VarianceChecker varianceChecker) {
        Intrinsics.checkParameterIsNotNull((Object)varianceChecker, (String)"varianceChecker");
        this.varianceChecker = varianceChecker;
    }

    @Inject
    public final void setOverloadResolver(@JetValueParameter(name="overloadResolver") @NotNull OverloadResolver overloadResolver) {
        Intrinsics.checkParameterIsNotNull((Object)overloadResolver, (String)"overloadResolver");
        this.overloadResolver = overloadResolver;
    }

    @Inject
    public final void setModuleDescriptor(@JetValueParameter(name="moduleDescriptor") @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public final void setBodyResolver(@JetValueParameter(name="bodyResolver") @NotNull BodyResolver bodyResolver) {
        Intrinsics.checkParameterIsNotNull((Object)bodyResolver, (String)"bodyResolver");
        this.bodyResolver = bodyResolver;
    }

    @NotNull
    public final TopDownAnalysisContext analyzeDeclarations(@JetValueParameter(name="topDownAnalysisMode") @NotNull TopDownAnalysisMode topDownAnalysisMode, @JetValueParameter(name="declarations") @NotNull Collection<? extends PsiElement> declarations2, @JetValueParameter(name="outerDataFlowInfo") @NotNull DataFlowInfo outerDataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)topDownAnalysisMode), (String)"topDownAnalysisMode");
        Intrinsics.checkParameterIsNotNull(declarations2, (String)"declarations");
        Intrinsics.checkParameterIsNotNull((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisMode, outerDataFlowInfo);
        HashMultimap topLevelFqNames = HashMultimap.create();
        ArrayList properties2 = new ArrayList();
        ArrayList functions2 = new ArrayList();
        for (PsiElement psiElement : declarations2) {
            psiElement.accept((PsiElementVisitor)new JetVisitorVoid(this, c, topLevelFqNames, functions2, properties2){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ LazyTopDownAnalyzer this$0;
                final /* synthetic */ TopDownAnalysisContext $c;
                final /* synthetic */ HashMultimap $topLevelFqNames;
                final /* synthetic */ ArrayList $functions;
                final /* synthetic */ ArrayList $properties;

                static {
                    $kotlinClass = Reflection.createKotlinClass(analyzeDeclarations.1.class);
                }

                private final void registerDeclarations(@JetValueParameter(name="declarations") List<? extends JetDeclaration> declarations2) {
                    for (JetDeclaration jetDeclaration : declarations2) {
                        jetDeclaration.accept(this);
                    }
                }

                public void visitDeclaration(@JetValueParameter(name="dcl") @NotNull JetDeclaration dcl) {
                    Intrinsics.checkParameterIsNotNull((Object)dcl, (String)"dcl");
                    throw (Throwable)new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                public void visitJetFile(@JetValueParameter(name="file") @NotNull JetFile file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    if (file.isScript()) {
                        JetScript jetScript = file.getScript();
                        if (jetScript == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("getScript() is null for file: " + file)));
                        }
                        JetScript script = jetScript;
                        BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                        if (bindingTrace == null) {
                            Intrinsics.throwNpe();
                        }
                        DescriptorResolver.registerFileInPackage(bindingTrace, file);
                        Map<JetScript, ScriptDescriptor> map2 = this.$c.getScripts();
                        TopLevelDescriptorProvider topLevelDescriptorProvider = LazyTopDownAnalyzer.access$getTopLevelDescriptorProvider$3(this.this$0);
                        if (topLevelDescriptorProvider == null) {
                            Intrinsics.throwNpe();
                        }
                        map2.put(script, topLevelDescriptorProvider.getScriptDescriptor(script));
                    } else {
                        JetPackageDirective packageDirective = file.getPackageDirective();
                        boolean value2 = packageDirective != null;
                        if (KotlinPackage.getASSERTIONS_ENABLED() && !value2) {
                            String message = "No package in a non-script file: " + file;
                            throw (Throwable)((Object)new AssertionError((Object)message));
                        }
                        this.$c.addFile(file);
                        JetPackageDirective jetPackageDirective = packageDirective;
                        if (jetPackageDirective == null) {
                            Intrinsics.throwNpe();
                        }
                        jetPackageDirective.accept(this);
                        BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                        if (bindingTrace == null) {
                            Intrinsics.throwNpe();
                        }
                        DescriptorResolver.registerFileInPackage(bindingTrace, file);
                        List<JetDeclaration> list = file.getDeclarations();
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"file.getDeclarations()");
                        this.registerDeclarations(list);
                        this.$topLevelFqNames.put((Object)file.getPackageFqName(), (Object)packageDirective);
                    }
                }

                public void visitPackageDirective(@JetValueParameter(name="directive") @NotNull JetPackageDirective directive) {
                    Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                    ModuleDescriptor moduleDescriptor = LazyTopDownAnalyzer.access$getModuleDescriptor$1(this.this$0);
                    if (moduleDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                    if (bindingTrace == null) {
                        Intrinsics.throwNpe();
                    }
                    DescriptorResolver.resolvePackageHeader(directive, moduleDescriptor, bindingTrace);
                }

                public void visitImportDirective(@JetValueParameter(name="importDirective") @NotNull JetImportDirective importDirective) {
                    Intrinsics.checkParameterIsNotNull((Object)importDirective, (String)"importDirective");
                    FileScopeProvider fileScopeProvider = LazyTopDownAnalyzer.access$getFileScopeProvider$4(this.this$0);
                    if (fileScopeProvider == null) {
                        Intrinsics.throwNpe();
                    }
                    JetFile jetFile = importDirective.getContainingJetFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jetFile, (String)"importDirective.getContainingJetFile()");
                    JetScope jetScope = fileScopeProvider.getFileScope(jetFile);
                    if (jetScope == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.resolve.scopes.JetScope cannot be cast to org.jetbrains.kotlin.resolve.lazy.LazyFileScope");
                    }
                    LazyFileScope fileScope = (LazyFileScope)jetScope;
                    fileScope.forceResolveImport(importDirective);
                }

                private final void visitClassOrObject(@JetValueParameter(name="classOrObject") JetClassOrObject classOrObject) {
                    LazyDeclarationResolver lazyDeclarationResolver = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$2(this.this$0);
                    if (lazyDeclarationResolver == null) {
                        Intrinsics.throwNpe();
                    }
                    ClassDescriptor classDescriptor = lazyDeclarationResolver.getClassDescriptor(classOrObject);
                    if (classDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.ClassDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    ClassDescriptorWithResolutionScopes descriptor2 = (ClassDescriptorWithResolutionScopes)classDescriptor;
                    this.$c.getDeclaredClasses().put(classOrObject, descriptor2);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    Multimap multimap = (Multimap)this.$topLevelFqNames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"topLevelFqNames");
                    LazyTopDownAnalyzer.access$registerTopLevelFqName$5(this.this$0, (Multimap<FqName, JetElement>)multimap, classOrObject, descriptor2);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor2);
                }

                private final void checkClassOrObjectDeclarations(@JetValueParameter(name="classOrObject") JetClassOrObject classOrObject, @JetValueParameter(name="classDescriptor") ClassDescriptor classDescriptor) {
                    boolean companionObjectAlreadyFound = false;
                    for (JetDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        if (jetDeclaration instanceof JetObjectDeclaration && ((JetObjectDeclaration)jetDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                                if (bindingTrace == null) {
                                    Intrinsics.throwNpe();
                                }
                                bindingTrace.report(Errors.MANY_COMPANION_OBJECTS.on((JetObjectDeclaration)jetDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(jetDeclaration instanceof JetSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor)) {
                            BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                            if (bindingTrace == null) {
                                Intrinsics.throwNpe();
                            }
                            bindingTrace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((JetDeclaration)((PsiElement)jetDeclaration)));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) continue;
                        BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                        if (bindingTrace == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace.report(Errors.CONSTRUCTOR_IN_TRAIT.on((JetDeclaration)((PsiElement)jetDeclaration)));
                    }
                }

                public void visitClass(@JetValueParameter(name="klass") @NotNull JetClass klass) {
                    Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private final void registerPrimaryConstructorParameters(@JetValueParameter(name="klass") JetClass klass) {
                    for (JetParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (!jetParameter.hasValOrVarNode()) continue;
                        Map<JetParameter, PropertyDescriptor> map2 = this.$c.getPrimaryConstructorParameterProperties();
                        LazyDeclarationResolver lazyDeclarationResolver = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$2(this.this$0);
                        if (lazyDeclarationResolver == null) {
                            Intrinsics.throwNpe();
                        }
                        DeclarationDescriptor declarationDescriptor = lazyDeclarationResolver.resolveToDescriptor(jetParameter);
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        }
                        map2.put(jetParameter, (PropertyDescriptor)declarationDescriptor);
                    }
                }

                public void visitSecondaryConstructor(@JetValueParameter(name="constructor") @NotNull JetSecondaryConstructor constructor2) {
                    Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
                    Map<JetSecondaryConstructor, ConstructorDescriptor> map2 = this.$c.getSecondaryConstructors();
                    LazyDeclarationResolver lazyDeclarationResolver = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$2(this.this$0);
                    if (lazyDeclarationResolver == null) {
                        Intrinsics.throwNpe();
                    }
                    DeclarationDescriptor declarationDescriptor = lazyDeclarationResolver.resolveToDescriptor(constructor2);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                    }
                    map2.put(constructor2, (ConstructorDescriptor)declarationDescriptor);
                    LazyTopDownAnalyzer.access$registerScope$6(this.this$0, this.$c, constructor2);
                }

                public void visitEnumEntry(@JetValueParameter(name="enumEntry") @NotNull JetEnumEntry enumEntry) {
                    Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
                    this.visitClassOrObject(enumEntry);
                }

                public void visitObjectDeclaration(@JetValueParameter(name="declaration") @NotNull JetObjectDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    this.visitClassOrObject(declaration);
                }

                public void visitAnonymousInitializer(@JetValueParameter(name="initializer") @NotNull JetClassInitializer initializer) {
                    Intrinsics.checkParameterIsNotNull((Object)initializer, (String)"initializer");
                    LazyTopDownAnalyzer.access$registerScope$6(this.this$0, this.$c, initializer);
                    JetClassOrObject classOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)initializer, JetClassOrObject.class);
                    Map<JetClassInitializer, ClassDescriptorWithResolutionScopes> map2 = this.$c.getAnonymousInitializers();
                    LazyDeclarationResolver lazyDeclarationResolver = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$2(this.this$0);
                    if (lazyDeclarationResolver == null) {
                        Intrinsics.throwNpe();
                    }
                    DeclarationDescriptor declarationDescriptor = lazyDeclarationResolver.resolveToDescriptor(classOrObject);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    map2.put(initializer, (ClassDescriptorWithResolutionScopes)declarationDescriptor);
                }

                public void visitTypedef(@JetValueParameter(name="typedef") @NotNull JetTypedef typedef) {
                    Intrinsics.checkParameterIsNotNull((Object)typedef, (String)"typedef");
                    BindingTrace bindingTrace = LazyTopDownAnalyzer.access$getTrace$0(this.this$0);
                    if (bindingTrace == null) {
                        Intrinsics.throwNpe();
                    }
                    bindingTrace.report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
                }

                public void visitMultiDeclaration(@JetValueParameter(name="multiDeclaration") @NotNull JetMultiDeclaration multiDeclaration) {
                    Intrinsics.checkParameterIsNotNull((Object)multiDeclaration, (String)"multiDeclaration");
                }

                public void visitNamedFunction(@JetValueParameter(name="function") @NotNull JetNamedFunction function2) {
                    Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                    this.$functions.add(function2);
                }

                public void visitProperty(@JetValueParameter(name="property") @NotNull JetProperty property) {
                    Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                    this.$properties.add(property);
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$topLevelFqNames = $captured_local_variable$2;
                    this.$functions = $captured_local_variable$3;
                    this.$properties = $captured_local_variable$4;
                }
            });
        }
        this.createFunctionDescriptors(c, functions2);
        Multimap multimap = (Multimap)topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"topLevelFqNames");
        this.createPropertyDescriptors(c, (Multimap<FqName, JetElement>)multimap, properties2);
        this.resolveAllHeadersInClasses(c);
        DeclarationResolver declarationResolver = this.declarationResolver;
        if (declarationResolver == null) {
            Intrinsics.throwNpe();
        }
        TopLevelDescriptorProvider topLevelDescriptorProvider = this.topLevelDescriptorProvider;
        if (topLevelDescriptorProvider == null) {
            Intrinsics.throwNpe();
        }
        Multimap multimap2 = (Multimap)topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull((Object)multimap2, (String)"topLevelFqNames");
        declarationResolver.checkRedeclarationsInPackages(topLevelDescriptorProvider, (Multimap<FqName, JetElement>)multimap2);
        DeclarationResolver declarationResolver2 = this.declarationResolver;
        if (declarationResolver2 == null) {
            Intrinsics.throwNpe();
        }
        declarationResolver2.checkRedeclarations(c);
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"c.getDeclaredClasses()");
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            Intrinsics.throwNpe();
        }
        ResolveUtilPackage$checkTraitRequirements$720eb856.checkTraitRequirements(map2, bindingTrace);
        OverrideResolver overrideResolver = this.overrideResolver;
        if (overrideResolver == null) {
            Intrinsics.throwNpe();
        }
        overrideResolver.check(c);
        VarianceChecker varianceChecker = this.varianceChecker;
        if (varianceChecker == null) {
            Intrinsics.throwNpe();
        }
        varianceChecker.check(c);
        DeclarationResolver declarationResolver3 = this.declarationResolver;
        if (declarationResolver3 == null) {
            Intrinsics.throwNpe();
        }
        FileScopeProvider fileScopeProvider = this.fileScopeProvider;
        if (fileScopeProvider == null) {
            Intrinsics.throwNpe();
        }
        declarationResolver3.resolveAnnotationsOnFiles(c, fileScopeProvider);
        OverloadResolver overloadResolver = this.overloadResolver;
        if (overloadResolver == null) {
            Intrinsics.throwNpe();
        }
        overloadResolver.process(c);
        BodyResolver bodyResolver = this.bodyResolver;
        if (bodyResolver == null) {
            Intrinsics.throwNpe();
        }
        bodyResolver.resolveBodies(c);
        return c;
    }

    private final void resolveAllHeadersInClasses(@JetValueParameter(name="c") TopDownAnalysisContext c) {
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getAllClasses().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = iterator2.next();
            if (classDescriptorWithResolutionScopes == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes! cannot be cast to org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor");
            }
            ((LazyClassDescriptor)classDescriptorWithResolutionScopes).resolveMemberHeaders();
        }
    }

    private final void createPropertyDescriptors(@JetValueParameter(name="c") TopDownAnalysisContext c, @JetValueParameter(name="topLevelFqNames") Multimap<FqName, JetElement> topLevelFqNames, @JetValueParameter(name="properties") List<? extends JetProperty> properties2) {
        for (JetProperty jetProperty : properties2) {
            LazyDeclarationResolver lazyDeclarationResolver = this.lazyDeclarationResolver;
            if (lazyDeclarationResolver == null) {
                Intrinsics.throwNpe();
            }
            DeclarationDescriptor declarationDescriptor = lazyDeclarationResolver.resolveToDescriptor(jetProperty);
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            PropertyDescriptor descriptor2 = (PropertyDescriptor)declarationDescriptor;
            c.getProperties().put(jetProperty, descriptor2);
            this.registerTopLevelFqName(topLevelFqNames, jetProperty, descriptor2);
            this.registerScope(c, jetProperty);
            this.registerScope(c, jetProperty.getGetter());
            this.registerScope(c, jetProperty.getSetter());
        }
    }

    private final void createFunctionDescriptors(@JetValueParameter(name="c") TopDownAnalysisContext c, @JetValueParameter(name="functions") List<? extends JetNamedFunction> functions2) {
        for (JetNamedFunction jetNamedFunction : functions2) {
            Map<JetNamedFunction, SimpleFunctionDescriptor> map2 = c.getFunctions();
            LazyDeclarationResolver lazyDeclarationResolver = this.lazyDeclarationResolver;
            if (lazyDeclarationResolver == null) {
                Intrinsics.throwNpe();
            }
            DeclarationDescriptor declarationDescriptor = lazyDeclarationResolver.resolveToDescriptor(jetNamedFunction);
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            map2.put(jetNamedFunction, (SimpleFunctionDescriptor)declarationDescriptor);
            this.registerScope(c, jetNamedFunction);
        }
    }

    private final void registerScope(@JetValueParameter(name="c") TopDownAnalysisContext c, @JetValueParameter(name="declaration", type="?") JetDeclaration declaration) {
        if (declaration == null) {
            return;
        }
        DeclarationScopeProvider declarationScopeProvider = this.declarationScopeProvider;
        if (declarationScopeProvider == null) {
            Intrinsics.throwNpe();
        }
        c.registerDeclaringScope(declaration, declarationScopeProvider.getResolutionScopeForDeclaration(declaration));
    }

    private final void registerTopLevelFqName(@JetValueParameter(name="topLevelFqNames") Multimap<FqName, JetElement> topLevelFqNames, @JetValueParameter(name="declaration") JetNamedDeclaration declaration, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor2) {
        FqName fqName2;
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put((Object)fqName2, (Object)declaration);
        }
    }

    @Nullable
    public static final /* synthetic */ BindingTrace access$getTrace$0(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this) {
        return $this.trace;
    }

    public static final /* synthetic */ void access$setTrace$0(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="<set-?>", type="?") @Nullable BindingTrace bindingTrace) {
        $this.trace = bindingTrace;
    }

    @Nullable
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$1(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this) {
        return $this.moduleDescriptor;
    }

    public static final /* synthetic */ void access$setModuleDescriptor$1(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="<set-?>", type="?") @Nullable ModuleDescriptor moduleDescriptor) {
        $this.moduleDescriptor = moduleDescriptor;
    }

    @Nullable
    public static final /* synthetic */ LazyDeclarationResolver access$getLazyDeclarationResolver$2(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this) {
        return $this.lazyDeclarationResolver;
    }

    public static final /* synthetic */ void access$setLazyDeclarationResolver$2(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="<set-?>", type="?") @Nullable LazyDeclarationResolver lazyDeclarationResolver) {
        $this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Nullable
    public static final /* synthetic */ TopLevelDescriptorProvider access$getTopLevelDescriptorProvider$3(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this) {
        return $this.topLevelDescriptorProvider;
    }

    public static final /* synthetic */ void access$setTopLevelDescriptorProvider$3(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="<set-?>", type="?") @Nullable TopLevelDescriptorProvider topLevelDescriptorProvider) {
        $this.topLevelDescriptorProvider = topLevelDescriptorProvider;
    }

    @Nullable
    public static final /* synthetic */ FileScopeProvider access$getFileScopeProvider$4(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this) {
        return $this.fileScopeProvider;
    }

    public static final /* synthetic */ void access$setFileScopeProvider$4(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="<set-?>", type="?") @Nullable FileScopeProvider fileScopeProvider) {
        $this.fileScopeProvider = fileScopeProvider;
    }

    public static final /* synthetic */ void access$registerTopLevelFqName$5(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="topLevelFqNames") @NotNull Multimap<FqName, JetElement> topLevelFqNames, @JetValueParameter(name="declaration") @NotNull JetNamedDeclaration declaration, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor2) {
        $this.registerTopLevelFqName(topLevelFqNames, declaration, descriptor2);
    }

    public static final /* synthetic */ void access$registerScope$6(@JetValueParameter(name="$this", type="?") LazyTopDownAnalyzer $this, @JetValueParameter(name="c") @NotNull TopDownAnalysisContext c, @JetValueParameter(name="declaration", type="?") @Nullable JetDeclaration declaration) {
        $this.registerScope(c, declaration);
    }
}

