/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.types.JetType;

public class OverloadResolutionResultsUtil {
    @NotNull
    public static <D extends CallableDescriptor> OverloadResolutionResults<D> ambiguity(OverloadResolutionResults<D> results1, OverloadResolutionResults<D> results2) {
        ArrayList resultingCalls = Lists.newArrayList();
        resultingCalls.addAll(results1.getResultingCalls());
        resultingCalls.addAll(results2.getResultingCalls());
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(resultingCalls);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "ambiguity"));
        }
        return overloadResolutionResultsImpl;
    }

    @Nullable
    public static <D extends CallableDescriptor> JetType getResultingType(@NotNull OverloadResolutionResults<D> results2, @NotNull ContextDependency contextDependency) {
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        ResolvedCall<D> resultingCall = OverloadResolutionResultsUtil.getResultingCall(results2, contextDependency);
        return resultingCall != null ? resultingCall.getResultingDescriptor().getReturnType() : null;
    }

    @Nullable
    public static <D extends CallableDescriptor> ResolvedCall<D> getResultingCall(@NotNull OverloadResolutionResults<D> results2, @NotNull ContextDependency contextDependency) {
        ResolvedCall<D> resultingCall;
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (results2.isSingleResult() && contextDependency == ContextDependency.INDEPENDENT && !((MutableResolvedCall)(resultingCall = results2.getResultingCall())).hasInferredReturnType()) {
            return null;
        }
        return results2.isSingleResult() ? results2.getResultingCall() : null;
    }
}

