/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.jvm.JvmAnalyzerFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisCompletedHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public enum TopDownAnalyzerFacadeForJVM {
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;
    public static ModuleParameters JVM_MODULE_PARAMETERS;

    private static List<ImportPath> buildDefaultImports() {
        ArrayList<ImportPath> list = new ArrayList<ImportPath>();
        list.add(new ImportPath("java.lang.*"));
        list.add(new ImportPath("kotlin.*"));
        list.add(new ImportPath("kotlin.jvm.*"));
        list.add(new ImportPath("kotlin.io.*"));
        for (ClassDescriptor descriptor2 : JavaToKotlinClassMap.INSTANCE.allKotlinClasses()) {
            FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor2);
            if (!fqName2.parent().equals(new FqName("kotlin"))) continue;
            list.add(new ImportPath(fqName2, false));
        }
        return list;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationNoIncremental(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisMode topDownAnalysisMode) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(moduleContext, files, trace, topDownAnalysisMode, null, null);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        return analysisResult;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationWithCustomContext(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(moduleContext, files, trace, TopDownAnalysisMode.TopLevelDeclarations, moduleIds, incrementalCacheProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        return analysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static AnalysisResult analyzeFilesWithJavaIntegration(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisMode topDownAnalysisMode, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        Project project = moduleContext.getProject();
        List<JetFile> allFiles2 = JvmAnalyzerFacade.getAllFilesToAnalyze(project, null, files);
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), allFiles2);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(moduleContext, trace, providerFactory, GlobalSearchScope.allScope((Project)project));
        ArrayList<PackageFragmentProvider> additionalProviders = new ArrayList<PackageFragmentProvider>();
        if (moduleIds != null && incrementalCacheProvider != null) {
            for (String moduleId : moduleIds) {
                IncrementalCache incrementalCache = incrementalCacheProvider.getIncrementalCache(moduleId);
                additionalProviders.add(new IncrementalPackageFragmentProvider(files, moduleContext.getModule(), moduleContext.getStorageManager(), injector.getDeserializationComponentsForJava().getComponents(), incrementalCache, moduleId));
            }
        }
        additionalProviders.add(injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        injector.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(topDownAnalysisMode, allFiles2, additionalProviders);
        BindingContext bindingContext2 = trace.getBindingContext();
        ModuleDescriptor module = moduleContext.getModule();
        Collection analysisCompletedHandlerExtensions = AnalysisCompletedHandlerExtension.Companion.getInstances(moduleContext.getProject());
        for (AnalysisCompletedHandlerExtension extension : analysisCompletedHandlerExtensions) {
            AnalysisResult result2 = extension.analysisCompleted(project, module, bindingContext2, files);
            if (result2 == null) continue;
            AnalysisResult analysisResult = result2;
            AnalysisResult analysisResult2 = analysisResult;
            if (analysisResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
            }
            return analysisResult2;
        }
        AnalysisResult analysisResult = AnalysisResult.success(bindingContext2, module);
        AnalysisResult analysisResult3 = analysisResult;
        if (analysisResult3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult3;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static MutableModuleContext createContextWithSealedModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createContextWithSealedModule"));
        }
        MutableModuleContext context2 = ContextPackage.ContextForNewModule(project, Name.special("<shared-module>"), JVM_MODULE_PARAMETERS);
        context2.setDependencies(context2.getModule(), KotlinBuiltIns.getInstance().getBuiltInsModule());
        MutableModuleContext mutableModuleContext = context2;
        if (mutableModuleContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createContextWithSealedModule"));
        }
        return mutableModuleContext;
    }

    static {
        DEFAULT_IMPORTS = TopDownAnalyzerFacadeForJVM.buildDefaultImports();
        JVM_MODULE_PARAMETERS = new ModuleParameters(){

            @Override
            @NotNull
            public List<ImportPath> getDefaultImports() {
                List<ImportPath> list = DEFAULT_IMPORTS;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM$1", "getDefaultImports"));
                }
                return list;
            }

            @Override
            @NotNull
            public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
                JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
                if (javaToKotlinClassMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM$1", "getPlatformToKotlinClassMap"));
                }
                return javaToKotlinClassMap;
            }
        };
    }
}

