/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.Stream;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class UtilsPackage$collections$6f1efbe2 {
    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(@JetValueParameter(name="$receiver") Stream<? extends V> $receiver, @JetValueParameter(name="key") @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object v : $receiver) {
            KotlinPackage.set((Map)map2, (Object)key.invoke(v), v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@JetValueParameter(name="$receiver") Stream<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object k : $receiver) {
            KotlinPackage.set((Map)map2, k, (Object)value2.invoke(k));
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@JetValueParameter(name="$receiver") Stream<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (Object k : $receiver) {
            Object v = value2.invoke(k);
            if (v == null) continue;
            KotlinPackage.set((Map)map2, k, (Object)v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(@JetValueParameter(name="$receiver") Iterable<? extends V> $receiver, @JetValueParameter(name="key") @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        LinkedHashMap map2 = new LinkedHashMap();
        for (V v : $receiver) {
            KotlinPackage.set((Map)map2, (Object)key.invoke(v), v);
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            KotlinPackage.set((Map)map2, k, (Object)value2.invoke(k));
        }
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            Object v = value2.invoke(k);
            if (v == null) continue;
            KotlinPackage.set((Map)map2, k, (Object)v);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        for (IndexedValue indexedValue : KotlinPackage.withIndex($receiver)) {
            int index2 = indexedValue.component1();
            Object k = indexedValue.component2();
            KotlinPackage.set((Map)map2, (Object)k, (Object)index2);
        }
        return map2;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@JetValueParameter(name="$receiver") C $receiver, @JetValueParameter(name="body") @NotNull Function0<? extends C> body2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        return (C)($receiver.isEmpty() ? (Collection)body2.invoke() : $receiver);
    }

    @NotNull
    public static final <T> List<T> emptyOrSingletonList(@JetValueParameter(name="item", type="?") @Nullable T item) {
        return item == null ? KotlinPackage.listOf() : KotlinPackage.listOf(item);
    }

    public static final <T> void addIfNotNull(@JetValueParameter(name="$receiver") Collection<T> $receiver, @JetValueParameter(name="t", type="?") @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(@JetValueParameter(name="expectedSize") int expectedSize) {
        return new HashMap(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(@JetValueParameter(name="expectedSize") int expectedSize) {
        return new HashSet(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <T> List<T> toReadOnlyList(@JetValueParameter(name="$receiver") Collection<? extends T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver.isEmpty()) {
            List list2 = Collections.emptyList();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
        } else {
            list = new ArrayList<T>($receiver);
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(@JetValueParameter(name="$receiver", type="?") T $receiver) {
        return $receiver != null ? Collections.singletonList($receiver) : Collections.emptyList();
    }
}

