/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolWrapper");
    protected T myTool;
    protected final E myEP;

    protected InspectionToolWrapper(@NotNull E ep) {
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/codeInspection/ex/InspectionToolWrapper", "<init>"));
        }
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/InspectionToolWrapper", "<init>"));
        }
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, E> other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInspection/ex/InspectionToolWrapper", "<init>"));
        }
        this.myEP = other.myEP;
        this.myTool = other.myTool != null ? (this.myEP != null ? ((InspectionEP)this.myEP).instantiateTool() : (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass())) : null;
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionToolWrapper", "initialize"));
        }
        this.projectOpened(context.getProject());
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error("Short name not matched for " + tool.getClass() + ": getShortName() = " + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = " + ((InspectionEP)this.myEP).getShortName());
            }
        }
        T t = tool;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getTool"));
        }
        return t;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? null : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInspection/ex/InspectionToolWrapper", "isApplicable"));
        }
        String langId = this.getLanguage();
        return langId == null || language.getID().equals(langId) || this.applyToDialects() && language.isKindOf(langId);
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        String string = this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getShortName"));
        }
        return string;
    }

    public String getID() {
        return this.getShortName();
    }

    @NotNull
    public String getDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getDisplayName"));
            }
            return string;
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        String string = name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getGroupDisplayName"));
            }
            return string;
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        String string = groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myEP == null) {
            String[] stringArray = ((InspectionProfileEntry)this.getTool()).getGroupPath();
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getGroupPath"));
            }
            return stringArray;
        }
        String[] path = ((InspectionEP)this.myEP).getGroupPath();
        String[] stringArray = path == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getGroupPath"));
        }
        return stringArray;
    }

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionToolWrapper", "projectOpened"));
        }
        if (this.myEP == null) {
            ((InspectionProfileEntry)this.getTool()).projectOpened(project);
        }
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionToolWrapper", "projectClosed"));
        }
        if (this.myEP == null) {
            ((InspectionProfileEntry)this.getTool()).projectClosed(project);
        }
    }

    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    protected URL getDescriptionUrl() {
        Application app = ApplicationManager.getApplication();
        if (this.myEP == null || app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return this.superGetDescriptionUrl();
        }
        String fileName = this.getDescriptionFileName();
        return this.myEP.getLoaderForClass().getResource("/inspectionDescriptions/" + fileName);
    }

    @Nullable
    protected URL superGetDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    public String getDescriptionFileName() {
        String string = this.getShortName() + ".html";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getDescriptionFileName"));
        }
        return string;
    }

    @NotNull
    public final String getFolderName() {
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getFolderName"));
        }
        return string;
    }

    @NotNull
    public Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getTool().getClass();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolWrapper", "getDescriptionContextClass"));
        }
        return clazz;
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionToolWrapper", "cleanup"));
        }
        T tool = this.myTool;
        if (tool != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    @NotNull
    public abstract JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext var1);
}

