/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtil
extends VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtil");

    public static void saveText(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "saveText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/VfsUtil", "saveText"));
        }
        Charset charset = file.getCharset();
        file.setBinaryContent(text.getBytes(charset.name()));
    }

    public static void copyDirectory(Object requestor, @NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        if (fromDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromDir", "com/intellij/openapi/vfs/VfsUtil", "copyDirectory"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/VfsUtil", "copyDirectory"));
        }
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (child.is(VFileProperty.SYMLINK) || child.is(VFileProperty.SPECIAL) || filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.findChild(child.getName());
            if (newChild == null) {
                newChild = toDir.createChildDirectory(requestor, child.getName());
            }
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(@NotNull VirtualFile file, @NonNls @NotNull String resourceUrl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "copyFromResource"));
        }
        if (resourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceUrl", "com/intellij/openapi/vfs/VfsUtil", "copyFromResource"));
        }
        InputStream out = VfsUtil.class.getResourceAsStream(resourceUrl);
        if (out == null) {
            throw new FileNotFoundException(resourceUrl);
        }
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes((InputStream)out);
            file.setBinaryContent(bytes);
        }
        finally {
            out.close();
        }
    }

    public static VirtualFile copy(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "copy"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/VfsUtil", "copy"));
        }
        if (file.isDirectory()) {
            VirtualFile newDir = toDir.createChildDirectory(requestor, file.getName());
            VfsUtil.copyDirectory(requestor, file, newDir, null);
            return newDir;
        }
        return VfsUtil.copyFile(requestor, file, toDir);
    }

    @NotNull
    public static VirtualFile[] getCommonAncestors(@NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtil", "getCommonAncestors"));
        }
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getCommonAncestors"));
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(ancestorsList);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getCommonAncestors"));
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtil", "getCommonAncestor"));
        }
        VirtualFile ancestor = null;
        for (VirtualFile virtualFile : files) {
            if (ancestor == null) {
                ancestor = virtualFile;
                continue;
            }
            if ((ancestor = VfsUtil.getCommonAncestor(ancestor, virtualFile)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, String ... path) {
        VirtualFile file = base;
        for (String pathElement : path) {
            if (file == null) {
                return null;
            }
            file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement);
        }
        return file;
    }

    public static VirtualFile findFileByURL(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtil", "findFileByURL"));
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        return VfsUtil.findFileByURL(url, virtualFileManager);
    }

    public static VirtualFile findFileByURL(@NotNull URL url, @NotNull VirtualFileManager virtualFileManager) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtil", "findFileByURL"));
        }
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/vfs/VfsUtil", "findFileByURL"));
        }
        String vfUrl = VfsUtil.convertFromUrl(url);
        return virtualFileManager.findFileByUrl(vfUrl);
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull File file, boolean refreshIfNeeded) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "findFileByIoFile"));
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
        if (refreshIfNeeded && (virtualFile == null || !virtualFile.isValid())) {
            virtualFile = fileSystem.refreshAndFindFileByIoFile(file);
        }
        return virtualFile;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfsUrl", "com/intellij/openapi/vfs/VfsUtil", "convertToURL"));
        }
        return VfsUtilCore.convertToURL(vfsUrl);
    }

    public static VirtualFile copyFileRelative(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String relativePath) throws IOException {
        String token;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "copyFileRelative"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/VfsUtil", "copyFileRelative"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/VfsUtil", "copyFileRelative"));
        }
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VfsUtil", "toIdeaUrl"));
        }
        String string = VfsUtil.toIdeaUrl(url, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "toIdeaUrl"));
        }
        return string;
    }

    @NotNull
    public static URI toUri(@NotNull VirtualFile file) {
        URI uRI;
        block10: {
            String protocol;
            String path;
            block8: {
                URI uRI2;
                block9: {
                    block6: {
                        URI uRI3;
                        block7: {
                            if (file == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
                            }
                            path = file.getPath();
                            try {
                                protocol = file.getFileSystem().getProtocol();
                                if (!file.isInLocalFileSystem()) break block6;
                                if (SystemInfo.isWindows && path.charAt(0) != '/') {
                                    path = '/' + path;
                                }
                                if ((uRI3 = new URI(protocol, "", path, null, null)) != null) break block7;
                            }
                            catch (URISyntaxException e) {
                                throw new IllegalArgumentException(e);
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
                        }
                        return uRI3;
                    }
                    if (!"http".equals(protocol)) break block8;
                    uRI2 = new URI("http://" + path);
                    if (uRI2 != null) break block9;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
                }
                return uRI2;
            }
            uRI = new URI(protocol, path, null);
            if (uRI != null) break block10;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
        }
        return uRI;
    }

    @NotNull
    public static URI toUri(@NotNull File file) {
        URI uRI;
        block4: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
            }
            String path = file.toURI().getPath();
            try {
                if (SystemInfo.isWindows && path.charAt(0) != '/') {
                    path = '/' + path;
                }
                if ((uRI = new URI("file", "", path, null, null)) != null) break block4;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
        }
        return uRI;
    }

    @Nullable
    public static URI toUri(@NonNls @NotNull String uri) {
        int firstSlashIndex;
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/openapi/vfs/VfsUtil", "toUri"));
        }
        int index = uri.indexOf("://");
        if (index < 0) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        if (SystemInfo.isWindows && uri.startsWith("file://") && uri.charAt(firstSlashIndex = index + "://".length()) != '/') {
            uri = "file:///" + uri.substring(firstSlashIndex);
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.debug("uri is not fully encoded", (Throwable)e);
            try {
                int fragmentIndex = uri.lastIndexOf(35);
                String path = uri.substring(index + 1, fragmentIndex > 0 ? fragmentIndex : uri.length());
                String fragment = fragmentIndex > 0 ? uri.substring(fragmentIndex + 1) : null;
                return new URI(uri.substring(0, index), path, fragment);
            }
            catch (URISyntaxException e1) {
                LOG.debug((Throwable)e1);
                return null;
            }
        }
    }

    @Nullable
    public static String getPath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/openapi/vfs/VfsUtil", "getPath"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/openapi/vfs/VfsUtil", "getPath"));
        }
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                while (!Comparing.equal((Object)src.getParent(), (Object)commonAncestor)) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    public static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        if (libraryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryRoot", "com/intellij/openapi/vfs/VfsUtil", "getUrlForLibraryRoot"));
        }
        String path = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == FileTypes.ARCHIVE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path);
    }

    public static VirtualFile createChildSequent(Object requestor, @NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/VfsUtil", "createChildSequent"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/vfs/VfsUtil", "createChildSequent"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/vfs/VfsUtil", "createChildSequent"));
        }
        String dotExt = PathUtil.makeFileName("", extension);
        String fileName = prefix + dotExt;
        int i = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + "_" + i + dotExt;
            ++i;
        }
        return dir.createChildData(requestor, fileName);
    }

    @NotNull
    public static String[] filterNames(@NotNull String[] names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/openapi/vfs/VfsUtil", "filterNames"));
        }
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            if (names == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "filterNames"));
            }
            return names;
        }
        String[] result = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "filterNames"));
        }
        return result;
    }

    public static boolean isBadName(String name) {
        return name == null || name.isEmpty() || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(final @NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "com/intellij/openapi/vfs/VfsUtil", "createDirectories"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            @Override
            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vfs/VfsUtil$1", "run"));
                }
                VirtualFile res = VfsUtil.createDirectoryIfMissing(directoryPath);
                result.setResult(res);
            }
        }.execute().throwException().getResultObject();
    }

    public static VirtualFile createDirectoryIfMissing(VirtualFile parent, String relativePath) throws IOException {
        for (String each : StringUtil.split((String)relativePath, (String)"/")) {
            VirtualFile child = parent.findChild(each);
            if (child == null) {
                child = parent.createChildDirectory(LocalFileSystem.getInstance(), each);
            }
            parent = child;
        }
        return parent;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "com/intellij/openapi/vfs/VfsUtil", "createDirectoryIfMissing"));
        }
        String path = FileUtil.toSystemIndependentName((String)directoryPath);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (file == null) {
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(path.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = path.substring(pos + 1);
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }

    @NotNull
    public static List<VirtualFile> collectChildrenRecursively(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtil", "collectChildrenRecursively"));
        }
        final ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VfsUtil.processFilesRecursively(root, new Processor<VirtualFile>(){

            public boolean process(VirtualFile t) {
                result.add(t);
                return true;
            }
        });
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "collectChildrenRecursively"));
        }
        return arrayList;
    }

    public static void processFileRecursivelyWithoutIgnored(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vfs/VfsUtil", "processFileRecursivelyWithoutIgnored"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/VfsUtil", "processFileRecursivelyWithoutIgnored"));
        }
        final FileTypeManager ftm = FileTypeManager.getInstance();
        VfsUtil.processFilesRecursively(root, processor, new Convertor<VirtualFile, Boolean>(){

            public Boolean convert(VirtualFile vf) {
                return !ftm.isFileIgnored(vf);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T processInputStream(@NotNull VirtualFile file, @NotNull Function<InputStream, T> function) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "processInputStream"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/openapi/vfs/VfsUtil", "processInputStream"));
        }
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            Object object = function.fun((Object)stream);
            return (T)object;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static String getReadableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "getReadableUrl"));
        }
        String url = null;
        if (file.isInLocalFileSystem()) {
            url = file.getPresentableUrl();
        }
        if (url == null) {
            url = file.getUrl();
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getReadableUrl"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile getUserHomeDir() {
        String path = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    @NotNull
    public static VirtualFile[] getChildren(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/VfsUtil", "getChildren"));
        }
        VirtualFile[] children = dir.getChildren();
        VirtualFile[] virtualFileArray = children == null ? VirtualFile.EMPTY_ARRAY : children;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getChildren"));
        }
        return virtualFileArray;
    }

    @NotNull
    public static List<VirtualFile> getChildren(@NotNull VirtualFile dir, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/VfsUtil", "getChildren"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/vfs/VfsUtil", "getChildren"));
        }
        List result = null;
        for (VirtualFile child : dir.getChildren()) {
            if (!filter.accept(child)) continue;
            if (result == null) {
                result = ContainerUtil.newSmartList();
            }
            result.add(child);
        }
        List list = result != null ? result : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getChildren"));
        }
        return list;
    }

    @Nullable
    public static String getParentDir(@Nullable String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(47);
        return index < 0 ? null : url.substring(0, index);
    }

    @Nullable
    public static String extractFileName(@Nullable String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index = urlOrPath.lastIndexOf(47);
        return index < 0 ? null : urlOrPath.substring(index + 1);
    }

    @NotNull
    public static List<VirtualFile> markDirty(boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtil", "markDirty"));
        }
        List list = ContainerUtil.filter((Condition)Condition.NOT_NULL, (Object[])files);
        if (list.isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "markDirty"));
            }
            return list2;
        }
        for (VirtualFile file : list) {
            if (reloadChildren) {
                file.getChildren();
            }
            if (!(file instanceof NewVirtualFile)) continue;
            if (recursive) {
                ((NewVirtualFile)file).markDirtyRecursively();
                continue;
            }
            ((NewVirtualFile)file).markDirty();
        }
        List list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "markDirty"));
        }
        return list3;
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/VfsUtil", "markDirtyAndRefresh"));
        }
        List<VirtualFile> list = VfsUtil.markDirty(recursive, reloadChildren, files);
        if (list.isEmpty()) {
            return;
        }
        LocalFileSystem.getInstance().refreshFiles(list, async, recursive, null);
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil", "getRootFile"));
        }
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtil", "getRootFile"));
        }
        return virtualFile;
    }
}

