/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCapturedWildcardType
extends PsiType.Stub {
    @NotNull
    private final PsiWildcardType myExistential;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiTypeParameter myParameter;
    private PsiType myUpperBound;
    private static RecursionGuard guard = RecursionManager.createGuard((String)"captureGuard");

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        PsiCapturedWildcardType psiCapturedWildcardType = PsiCapturedWildcardType.create(existential, context, null);
        if (psiCapturedWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        return psiCapturedWildcardType;
    }

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        PsiCapturedWildcardType psiCapturedWildcardType = new PsiCapturedWildcardType(existential, context, parameter);
        if (psiCapturedWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        return psiCapturedWildcardType;
    }

    private PsiCapturedWildcardType(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "com/intellij/psi/PsiCapturedWildcardType", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/PsiCapturedWildcardType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myExistential = existential;
        this.myContext = context;
        this.myParameter = parameter;
        this.myUpperBound = PsiType.getJavaLangObject(this.myContext.getManager(), this.getResolveScope());
    }

    public boolean equals(Object o) {
        Boolean sameUpperBounds;
        if (!(o instanceof PsiCapturedWildcardType)) {
            return false;
        }
        final PsiCapturedWildcardType captured = (PsiCapturedWildcardType)o;
        PsiManager manager = this.myContext.getManager();
        if (!manager.areElementsEquivalent(this.myContext, captured.myContext)) {
            return false;
        }
        if ((this.myExistential.isSuper() || captured.myExistential.isSuper()) && !this.myExistential.equals(captured.myExistential)) {
            return false;
        }
        if ((this.myContext instanceof PsiReferenceExpression || this.myContext instanceof PsiMethodCallExpression) && !manager.areElementsEquivalent(this.myParameter, captured.myParameter)) {
            return false;
        }
        if (this.myParameter != null && (sameUpperBounds = (Boolean)guard.doPreventingRecursion((Object)this.myContext, true, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return Comparing.equal((Object)PsiCapturedWildcardType.this.myUpperBound, (Object)captured.myUpperBound);
            }
        })) != null && sameUpperBounds.booleanValue()) {
            return true;
        }
        return this.myExistential.equals(captured.myExistential);
    }

    public int hashCode() {
        return this.myUpperBound.hashCode() + 31 * this.myContext.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = "capture of " + this.myExistential.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.myExistential.getCanonicalText(annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = "capture<" + this.myExistential.getInternalCanonicalText() + '>';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getInternalCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.myExistential.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiCapturedWildcardType", "equalsToText"));
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiCapturedWildcardType", "accept"));
        }
        return visitor.visitCapturedWildcardType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myExistential.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = this.myExistential.getSuperTypes();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    public PsiType getLowerBound() {
        return this.myExistential.isSuper() ? this.myExistential.getBound() : NULL;
    }

    public PsiType getUpperBound() {
        PsiType bound = this.myExistential.getBound();
        if (this.myExistential.isExtends() && this.myParameter == null) {
            return bound;
        }
        return this.myUpperBound;
    }

    public void setUpperBound(PsiType upperBound) {
        this.myUpperBound = upperBound;
    }

    @NotNull
    public PsiWildcardType getWildcard() {
        PsiWildcardType psiWildcardType = this.myExistential;
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getWildcard"));
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiCapturedWildcardType", "getContext"));
        }
        return psiElement;
    }

    public PsiTypeParameter getTypeParameter() {
        return this.myParameter;
    }
}

