/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JBOptionButton
extends JButton
implements MouseMotionListener,
Weighted {
    private final Insets myDownIconInsets = JBUI.insets((int)0, (int)6, (int)0, (int)4);
    private Rectangle myMoreRec;
    private Rectangle myMoreRecMouse;
    private Action[] myOptions;
    private JPopupMenu myUnderPopup;
    private JPopupMenu myAbovePopup;
    private boolean myPopupIsShowing;
    private String myOptionTooltipText;
    private Set<OptionInfo> myOptionInfos = new HashSet<OptionInfo>();
    private boolean myOkToProcessDefaultMnemonics = true;
    private IdeGlassPane myGlassPane;
    private final Disposable myDisposable = Disposer.newDisposable();

    public JBOptionButton(Action action, Action[] options) {
        super(action);
        this.myOptions = options;
        this.myMoreRec = new Rectangle(0, 0, AllIcons.General.ArrowDown.getIconWidth(), AllIcons.General.ArrowDown.getIconHeight());
        this.myUnderPopup = this.fillMenu(true);
        this.myAbovePopup = this.fillMenu(false);
        this.enableEvents(48L);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        this.myGlassPane = IdeGlassPaneUtil.find(this);
        if (this.myGlassPane != null) {
            this.myGlassPane.addMouseMotionPreprocessor(this, this.myDisposable);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Override
    public double getWeight() {
        return 0.5;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean buttonsNotPressed;
        MouseEvent event = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.getParent());
        boolean insideRec = this.getBounds().contains(event.getPoint());
        boolean bl = buttonsNotPressed = (e.getModifiersEx() & 0x1C00) == 0;
        if (!this.myPopupIsShowing && insideRec && buttonsNotPressed) {
            this.showPopup(null, false);
        } else if (this.myPopupIsShowing && !insideRec) {
            JPopupMenu popup;
            Component over = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
            JPopupMenu jPopupMenu = popup = this.myUnderPopup.isShowing() ? this.myUnderPopup : this.myAbovePopup;
            if (over != null && popup.isShowing()) {
                Rectangle rec = new Rectangle(popup.getLocationOnScreen(), popup.getSize());
                int delta = 15;
                rec.x -= delta;
                rec.width += delta * 2;
                rec.y -= delta;
                rec.height += delta * 2;
                Point eventPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(eventPoint, e.getComponent());
                if (rec.contains(eventPoint)) {
                    return;
                }
            }
            this.closePopup();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += this.myMoreRec.width;
        JBInsets.addTo((Dimension)size, (Insets)this.myDownIconInsets);
        return size;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Insets insets = this.getInsets();
        this.myMoreRec.x = this.getSize().width - this.myMoreRec.width - insets.right + 8;
        this.myMoreRec.y = this.getHeight() / 2 - this.myMoreRec.height / 2;
        this.myMoreRecMouse = new Rectangle(this.myMoreRec.x - 8, 0, this.getWidth() - this.myMoreRec.x, this.getHeight());
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myMoreRec.x < event.getX()) {
            return this.myOptionTooltipText;
        }
        return super.getToolTipText(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.myMoreRecMouse.contains(e.getPoint())) {
            if (e.getID() == 501 && !this.myPopupIsShowing) {
                this.togglePopup();
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    public void togglePopup() {
        if (this.myPopupIsShowing) {
            this.closePopup();
        } else {
            this.showPopup(null, false);
        }
    }

    public void showPopup(final Action actionToSelect, final boolean ensureSelection) {
        if (this.myPopupIsShowing) {
            return;
        }
        this.myPopupIsShowing = true;
        Point loc = this.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle(loc);
        Dimension popupSize = this.myUnderPopup.getPreferredSize();
        Rectangle intersection = screen.intersection(new Rectangle(new Point(loc.x, loc.y + this.getHeight()), popupSize));
        boolean above = intersection.height < popupSize.height;
        int y = above ? this.getY() - popupSize.height : this.getY() + this.getHeight();
        final JPopupMenu popup = above ? this.myAbovePopup : this.myUnderPopup;
        final Ref listener = new Ref();
        listener.set((Object)new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (popup != null && listener.get() != null) {
                    popup.removePopupMenuListener((PopupMenuListener)listener.get());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JBOptionButton.this.myPopupIsShowing = false;
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popup.addPopupMenuListener((PopupMenuListener)listener.get());
        popup.show(this, 0, y);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuElement[] elements;
                if (popup == null || !popup.isShowing() || !JBOptionButton.this.myPopupIsShowing) {
                    return;
                }
                Action selection = actionToSelect;
                if (selection == null && JBOptionButton.this.myOptions.length > 0 && ensureSelection) {
                    selection = JBOptionButton.this.getAction();
                }
                if (selection == null) {
                    return;
                }
                for (MenuElement eachElement : elements = popup.getSubElements()) {
                    JMenuItem eachItem;
                    if (!(eachElement instanceof JMenuItem) || !selection.equals((eachItem = (JMenuItem)eachElement).getAction())) continue;
                    MenuSelectionManager mgr = MenuSelectionManager.defaultManager();
                    MenuElement[] path = new MenuElement[]{popup, eachItem};
                    mgr.setSelectedPath(path);
                    break;
                }
            }
        });
    }

    public void closePopup() {
        this.myUnderPopup.setVisible(false);
        this.myAbovePopup.setVisible(false);
    }

    private JPopupMenu fillMenu(boolean under) {
        JBPopupMenu result = new JBPopupMenu();
        if (under && this.myOptions.length > 0) {
            JBMenuItem jBMenuItem = new JBMenuItem(this.getAction());
            this.configureItem(this.getMenuInfo(this.getAction()), jBMenuItem);
            result.add(jBMenuItem);
            result.addSeparator();
        }
        for (Action each : this.myOptions) {
            if (this.getAction() == each) continue;
            OptionInfo info = this.getMenuInfo(each);
            JBMenuItem eachItem = new JBMenuItem(each);
            this.configureItem(info, eachItem);
            result.add(eachItem);
        }
        if (!under && this.myOptions.length > 0) {
            result.addSeparator();
            JBMenuItem jBMenuItem = new JBMenuItem(this.getAction());
            this.configureItem(this.getMenuInfo(this.getAction()), jBMenuItem);
            result.add(jBMenuItem);
        }
        return result;
    }

    private void configureItem(OptionInfo info, JMenuItem eachItem) {
        eachItem.setText(info.myPlainText);
        if (info.myMnemonic >= 0) {
            eachItem.setMnemonic(info.myMnemonic);
            eachItem.setDisplayedMnemonicIndex(info.myMnemonicIndex);
        }
        this.myOptionInfos.add(info);
    }

    public boolean isOkToProcessDefaultMnemonics() {
        return this.myOkToProcessDefaultMnemonics;
    }

    private OptionInfo getMenuInfo(Action each) {
        String text = (String)each.getValue("Name");
        int mnemonic = -1;
        int mnemonicIndex = -1;
        StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '&' || ch == '_') {
                if (i + 1 >= text.length()) continue;
                char mnemonicsChar = text.charAt(i + 1);
                mnemonic = Character.toUpperCase(mnemonicsChar);
                mnemonicIndex = i;
                continue;
            }
            plainText.append(ch);
        }
        return new OptionInfo(plainText.toString(), mnemonic, mnemonicIndex, this, each);
    }

    public Set<OptionInfo> getOptionInfos() {
        return this.myOptionInfos;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            int x = this.getWidth() - this.getInsets().right - 8;
            Icon icon = AllIcons.Mac.YosemiteOptionButtonSelector;
            int y = (this.getHeight() - icon.getIconHeight()) / 2;
            icon.paintIcon(this, g, x, y);
            return;
        }
        boolean dark = UIUtil.isUnderDarcula();
        int off = dark ? 6 : 0;
        AllIcons.General.ArrowDown.paintIcon(this, g, this.myMoreRec.x - off, this.myMoreRec.y);
        if (dark) {
            return;
        }
        Insets insets = this.getInsets();
        int y1 = this.myMoreRec.y - 2;
        int y2 = this.getHeight() - insets.bottom - 2;
        if (y1 < this.getInsets().top) {
            y1 = insets.top;
        }
        int x = this.myMoreRec.x - 4;
        UIUtil.drawDottedLine((Graphics2D)((Graphics2D)g), (int)x, (int)y1, (int)x, (int)y2, null, (Color)Color.darkGray);
    }

    public void setOptionTooltipText(String text) {
        this.myOptionTooltipText = text;
    }

    public void setOkToProcessDefaultMnemonics(boolean ok) {
        this.myOkToProcessDefaultMnemonics = ok;
    }

    public static class OptionInfo {
        String myPlainText;
        int myMnemonic;
        int myMnemonicIndex;
        JBOptionButton myButton;
        Action myAction;

        OptionInfo(String plainText, int mnemonic, int mnemonicIndex, JBOptionButton button, Action action) {
            this.myPlainText = plainText;
            this.myMnemonic = mnemonic;
            this.myMnemonicIndex = mnemonicIndex;
            this.myButton = button;
            this.myAction = action;
        }

        public String getPlainText() {
            return this.myPlainText;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public int getMnemonicIndex() {
            return this.myMnemonicIndex;
        }

        public JBOptionButton getButton() {
            return this.myButton;
        }

        public Action getAction() {
            return this.myAction;
        }
    }
}

