/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import java.text.MessageFormat;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jgit.dirCache.AddFile;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCachePackage$dirCacheEditor$74a8d23a;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.jgit.dirCache.PathEditBase;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"|\u0004)qA)\u001b:DC\u000eDW-\u00123ji>\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0005U\u001eLGO\u0003\u0005eSJ\u001c\u0015m\u00195f\u0015I\u0011\u0015m]3ESJ\u001c\u0015m\u00195f\u000b\u0012LGo\u001c:\u000b\u000f\u0015\u001cG.\u001b9tK*AA-\u001b:dC\u000eDWM\u0003\u0004=S:LGO\u0010\u0006\u0006K\u0012LGo\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0004l_Rd\u0017N\u001c\u0006\t!\u0006$\b.\u00123ji*Q!/\u001a9pg&$xN]=\u000b\u0015I+\u0007o\\:ji>\u0014\u0018PC\u0002mS\nT\u0001\u0002R5s\u0007\u0006\u001c\u0007.\u001a\u0006\u0019KN$\u0018.\\1uK\u0012tU/\u001c2fe>3WI\u001c;sS\u0016\u001c(bA%oi*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0015\u0005\u0004\b\u000f\\=FI&$8O\u0003\u0003V]&$(BB2p[6LGOC\u0004C_>dW-\u00198\u000b\r\u0019Lg.[:i-\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0003\t\u0001A1!\u0002\u0002\u0005\u0006!\rQA\u0001\u0003\u0004\u0011\u000f)1\u0001b\u0002\t\u00061\u0001Q!\u0001E\u0006\u000b\r!I\u0001C\u0003\r\u0001\u0015\u0019A1\u0001\u0005\u0007\u0019\u0001)!\u0001B\u0002\t\u0010\u0015\u0019AA\u0002\u0005\b\u0019\u0001)1\u0001b\u0002\t\u00111\u0001Qa\u0001C\u0005\u0011%a\u0001!B\u0001\t\u0014\u0015\u0011A\u0001\u0003\u0005\u000b\u000b\t!\t\u0002C\u0003\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u000fA\u0001\"B\u0002\u0005\n!YA\u0002A\u0003\u0004\t\u0013AA\u0002\u0004\u0001\u0005\u00071\u0011\u0011DA\u0003\u0002\u0011\u0011is\u0002B1\u00051\u0013\tc!B\u0001\t\u000b%\u0019\u0011BA\u0003\u0002\u0011\u0017)6\u0001B\u0003\u0004\t\u0013I\u0011\u0001C\u0005.\u0017\u0011\tG\u0001'\u0004\"\u0005\u0015\t\u0001RB+\u0004\t\u0015\u0019AQB\u0005\u0002\u0011'i\u001b\u0002B\u0001\u0019\u0016\u0005\u0012Q!\u0001E\u000b#\u000e\u0019AQC\u0005\u0002\t\u0001i\u001b\u0002B\u0006\u0019\u0018\u0005\u0012Q!\u0001\u0005\f#\u000e\u0019AqC\u0005\u0002\t\u0003i\u001b\u0002B\u0006\u0019\u001a\u0005\u0012Q!\u0001E\u000b#\u000e\u0019A\u0011D\u0005\u0002\t\u0001)T'\u0002\u001b\u0005G\u0004AB!(\u0006\u0005\u0001!%QBB\u0003\u0002\u0011\u0015I1!\u0003\u0002\u0006\u0003!-\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Ai\u0001UB\u0001;\u001b!\u0001\u0001\u0003\u0002\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0003u5A\u0001\u0001E\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0007\t#!B\u0001\t\u0005E\u001b1\u0002\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u00155\tAQ\u0001"})
public final class DirCacheEditor
extends BaseDirCacheEditor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final List<? extends PathEdit> edits;
    private final Repository repository;

    static {
        $kotlinClass = Reflection.createKotlinClass(DirCacheEditor.class);
    }

    public boolean commit() {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyEdits() {
        int maxIndex = this.cache.getEntryCount();
        int lastIndex = 0;
        block0: for (PathEdit pathEdit : this.edits) {
            int count;
            boolean missing;
            int entryIndex = this.cache.findEntry(pathEdit.getPath(), pathEdit.getPath().length);
            boolean bl = missing = entryIndex < 0;
            if (entryIndex < 0) {
                entryIndex = -(entryIndex + 1);
            }
            if ((count = Math.min(entryIndex, maxIndex) - lastIndex) > 0) {
                this.fastKeep(lastIndex, count);
            }
            int n = lastIndex = missing ? entryIndex : this.cache.nextEntry(entryIndex);
            if (pathEdit instanceof DeleteFile) continue;
            if (pathEdit instanceof DeleteDirectory) {
                lastIndex = this.cache.nextEntry(((PathEditBase)pathEdit).getPath(), ((PathEditBase)pathEdit).getPath().length, entryIndex);
                continue;
            }
            if (missing) {
                DirCacheEntry entry = new DirCacheEntry(pathEdit.getPath());
                pathEdit.apply(entry, this.repository);
                if (entry.getRawMode() == 0) {
                    throw (Throwable)new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, entry.getPathString()));
                }
                this.fastAdd(entry);
                continue;
            }
            if (pathEdit instanceof AddFile || pathEdit instanceof AddLoadedFile) {
                DirCacheEntry entry;
                DirCacheEntry firstEntry = this.cache.getEntry(entryIndex);
                if (firstEntry.isMerged()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)firstEntry, (String)"firstEntry");
                } else {
                    entry = new DirCacheEntry(pathEdit.getPath());
                    entry.setCreationTime(firstEntry.getCreationTime());
                }
                pathEdit.apply(entry, this.repository);
                this.fastAdd(entry);
                continue;
            }
            int firstEntry = entryIndex;
            int n2 = lastIndex - 1;
            if (firstEntry > n2) continue;
            while (true) {
                void i;
                DirCacheEntry entry;
                DirCacheEntry dirCacheEntry = entry = this.cache.getEntry((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)dirCacheEntry, (String)"entry");
                pathEdit.apply(dirCacheEntry, this.repository);
                this.fastAdd(entry);
                if (i == n2) continue block0;
                ++i;
            }
        }
        int n = maxIndex - lastIndex;
        if (n > 0) {
            this.fastKeep(lastIndex, n);
        }
    }

    public DirCacheEditor(@JetValueParameter(name="edits") @NotNull List<? extends PathEdit> edits, @JetValueParameter(name="repository") @NotNull Repository repository, @JetValueParameter(name="dirCache") @NotNull DirCache dirCache, @JetValueParameter(name="estimatedNumberOfEntries") int estimatedNumberOfEntries) {
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)dirCache, (String)"dirCache");
        super(dirCache, estimatedNumberOfEntries);
        this.repository = repository;
        this.edits = KotlinPackage.sortBy((Iterable)edits, DirCachePackage$dirCacheEditor$74a8d23a.getEDIT_CMP());
    }
}

