/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Ref;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigConstants;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class GitPackage$GitEx$3dc0a22d {
    public static final void wrapIfNeedAndReThrow(@JetValueParameter(name="e") @NotNull TransportException e) {
        String message;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANNOT_RESOLVE_REPO)) {
                    throw (Throwable)new NoRemoteRepositoryException(e);
                }
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                message = string;
                if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_AUTHORIZED) || Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) break block6;
                CharSequence charSequence = JGitText.get().notAuthorized;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"JGitText.get().notAuthorized");
                if (!KotlinPackage.contains$default((String)message, (CharSequence)charSequence, (boolean)false, (int)2) && !KotlinPackage.contains$default((String)message, (CharSequence)"Auth cancel", (boolean)false, (int)2) && !KotlinPackage.contains$default((String)message, (CharSequence)"Auth fail", (boolean)false, (int)2) && !KotlinPackage.contains$default((String)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2)) break block7;
            }
            throw (Throwable)new AuthenticationException(e);
        }
        if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.CANCELLED) || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final FetchResult fetch(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="remoteConfig") @NotNull RemoteConfig remoteConfig, @JetValueParameter(name="credentialsProvider", type="?") @Nullable CredentialsProvider credentialsProvider, @JetValueParameter(name="progressMonitor", type="?") @Nullable ProgressMonitor progressMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteConfig, (String)"remoteConfig");
        transport = Transport.open((Repository)$receiver, (RemoteConfig)remoteConfig);
        transport.setCredentialsProvider(credentialsProvider);
        v0 = progressMonitor;
        if (v0 == null) {
            v0 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
        }
        var5_5 = transport.fetch(v0, (Collection)null);
        transport.close();
        try {
            try {
                return var5_5;
            }
            catch (TransportException e) {
                v1 = e.getMessage();
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (!KotlinPackage.startsWith$default((String)(message = v1), (String)"Remote does not have ", (boolean)false, (int)2)) ** GOTO lbl24
                SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().info(message);
                var7_9 = null;
                return var7_9;
lbl24:
                // 1 sources

                GitPackage$GitEx$3dc0a22d.wrapIfNeedAndReThrow(e);
                var7_10 = null;
                transport.close();
                return var7_10;
            }
        }
        finally {
            transport.close();
        }
    }

    @Nullable
    public static /* synthetic */ FetchResult fetch$default(Repository repository, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitPackage$GitEx$3dc0a22d.fetch(repository, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(@JetValueParameter(name="$receiver") Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        config.setString(ConfigConstants.CONFIG_CORE_SECTION, (String)null, ConfigConstants.CONFIG_KEY_AUTOCRLF, ConfigConstants.CONFIG_KEY_FALSE);
        config.save();
        return $receiver;
    }

    @NotNull
    public static final Repository createBareRepository(@JetValueParameter(name="dir") @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build();
        repository.create(true);
        Repository repository2 = repository;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository2, (String)"repository");
        return repository2;
    }

    @NotNull
    public static final Repository createRepository(@JetValueParameter(name="dir") @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(dir)).build();
        repository.create();
        Repository repository2 = repository;
        Intrinsics.checkExpressionValueIsNotNull((Object)repository2, (String)"repository");
        return repository2;
    }

    @NotNull
    public static final RevCommit commit(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="message", type="?") @Nullable String message, @JetValueParameter(name="reflogComment", type="?") @Nullable String reflogComment, @JetValueParameter(name="author", type="?") @Nullable PersonIdent author, @JetValueParameter(name="committer", type="?") @Nullable PersonIdent committer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CommitCommand commitCommand = new CommitCommand($receiver).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        RevCommit revCommit = commitCommand.call();
        Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"commitCommand.call()");
        return revCommit;
    }

    @NotNull
    public static /* synthetic */ RevCommit commit$default(Repository repository, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitPackage$GitEx$3dc0a22d.commit(repository, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(@JetValueParameter(name="$receiver") Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ResetCommand resetCommand = new ResetCommand($receiver).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(@JetValueParameter(name="$receiver") Config $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String name = $receiver.getString(ConfigConstants.CONFIG_BRANCH_SECTION, Constants.MASTER, ConfigConstants.CONFIG_KEY_MERGE);
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public static final StoredConfig setUpstream(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="url", type="?") @Nullable String url, @JetValueParameter(name="branchName") @NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String localBranchName = Constants.MASTER;
        StoredConfig config = $receiver.getConfig();
        String remoteName = Constants.DEFAULT_REMOTE_NAME;
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug("Unset remote");
            config.unsetSection(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName);
            config.unsetSection(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName);
        } else {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug("Set remote " + url);
            config.setString(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName, ConfigConstants.CONFIG_KEY_URL, url);
            config.setString(ConfigConstants.CONFIG_REMOTE_SECTION, remoteName, ConfigConstants.CONFIG_FETCH_SECTION, KotlinPackage.plus((char)'+', (String)Constants.R_HEADS) + branchName + ':' + Constants.R_REMOTES + remoteName + '/' + branchName);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName, ConfigConstants.CONFIG_KEY_REMOTE, remoteName);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, localBranchName, ConfigConstants.CONFIG_KEY_MERGE, Constants.R_HEADS + branchName);
        }
        config.save();
        StoredConfig storedConfig = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)storedConfig, (String)"config");
        return storedConfig;
    }

    @NotNull
    public static /* synthetic */ StoredConfig setUpstream$default(Repository repository, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Constants.MASTER;
        }
        return GitPackage$GitEx$3dc0a22d.setUpstream(repository, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(@JetValueParameter(name="$receiver") Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileTreeIterator workingTreeIterator = new FileTreeIterator($receiver);
        try {
            IndexDiff indexDiff = new IndexDiff($receiver, Constants.HEAD, (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final Repository cloneBare(@JetValueParameter(name="uri") @NotNull String uri, @JetValueParameter(name="dir") @NotNull File dir, @JetValueParameter(name="credentialsStore", type="?") @Nullable NotNullLazyValue<CredentialsStore> credentialsStore, @JetValueParameter(name="progressMonitor") @NotNull ProgressMonitor progressMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)progressMonitor, (String)"progressMonitor");
        repository = GitPackage$GitEx$3dc0a22d.createBareRepository(dir);
        config = GitPackage$GitEx$3dc0a22d.setUpstream$default(repository, uri, null, 2);
        remoteConfig = new RemoteConfig((Config)config, Constants.DEFAULT_REMOTE_NAME);
        v0 = GitPackage$GitEx$3dc0a22d.fetch(repository, remoteConfig, credentialsStore == null ? (JGitCredentialsProvider)null : new JGitCredentialsProvider(credentialsStore, repository), progressMonitor);
        if (v0 == null) {
            return repository;
        }
        result = v0;
        var8_8 = new Ref.ObjectRef();
        var8_8.element = GitPackage$GitEx$3dc0a22d.findBranchToCheckout(result);
        if ((Ref)head.element == null) {
            branch = Constants.HEAD;
            v1 = result.getAdvertisedRef(branch);
            if (v1 == null) {
                v1 = v2 /* !! */  = result.getAdvertisedRef(Constants.R_HEADS + branch);
            }
            if (v1 == null) {
                v2 /* !! */  = head.element = result.getAdvertisedRef(Constants.R_TAGS + branch);
            }
        }
        if ((Ref)head.element == null || ((Ref)head.element).getObjectId() == null) {
            return repository;
        }
        if (KotlinPackage.startsWith$default((String)((Ref)head.element).getName(), (String)Constants.R_HEADS, (boolean)false, (int)2)) {
            newHead = repository.updateRef(Constants.HEAD);
            newHead.disableRefLog();
            newHead.link(((Ref)head.element).getName());
            branchName = Repository.shortenRefName((String)((Ref)head.element).getName());
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_REMOTE, Constants.DEFAULT_REMOTE_NAME);
            config.setString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_MERGE, ((Ref)head.element).getName());
            autoSetupRebase = config.getString(ConfigConstants.CONFIG_BRANCH_SECTION, (String)null, ConfigConstants.CONFIG_KEY_AUTOSETUPREBASE);
            if (Intrinsics.areEqual((Object)ConfigConstants.CONFIG_KEY_ALWAYS, (Object)autoSetupRebase) || Intrinsics.areEqual((Object)ConfigConstants.CONFIG_KEY_REMOTE, (Object)autoSetupRebase)) {
                config.setBoolean(ConfigConstants.CONFIG_BRANCH_SECTION, (String)branchName, ConfigConstants.CONFIG_KEY_REBASE, true);
            }
            config.save();
        }
        branchName = (Closeable)new RevWalk(repository);
        closed = false;
        try {
            it = (RevWalk)$receiver;
            v3 = (Ref)head.element;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            it = it.parseCommit((AnyObjectId)v3.getObjectId());
            ** try [egrp 1[TRYBLOCK] [4 : 487->519)] { 
        }
lbl59:
        // 1 sources

        catch (Throwable var12_15) {
            throw var12_15;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                v4 = it;
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                InlineMarker.goToTryCatchBlockEnd();
                throw (Throwable)e;
            }
        }
        commit = (RevCommit)v4;
        v5 = (Ref)head.element;
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        u = repository.updateRef(Constants.HEAD, KotlinPackage.startsWith$default((String)v5.getName(), (String)Constants.R_HEADS, (boolean)false, (int)2) == false);
        u.setNewObjectId((AnyObjectId)commit.getId());
        u.forceUpdate();
        return repository;
    }

    @NotNull
    public static /* synthetic */ Repository cloneBare$default(String string, File file, NotNullLazyValue notNullLazyValue, ProgressMonitor progressMonitor, int n) {
        if ((n & 4) != 0) {
            notNullLazyValue = null;
        }
        if ((n & 8) != 0) {
            NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullProgressMonitor, (String)"NullProgressMonitor.INSTANCE");
            progressMonitor = (ProgressMonitor)nullProgressMonitor;
        }
        return GitPackage$GitEx$3dc0a22d.cloneBare(string, file, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor);
    }

    @Nullable
    public static final Ref findBranchToCheckout(@JetValueParameter(name="result") @NotNull FetchResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Ref ref = result.getAdvertisedRef(Constants.HEAD);
        if (ref == null) {
            return null;
        }
        Ref idHead = ref;
        Ref master = result.getAdvertisedRef(Constants.R_HEADS + Constants.MASTER);
        if (master != null && master.getObjectId().equals((AnyObjectId)idHead.getObjectId())) {
            return master;
        }
        for (Ref r : result.getAdvertisedRefs()) {
            if (!KotlinPackage.startsWith$default((String)r.getName(), (String)Constants.R_HEADS, (boolean)false, (int)2) || !r.getObjectId().equals((AnyObjectId)idHead.getObjectId())) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final void processChildren(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="filter", type="?") @Nullable Function1<? super String, ? extends Boolean> filter, @JetValueParameter(name="processor") @NotNull Function2<? super String, ? super InputStream, ? extends Boolean> processor) {
        block15: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            v0 = $receiver.resolve(Constants.HEAD);
            if (v0 == null) {
                return;
            }
            lastCommitId = v0;
            reader = $receiver.newObjectReader();
            var6_6 = (Closeable)reader;
            closed = false;
            it = (ObjectReader)$receiver;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) != null) ** GOTO lbl20
            if (closed) break block15;
            $receiver.close();
            return;
lbl20:
            // 1 sources

            treeWalk = v1;
            if (treeWalk.isSubtree()) ** GOTO lbl27
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn("File " + path + " is not a directory");
            if (closed) break block15;
            $receiver.close();
            return;
lbl27:
            // 1 sources

            treeWalk.setFilter(TreeFilter.ALL);
            treeWalk.enterSubtree();
            while (treeWalk.next()) {
                fileMode = treeWalk.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                fileName = treeWalk.getNameString();
                if (filter != null) {
                    v2 = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"fileName");
                    if (!((Boolean)filter.invoke((Object)v2)).booleanValue()) continue;
                }
                if ((objectLoader = reader.open((AnyObjectId)treeWalk.getObjectId(0), Constants.OBJ_BLOB)).getSize() == 0L) {
                    SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                v3 = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"fileName");
                v4 = objectLoader.openStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"objectLoader.openStream()");
                if (((Boolean)processor.invoke((Object)v3, (Object)v4)).booleanValue()) continue;
                break;
            }
            it = Unit.INSTANCE$;
        }
        try {
            try {
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                InlineMarker.goToTryCatchBlockEnd();
                throw (Throwable)e;
            }
        }
        catch (Throwable var8_10) {
            throw var8_10;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
    }

    public static /* synthetic */ void processChildren$default(Repository repository, String string, Function1 function1, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitPackage$GitEx$3dc0a22d.processChildren(repository, string, (Function1<? super String, ? extends Boolean>)function1, (Function2<? super String, ? super InputStream, ? extends Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static final InputStream read(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="path") @NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ObjectId lastCommitId = $receiver.resolve(Constants.HEAD);
        if (lastCommitId == null) {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn("Repository " + $receiver.getDirectory().getName() + " doesn't have HEAD");
            return null;
        }
        ObjectReader reader = $receiver.newObjectReader();
        boolean releaseReader = true;
        try {
            TreeWalk treeWalk;
            if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) == null) {
                inputStream = null;
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), Constants.OBJ_BLOB);
            ObjectStream input = objectLoader.openStream();
            if (objectLoader.isLarge()) {
                releaseReader = false;
                InputStream inputStream2 = (InputStream)input;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"input");
                ObjectReader objectReader = reader;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectReader, (String)"reader");
                InputStream inputStream3 = new InputStreamWrapper(inputStream2, objectReader);
                return inputStream3;
            }
            InputStream inputStream4 = (InputStream)input;
            return inputStream4;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!releaseReader) return inputStream;
            reader.close();
        }
    }

    public static final byte[] getCachedBytes(@JetValueParameter(name="$receiver") ObjectReader $receiver, @JetValueParameter(name="dirCacheEntry") @NotNull DirCacheEntry dirCacheEntry) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dirCacheEntry, (String)"dirCacheEntry");
        return $receiver.open((AnyObjectId)dirCacheEntry.getObjectId(), Constants.OBJ_BLOB).getCachedBytes();
    }

    public static final int getAheadCommitsCount(@JetValueParameter(name="$receiver") Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StoredConfig config = $receiver.getConfig();
        String shortBranchName = Repository.shortenRefName((String)GitPackage$GitEx$3dc0a22d.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $receiver.getRef(trackingBranch);
        if (ref == null) {
            return -1;
        }
        Ref tracking = ref;
        Ref ref2 = $receiver.getRef(Constants.R_HEADS + shortBranchName);
        if (ref2 == null) {
            return -1;
        }
        Ref local = ref2;
        RevWalk walk = new RevWalk($receiver);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        RevCommit trackingCommit = walk.parseCommit((AnyObjectId)tracking.getObjectId());
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(localCommit);
        walk.markStart(trackingCommit);
        RevCommit mergeBase = walk.next();
        walk.reset();
        walk.setRevFilter(RevFilter.ALL);
        return RevWalkUtils.count((RevWalk)walk, (RevCommit)localCommit, (RevCommit)mergeBase);
    }
}

