/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.dependency.Dependency;
import com.android.tools.idea.gradle.dependency.DependencySet;
import com.android.tools.idea.gradle.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.dependency.LibraryDependency;
import com.android.tools.idea.gradle.dependency.ModuleDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.base.Objects;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<IdeaAndroidProject>
implements BuildVariantModuleCustomizer<IdeaAndroidProject> {
    @Override
    protected void setUpDependencies(@NotNull ModifiableRootModel moduleModel, @NotNull IdeaAndroidProject androidProject) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        DependencySet dependencies = Dependency.extractFrom(androidProject);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            DependenciesModuleCustomizer.updateLibraryDependency(moduleModel, libraryDependency, androidProject.getDelegate());
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(moduleModel, moduleDependency, androidProject.getDelegate());
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(moduleModel.getProject());
        Collection<SyncIssue> collection = androidProject.getSyncIssues();
        if (collection != null) {
            messages.reportSyncIssues(collection, moduleModel.getModule());
        } else {
            Collection unresolvedDependencies = androidProject.getDelegate().getUnresolvedDependencies();
            messages.reportUnresolvedDependencies(unresolvedDependencies, moduleModel.getModule());
        }
    }

    private void updateModuleDependency(@NotNull ModifiableRootModel moduleModel, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)moduleModel.getProject());
        Module moduleDependency = null;
        for (Module module : moduleManager.getModules()) {
            String gradlePath;
            AndroidGradleFacet androidGradleFacet = AndroidGradleFacet.getInstance(module);
            if (androidGradleFacet == null || !Objects.equal((Object)(gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH), (Object)dependency.getGradlePath())) continue;
            moduleDependency = module;
            break;
        }
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = moduleModel.addModuleOrderEntry(moduleDependency);
            orderEntry.setExported(true);
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        DependencySetupErrors setupErrors = this.getSetupErrors(moduleModel.getProject());
        setupErrors.addMissingModule(dependency.getGradlePath(), moduleModel.getModule().getName(), backupName);
        if (compiledArtifact != null) {
            DependenciesModuleCustomizer.updateLibraryDependency(moduleModel, compiledArtifact, androidProject);
        }
    }

    public static void updateLibraryDependency(@NotNull ModifiableRootModel moduleModel, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        Collection<String> binaryPaths = dependency.getPaths(LibraryDependency.PathType.BINARY);
        DependenciesModuleCustomizer.setUpLibraryDependency(moduleModel, dependency.getName(), dependency.getScope(), binaryPaths);
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = moduleModel.getContentEntries();
        for (String binaryPath : binaryPaths) {
            ContentEntry parentContentEntry;
            File parent = new File(binaryPath).getParentFile();
            if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
            parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<IdeaAndroidProject> getSupportedModelType() {
        if (IdeaAndroidProject.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getSupportedModelType"));
        }
        return IdeaAndroidProject.class;
    }
}

