/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<IdeaJavaProject> {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;

    @Override
    protected void setUpDependencies(@NotNull ModifiableRootModel moduleModel, @NotNull IdeaJavaProject javaProject) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        ArrayList unresolved = Lists.newArrayList();
        for (JavaModuleDependency javaModuleDependency : javaProject.getJavaModuleDependencies()) {
            this.updateDependency(moduleModel, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaProject.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(moduleModel, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        Module module = moduleModel.getModule();
        ProjectSyncMessages projectSyncMessages = ProjectSyncMessages.getInstance(moduleModel.getProject());
        projectSyncMessages.reportUnresolvedDependencies(unresolved, module);
        JavaGradleFacet facet = DependenciesModuleCustomizer.setAndGetJavaGradleFacet(module);
        File buildFolderPath = javaProject.getBuildFolderPath();
        if (!Projects.isGradleProjectModule(module)) {
            JavaModel javaModel = new JavaModel(unresolved, buildFolderPath);
            facet.setJavaModel(javaModel);
        }
        JavaGradleFacetConfiguration facetProperties = (JavaGradleFacetConfiguration)facet.getConfiguration();
        facetProperties.BUILD_FOLDER_PATH = buildFolderPath != null ? FileUtil.toSystemIndependentName((String)buildFolderPath.getPath()) : "";
        facetProperties.BUILDABLE = javaProject.isBuildable();
    }

    private void updateDependency(@NotNull ModifiableRootModel moduleModel, @NotNull JavaModuleDependency dependency) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        DependencySetupErrors setupErrors = this.getSetupErrors(moduleModel.getProject());
        String moduleName = dependency.getModuleName();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)moduleModel.getProject());
        Module found = null;
        for (Module module : moduleManager.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            found = module;
        }
        if (found != null) {
            ModuleOrderEntry orderEntry = moduleModel.addModuleOrderEntry(found);
            orderEntry.setExported(true);
            DependencyScope scope = DependenciesModuleCustomizer.parseScope(dependency.getScope());
            orderEntry.setScope(scope);
            return;
        }
        setupErrors.addMissingModule(moduleName, moduleModel.getModule().getName(), null);
    }

    private void updateDependency(@NotNull ModifiableRootModel moduleModel, @NotNull JarLibraryDependency dependency) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "updateDependency"));
        }
        DependencyScope scope = DependenciesModuleCustomizer.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupErrors setupErrors = this.getSetupErrors(moduleModel.getProject());
            setupErrors.addMissingBinaryPath(moduleModel.getModule().getName());
            return;
        }
        String path = binaryPath.getPath();
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)path);
        DependenciesModuleCustomizer.setUpLibraryDependency(moduleModel, name, scope, Collections.singletonList(path), DependenciesModuleCustomizer.asPaths(dependency.getSourcePath()), DependenciesModuleCustomizer.asPaths(dependency.getJavadocPath()));
    }

    @NotNull
    private static List<String> asPaths(@Nullable File file) {
        List<String> list = file == null ? Collections.emptyList() : Collections.singletonList(file.getPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "asPaths"));
        }
        return list;
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "parseScope"));
        }
        return dependencyScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static JavaGradleFacet setAndGetJavaGradleFacet(Module module) {
        JavaGradleFacet facet = JavaGradleFacet.getInstance(module);
        if (facet != null) {
            JavaGradleFacet javaGradleFacet = facet;
            if (javaGradleFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
            }
            return javaGradleFacet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        try {
            facet = (JavaGradleFacet)facetManager.createFacet((FacetType)JavaGradleFacet.getFacetType(), "Java-Gradle", null);
            model.addFacet((Facet)facet);
        }
        finally {
            model.commit();
        }
        JavaGradleFacet javaGradleFacet = facet;
        if (javaGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/DependenciesModuleCustomizer", "setAndGetJavaGradleFacet"));
        }
        return javaGradleFacet;
    }
}

