/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.editor.GradleFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GradleFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String EDITOR_TYPE_ID = "android-gradle-editor";
    private static final boolean ENABLED = Boolean.getBoolean("new.android.gradle.editor.active");

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "accept"));
        }
        if (!ENABLED) {
            return false;
        }
        return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && file.getPath().endsWith(".gradle");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "createEditor"));
        }
        GradleFileEditor gradleFileEditor = new GradleFileEditor(file, project);
        if (gradleFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "createEditor"));
        }
        return gradleFileEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "disposeEditor"));
        }
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "getEditorTypeId"));
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/GradleFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

