/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.ArtifactsByConfigurationModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.JavaLanguageLevelModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JavaProjectDataService
implements ProjectDataService<IdeaJavaProject, Void> {
    private static final Logger LOG = Logger.getInstance(JavaProjectDataService.class);
    private final List<ModuleCustomizer<IdeaJavaProject>> myCustomizers = ImmutableList.of((Object)new JavaLanguageLevelModuleCustomizer(), (Object)new ContentRootModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer(), (Object)new ArtifactsByConfigurationModuleCustomizer());

    @NotNull
    public Key<IdeaJavaProject> getTargetDataKey() {
        Key<IdeaJavaProject> key = AndroidProjectKeys.IDE_JAVA_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/JavaProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaJavaProject>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/JavaProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/JavaProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                this.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up Java modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private void doImport(final Collection<DataNode<IdeaJavaProject>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Map gradleProjectsByName = JavaProjectDataService.indexByModuleName(toImport);
                    for (Module module : moduleManager.getModules()) {
                        IdeaJavaProject javaProject = (IdeaJavaProject)gradleProjectsByName.get(module.getName());
                        if (javaProject == null) continue;
                        JavaProjectDataService.this.customizeModule(module, javaProject);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, IdeaJavaProject> indexByModuleName(@NotNull Collection<DataNode<IdeaJavaProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/JavaProjectDataService", "indexByModuleName"));
        }
        HashMap javaProjectsByModuleName = Maps.newHashMap();
        for (DataNode<IdeaJavaProject> d : dataNodes) {
            IdeaJavaProject javaProject = (IdeaJavaProject)d.getData();
            javaProjectsByModuleName.put(javaProject.getModuleName(), javaProject);
        }
        HashMap hashMap = javaProjectsByModuleName;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/JavaProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customizeModule(@NotNull Module module, @NotNull IdeaJavaProject javaProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/JavaProjectDataService", "customizeModule"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/service/JavaProjectDataService", "customizeModule"));
        }
        if (javaProject.isAndroidProjectWithoutVariants()) {
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
            String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
            messages.add(new Message("Project structure issues", Message.Type.ERROR, text), new NotificationHyperlink[0]);
            JavaProjectDataService.cleanUpAndroidModuleWithoutVariants(module);
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            for (ModuleCustomizer<IdeaJavaProject> customizer : this.myCustomizers) {
                customizer.customizeModule(module.getProject(), rootModel, javaProject);
            }
        }
        finally {
            rootModel.commit();
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/JavaProjectDataService", "cleanUpAndroidModuleWithoutVariants"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            ModifiableFacetModel facetModel = FacetManager.getInstance((Module)module).createModifiableModel();
            facetModel.removeFacet((Facet)facet);
            facetModel.commit();
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
        rootModel.commit();
    }

    public void removeData(@NotNull Collection<? extends Void> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/gradle/service/JavaProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/JavaProjectDataService", "removeData"));
        }
    }
}

