/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.actions;

import com.android.tools.idea.monitor.DeviceSampler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import org.jetbrains.annotations.NotNull;

public class RecordingAction
extends ToggleAction {
    @NotNull
    private final DeviceSampler myDeviceSampler;

    public RecordingAction(@NotNull DeviceSampler deviceSampler) {
        if (deviceSampler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceSampler", "com/android/tools/idea/monitor/actions/RecordingAction", "<init>"));
        }
        super(null, null, AllIcons.Actions.Pause);
        this.myDeviceSampler = deviceSampler;
    }

    public boolean isSelected(AnActionEvent e) {
        return !this.myDeviceSampler.isRunning();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/monitor/actions/RecordingAction", "update"));
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.isSelected(e)) {
            presentation.setText("Pause");
            presentation.setDescription("Pauses " + this.myDeviceSampler.getDescription() + " recording.");
        } else {
            presentation.setText("Resume");
            presentation.setDescription("Resumes " + this.myDeviceSampler.getDescription() + " recording.");
        }
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            this.myDeviceSampler.stop();
        } else {
            this.myDeviceSampler.start();
        }
    }
}

