/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesAnchorizer;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertyStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final ResourceBundle myResourceBundle;
    @NotNull
    private final PropertiesAnchorizer.PropertyAnchor myAnchor;
    private String myPresentableName;
    private static final TextAttributesKey INCOMPLETE_PROPERTY_KEY;
    private static final TextAttributesKey INCOMPLETE_GROUP_KEY;
    private static final TextAttributesKey GROUP_KEY;
    public static final String PROPERTY_GROUP_KEY_TEXT = "<property>";

    public ResourceBundlePropertyStructureViewElement(ResourceBundle resourceBundle, @NotNull PropertiesAnchorizer.PropertyAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "<init>"));
        }
        this.myResourceBundle = resourceBundle;
        this.myAnchor = anchor;
    }

    public IProperty getProperty() {
        return this.getValue().getRepresentative();
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        IProperty[] iPropertyArray = new IProperty[]{this.getProperty()};
        if (iPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getProperties"));
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public PropertiesAnchorizer.PropertyAnchor getValue() {
        return this.myAnchor;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return ResourceBundlePropertyStructureViewElement.this.myPresentableName == null ? ResourceBundlePropertyStructureViewElement.this.getProperty().getName() : (ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty() ? ResourceBundlePropertyStructureViewElement.PROPERTY_GROUP_KEY_TEXT : ResourceBundlePropertyStructureViewElement.this.myPresentableName);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PlatformIcons.PROPERTY_ICON;
            }

            public TextAttributesKey getTextAttributesKey() {
                if (ResourceBundlePropertyStructureViewElement.this.myPresentableName != null && ResourceBundlePropertyStructureViewElement.this.myPresentableName.isEmpty()) {
                    return PropertiesUtil.isPropertyComplete(ResourceBundlePropertyStructureViewElement.this.myResourceBundle, ResourceBundlePropertyStructureViewElement.this.getProperty().getName()) ? GROUP_KEY : INCOMPLETE_GROUP_KEY;
                }
                return PropertiesUtil.isPropertyComplete(ResourceBundlePropertyStructureViewElement.this.myResourceBundle, ResourceBundlePropertyStructureViewElement.this.getProperty().getName()) ? PropertiesHighlighter.PROPERTY_KEY : INCOMPLETE_PROPERTY_KEY;
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundlePropertyStructureViewElement", "getPresentation"));
        }
        return coloredItemPresentation;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static {
        TextAttributes incompleteKeyTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        incompleteKeyTextAttributes.setForegroundColor((Color)JBColor.RED);
        INCOMPLETE_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"INCOMPLETE_PROPERTY_KEY", (TextAttributes)incompleteKeyTextAttributes);
        TextAttributes groupKeyTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        groupKeyTextAttributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"GROUP_KEY", (TextAttributes)groupKeyTextAttributes);
        TextAttributes incompleteGroupKeyTextAttribute = groupKeyTextAttributes.clone();
        incompleteGroupKeyTextAttribute.setForegroundColor((Color)JBColor.RED);
        INCOMPLETE_GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"INCOMPLETE_GROUP_KEY", (TextAttributes)incompleteGroupKeyTextAttribute);
    }
}

