/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.Couple;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class AfterTestEvent
extends AbstractTestEvent {
    public AfterTestEvent(GradleTestsExecutionConsoleManager consoleManager) {
        super(consoleManager);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        String testId = this.getTestId(eventXml);
        String startTime = eventXml.queryXml("/ijLog/event/test/result/@startTime");
        String endTime = eventXml.queryXml("/ijLog/event/test/result/@endTime");
        final String exceptionMsg = eventXml.queryXml("/ijLog/event/test/result/errorMsg");
        final String stackTrace = eventXml.queryXml("/ijLog/event/test/result/stackTrace");
        final SMTestProxy testProxy = this.getConsoleManager().getTestsMap().get(testId);
        if (testProxy == null) {
            return;
        }
        try {
            testProxy.setDuration(Long.valueOf(endTime) - Long.valueOf(startTime));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TestEventResult result = this.getTestEventResultType(eventXml);
        switch (result) {
            case SUCCESS: {
                this.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        testProxy.setFinished();
                        AfterTestEvent.this.getResultsViewer().onTestFinished(testProxy);
                    }
                });
                break;
            }
            case FAILURE: {
                final String failureType = eventXml.queryXml("/ijLog/event/test/result/failureType");
                if ("comparison".equals(failureType)) {
                    String actualText = eventXml.queryXml("/ijLog/event/test/result/actual");
                    String expectedText = eventXml.queryXml("/ijLog/event/test/result/expected");
                    testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, actualText, expectedText);
                } else {
                    Couple<String> comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n");
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: is \"(.*)\"\n\\s*but: was \"(.*)\"");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: (.*)\n\\s*got: (.*)");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\\s*expected same:<(.*)> was not:<(.*)>");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, ".*\\s*expected:<(.*)> but was:<(.*)>");
                    }
                    if (comparisonPair == null) {
                        comparisonPair = AfterTestEvent.parseComparisonMessage(exceptionMsg, "\nExpected: \"(.*)\"\n\\s*but: was \"(.*)\"");
                    }
                    final Couple<String> finalComparisonPair = comparisonPair;
                    this.addToInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (finalComparisonPair != null) {
                                testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, (String)finalComparisonPair.second, (String)finalComparisonPair.first);
                            } else {
                                testProxy.setTestFailed(exceptionMsg, stackTrace, "error".equals(failureType));
                            }
                        }
                    });
                }
                this.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AfterTestEvent.this.getResultsViewer().onTestFailed(testProxy);
                    }
                });
                break;
            }
            case SKIPPED: {
                testProxy.setTestIgnored(null, null);
                this.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AfterTestEvent.this.getResultsViewer().onTestIgnored(testProxy);
                    }
                });
                break;
            }
        }
    }

    private static Couple<String> parseComparisonMessage(String message, String regex) {
        Matcher matcher = Pattern.compile(regex, 34).matcher(message);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1).replaceAll("\\\\n", "\n"), (Object)matcher.group(2).replaceAll("\\\\n", "\n"));
        }
        return null;
    }
}

