/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class CompilerEnvironment {
    private final KotlinPaths kotlinPaths;
    private final ClassCondition classesToLoadByParent;
    private final Services services;

    @NotNull
    public static CompilerEnvironment getEnvironmentFor(@NotNull KotlinPaths kotlinPaths, @NotNull ClassCondition classesToLoadByParent, @NotNull Services compilerServices) {
        if (kotlinPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinPaths", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getEnvironmentFor"));
        }
        if (classesToLoadByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesToLoadByParent", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getEnvironmentFor"));
        }
        if (compilerServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerServices", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getEnvironmentFor"));
        }
        CompilerEnvironment compilerEnvironment = new CompilerEnvironment(kotlinPaths, classesToLoadByParent, compilerServices);
        if (compilerEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getEnvironmentFor"));
        }
        return compilerEnvironment;
    }

    private CompilerEnvironment(@NotNull KotlinPaths kotlinPaths, @NotNull ClassCondition classesToLoadByParent, @NotNull Services services) {
        if (kotlinPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinPaths", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "<init>"));
        }
        if (classesToLoadByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesToLoadByParent", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "<init>"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "<init>"));
        }
        this.kotlinPaths = kotlinPaths;
        this.classesToLoadByParent = classesToLoadByParent;
        this.services = services;
    }

    public boolean success() {
        return this.kotlinPaths.getHomePath().exists();
    }

    @NotNull
    public KotlinPaths getKotlinPaths() {
        KotlinPaths kotlinPaths = this.kotlinPaths;
        if (kotlinPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getKotlinPaths"));
        }
        return kotlinPaths;
    }

    @NotNull
    public ClassCondition getClassesToLoadByParent() {
        ClassCondition classCondition = this.classesToLoadByParent;
        if (classCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getClassesToLoadByParent"));
        }
        return classCondition;
    }

    public void reportErrorsTo(@NotNull MessageCollector messageCollector) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "reportErrorsTo"));
        }
        if (!this.kotlinPaths.getHomePath().exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Cannot find kotlinc home: " + this.kotlinPaths.getHomePath() + ". Make sure plugin is properly installed, " + "or specify " + "jps.kotlin.home" + " system property", CompilerMessageLocation.NO_LOCATION);
        }
    }

    @NotNull
    public Services getServices() {
        Services services = this.services;
        if (services == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/CompilerEnvironment", "getServices"));
        }
        return services;
    }
}

