/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Make Inferred Annotations Explicit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "getFamilyName"));
        }
        return "Make Inferred Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Object[] annotations;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "isAvailable"));
        }
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner != null && owner.isWritable() && owner.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && (annotations = InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)).length > 0) {
            String annos = StringUtil.join((Object[])annotations, (Function)new Function<PsiAnnotation, String>(){

                public String fun(PsiAnnotation annotation) {
                    PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
                    String name = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                    return "@" + name + annotation.getParameterList().getText();
                }
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "invoke"));
        }
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        assert (owner != null);
        final PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)) {
            final PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project, Collections.singleton(module), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

                        @Override
                        public void run() {
                            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)toInsert, null));
                        }
                    });
                }
            });
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "correctAnnotation"));
        }
        Project project = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "correctAnnotation"));
            }
            return psiAnnotation;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "correctAnnotation"));
            }
            return psiAnnotation;
        }
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/MakeInferredAnnotationExplicit", "correctAnnotation"));
        }
        return psiAnnotation;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

