/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public class DefaultInsertHandler
implements InsertHandler {
    public static final DefaultInsertHandler NO_TAIL_HANDLER = new DefaultInsertHandler(){

        @Override
        protected TailType getTailType(char completionChar, LookupItem item) {
            return TailType.NONE;
        }
    };

    public void handleInsert(InsertionContext context, LookupElement lookupElement) {
        LookupItem item = (LookupItem)lookupElement;
        char completionChar = context.getCompletionChar();
        Project project = context.getProject();
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        TailType tailType = this.getTailType(completionChar, item);
        InsertHandlerState state = new InsertHandlerState(context.getSelectionEndOffset(), context.getSelectionEndOffset());
        if (completionChar == '\t') {
            DefaultInsertHandler.removeEndOfIdentifier(context);
        } else if (context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != context.getSelectionEndOffset()) {
            JavaCompletionUtil.resetParensInfo(context.getOffsetMap());
        }
        DefaultInsertHandler.handleParentheses(false, false, tailType, context, state);
        context.setTailOffset(state.tailOffset);
        state.caretOffset = DefaultInsertHandler.processTail(tailType, state.caretOffset, state.tailOffset, editor);
        editor.getSelectionModel().removeSelection();
        if (tailType == TailType.DOT || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
        }
    }

    private static void handleParentheses(boolean hasParams, boolean needParenth, TailType tailType, InsertionContext context, InsertHandlerState myState) {
        boolean insertRightParenth;
        Document document = context.getEditor().getDocument();
        boolean bl = insertRightParenth = context.getCompletionChar() != '\r';
        if (needParenth) {
            if (context.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) >= 0 && context.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET) >= 0) {
                myState.tailOffset = context.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET);
                if (context.getOffsetMap().getOffset(JavaCompletionUtil.RPAREN_OFFSET) < 0 && insertRightParenth) {
                    document.insertString(myState.tailOffset, (CharSequence)")");
                    ++myState.tailOffset;
                }
                myState.caretOffset = hasParams ? context.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) + 1 : context.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET);
            } else {
                CommonCodeStyleSettings styleSettings = context.getCodeStyleSettings();
                myState.tailOffset = context.getSelectionEndOffset();
                myState.caretOffset = context.getSelectionEndOffset();
                if (styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES) {
                    document.insertString(myState.tailOffset++, (CharSequence)" ");
                    ++myState.caretOffset;
                }
                if (insertRightParenth) {
                    CharSequence charsSequence = document.getCharsSequence();
                    if (charsSequence.length() <= myState.tailOffset || charsSequence.charAt(myState.tailOffset) != '(') {
                        document.insertString(myState.tailOffset, (CharSequence)"(");
                    }
                    document.insertString(myState.tailOffset + 1, (CharSequence)")");
                    if (hasParams) {
                        myState.tailOffset += 2;
                        ++myState.caretOffset;
                    } else if (tailType != TailTypes.CALL_RPARENTH) {
                        myState.tailOffset += 2;
                        myState.caretOffset += 2;
                    } else {
                        ++myState.tailOffset;
                        ++myState.caretOffset;
                    }
                } else {
                    document.insertString(myState.tailOffset++, (CharSequence)"(");
                    ++myState.caretOffset;
                }
                if (hasParams && styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES) {
                    document.insertString(myState.caretOffset++, (CharSequence)" ");
                    ++myState.tailOffset;
                }
            }
        }
    }

    public static void removeEndOfIdentifier(InsertionContext context) {
        Document document = context.getEditor().getDocument();
        JavaCompletionUtil.initOffsets(context.getFile(), context.getOffsetMap());
        document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
        if (context.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET) > 0) {
            document.deleteString(context.getOffsetMap().getOffset(JavaCompletionUtil.LPAREN_OFFSET), context.getOffsetMap().getOffset(JavaCompletionUtil.ARG_LIST_END_OFFSET));
            JavaCompletionUtil.resetParensInfo(context.getOffsetMap());
        }
    }

    protected TailType getTailType(char completionChar, LookupItem item) {
        switch (completionChar) {
            case '.': {
                return new CharTailType('.', false);
            }
            case ',': {
                return TailType.COMMA;
            }
            case ';': {
                return TailType.SEMICOLON;
            }
            case '=': {
                return TailType.EQ;
            }
            case ' ': {
                return TailType.SPACE;
            }
            case ':': {
                return TailType.CASE_COLON;
            }
        }
        TailType attr = item.getTailType();
        return attr == TailType.UNKNOWN ? TailType.NONE : attr;
    }

    private static int processTail(TailType tailType, int caretOffset, int tailOffset, Editor editor) {
        editor.getCaretModel().moveToOffset(caretOffset);
        tailType.processTail(editor, tailOffset);
        return editor.getCaretModel().getOffset();
    }

    public static class InsertHandlerState {
        int tailOffset;
        int caretOffset;

        public InsertHandlerState(int caretOffset, int tailOffset) {
            this.caretOffset = caretOffset;
            this.tailOffset = tailOffset;
        }
    }
}

