/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpandStaticImportAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExpandStaticImportAction.class.getName()));
    private static final String REPLACE_THIS_OCCURRENCE = "Replace this occurrence and keep the method";
    private static final String REPLACE_ALL_AND_DELETE_IMPORT = "Replace all and delete the import";

    @NotNull
    public String getFamilyName() {
        if ("Expand Static Import" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction", "getFamilyName"));
        }
        return "Expand Static Import";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction", "isAvailable"));
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof PsiIdentifier) || !(parent instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        PsiElement resolveScope = referenceElement.advancedResolve(true).getCurrentFileResolveScope();
        if (resolveScope instanceof PsiImportStaticStatement) {
            PsiClass targetClass = ((PsiImportStaticStatement)resolveScope).resolveTargetClass();
            if (targetClass == null) {
                return false;
            }
            this.setText("Expand static import to " + targetClass.getName() + "." + referenceElement.getReferenceName());
            return true;
        }
        return false;
    }

    public void invoke(final Project project, PsiFile file, Editor editor, PsiElement element) {
        PsiImportStaticStatement staticImport;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        final PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        final List expressionToExpand = ImportsUtil.collectReferencesThrough((PsiFile)file, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)(staticImport = (PsiImportStaticStatement)refExpr.advancedResolve(true).getCurrentFileResolveScope()));
        if (expressionToExpand.isEmpty()) {
            ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
            staticImport.delete();
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
        } else {
            BaseListPopupStep<String> step = new BaseListPopupStep<String>("Multiple Similar Calls Found", new String[]{REPLACE_THIS_OCCURRENCE, REPLACE_ALL_AND_DELETE_IMPORT}){

                public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
                    new WriteCommandAction(project, ExpandStaticImportAction.this.getText(), new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction$1$1", "run"));
                            }
                            if (selectedValue == ExpandStaticImportAction.REPLACE_THIS_OCCURRENCE) {
                                ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                            } else {
                                ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                            }
                        }
                    }.execute();
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction", "invoke"));
        }
        this.invoke(project, element.getContainingFile(), editor, element);
    }
}

