/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaElementLookupRenderer
implements ElementLookupRenderer {
    @Override
    public boolean handlesItem(Object element) {
        return element instanceof BeanPropertyElement;
    }

    public void renderElement(LookupItem item, Object element, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)item, presentation.isReal()));
        presentation.setItemText(PsiUtilCore.getName((PsiElement)((PsiElement)element)));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout(item));
        presentation.setTailText((String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation.setTypeText(JavaElementLookupRenderer.getTypeText(item, ((BeanPropertyElement)((Object)element)).getPropertyType()));
    }

    @Nullable
    private static String getTypeText(LookupItem item, @Nullable PsiType returnType) {
        if (returnType == null) {
            return null;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
        if (substitutor != null) {
            return substitutor.substitute(returnType).getPresentableText();
        }
        return returnType.getPresentableText();
    }

    public static boolean isToStrikeout(LookupItem<?> item) {
        PsiElement element;
        List<PsiMethod> allMethods = JavaCompletionUtil.getAllMethods(item);
        if (allMethods != null) {
            for (PsiMethod method : allMethods) {
                if (!method.isValid()) {
                    return false;
                }
                if (JavaElementLookupRenderer.isDeprecated((PsiElement)method)) continue;
                return false;
            }
            return true;
        }
        if (item.getObject() instanceof PsiElement && (element = (PsiElement)item.getObject()).isValid()) {
            return JavaElementLookupRenderer.isDeprecated(element);
        }
        return false;
    }

    private static boolean isDeprecated(PsiElement element) {
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

