/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.MagicConstant;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicConstantInspection
extends BaseJavaLocalInspectionTool {
    public static final Key<Boolean> NO_ANNOTATIONS_FOUND = Key.create((String)"REPORTED_NO_ANNOTATIONS_FOUND");
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"LITERAL_EXPRESSION_CACHE");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Magic Constant" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getDisplayName"));
        }
        return "Magic Constant";
    }

    @NotNull
    public String getShortName() {
        if ("MagicConstant" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getShortName"));
        }
        return "MagicConstant";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                MagicConstantInspection.checkAnnotationsJarAttached((PsiFile)file, holder);
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                MagicConstantInspection.checkCall(callExpression, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression r = expression.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type = expression.getType();
                MagicConstantInspection.checkExpression(r, owner, type, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value = statement.getReturnValue();
                if (value == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression(value, (PsiModifierListOwner)method, value.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression((PsiExpression)value, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression.getLOperand();
                PsiExpression r = expression.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(PsiExpression l, PsiExpression r) {
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)l).resolveMethod()) != null) {
                    MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public void cleanup(Project project) {
        super.cleanup(project);
        project.putUserData(NO_ANNOTATIONS_FOUND, null);
    }

    private static void checkAnnotationsJarAttached(@NotNull PsiFile file, @NotNull ProblemsHolder holder) {
        OrderEntry orderEntry;
        Boolean found;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkAnnotationsJarAttached"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkAnnotationsJarAttached"));
        }
        Project project = file.getProject();
        if (!holder.isOnTheFly() && (found = (Boolean)project.getUserData(NO_ANNOTATIONS_FOUND)) != null) {
            return;
        }
        PsiClass event = JavaPsiFacade.getInstance((Project)project).findClass("java.awt.event.InputEvent", GlobalSearchScope.allScope((Project)project));
        if (event == null) {
            return;
        }
        PsiMethod[] methods = event.findMethodsByName("getModifiers", false);
        if (methods.length != 1) {
            return;
        }
        PsiMethod getModifiers = methods[0];
        PsiAnnotation annotation = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotation((PsiModifierListOwner)getModifiers, MagicConstant.class.getName());
        if (annotation != null) {
            return;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)getModifiers);
        if (virtualFile == null) {
            return;
        }
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
        Sdk jdk = null;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext() && (!((orderEntry = (OrderEntry)iterator.next()) instanceof JdkOrderEntry) || (jdk = ((JdkOrderEntry)orderEntry).getJdk()) == null)) {
        }
        if (jdk == null) {
            return;
        }
        if (!holder.isOnTheFly()) {
            project.putUserData(NO_ANNOTATIONS_FOUND, (Object)Boolean.TRUE);
        }
        final Sdk finalJdk = jdk;
        String path = finalJdk.getHomePath();
        String text = "No IDEA annotations attached to the JDK " + finalJdk.getName() + (path == null ? "" : " (" + FileUtil.toSystemDependentName((String)path) + ")") + ", some issues will not be found";
        holder.registerProblem((PsiElement)file, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new LocalQuickFix(){

            @NotNull
            public String getName() {
                if ("Attach annotations" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$2", "getName"));
                }
                return "Attach annotations";
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$2", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$2", "applyFix"));
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        SdkModificator modificator = finalJdk.getSdkModificator();
                        JavaSdkImpl.attachJdkAnnotations(modificator);
                        modificator.commitChanges();
                    }
                });
            }
        }});
    }

    private static void checkExpression(PsiExpression expression, PsiModifierListOwner owner, PsiType type, ProblemsHolder holder) {
        AllowedValues allowed = MagicConstantInspection.getAllowedValues(owner, type, null);
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, null);
        if (scope == null) {
            scope = expression;
        }
        if (!MagicConstantInspection.isAllowed(scope, expression, allowed, expression.getManager(), null)) {
            MagicConstantInspection.registerProblem(expression, allowed, holder);
        }
    }

    private static void checkCall(@NotNull PsiCallExpression methodCall, @NotNull ProblemsHolder holder) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkCall"));
        }
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            AllowedValues values = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null);
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            MagicConstantInspection.checkMagicParameterArgument(parameter, argument, values, holder);
        }
    }

    private static AllowedValues getAllowedValuesFromMagic(@NotNull PsiModifierListOwner element, @NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getAllowedValuesFromMagic"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getAllowedValuesFromMagic"));
        }
        if (magic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "magic", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getAllowedValuesFromMagic"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getAllowedValuesFromMagic"));
        }
        if (TypeConversionUtil.getTypeRank((PsiType)type) <= 5) {
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("intValues");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            if (allowedValues.length == 0) {
                PsiAnnotationMemberValue orValue = magic.findAttributeValue("flags");
                allowedValues = orValue instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)orValue).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
                canBeOred = true;
            } else {
                canBeOred = false;
            }
        } else if (type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())))) {
            PsiAnnotationMemberValue strValuesAttr = magic.findAttributeValue("stringValues");
            allowedValues = strValuesAttr instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)strValuesAttr).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        PsiAnnotationMemberValue[] values = MagicConstantInspection.readFromClass("valuesFromClass", magic, type, manager);
        boolean ored = false;
        if (values == null) {
            values = MagicConstantInspection.readFromClass("flagsFromClass", magic, type, manager);
            ored = true;
        }
        if (values == null) {
            return null;
        }
        return new AllowedValues(values, ored);
    }

    private static PsiAnnotationMemberValue[] readFromClass(@NonNls @NotNull String attributeName, @NotNull PsiAnnotation magic, @NotNull PsiType type, @NotNull PsiManager manager) {
        PsiClass fromClass;
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "readFromClass"));
        }
        if (magic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "magic", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "readFromClass"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "readFromClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "readFromClass"));
        }
        PsiAnnotationMemberValue fromClassAttr = magic.findAttributeValue(attributeName);
        PsiType fromClassType = fromClassAttr instanceof PsiClassObjectAccessExpression ? ((PsiClassObjectAccessExpression)fromClassAttr).getOperand().getType() : null;
        PsiClass psiClass = fromClass = fromClassType instanceof PsiClassType ? ((PsiClassType)fromClassType).resolve() : null;
        if (fromClass == null) {
            return null;
        }
        String fqn = fromClass.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        ArrayList<PsiReferenceExpression> constants = new ArrayList<PsiReferenceExpression>();
        for (PsiField field : fromClass.getFields()) {
            PsiType fieldType;
            if (!field.hasModifierProperty("public") || !field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !Comparing.equal((Object)(fieldType = field.getType()), (Object)type)) continue;
            PsiAssignmentExpression e = (PsiAssignmentExpression)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("x=" + fqn + "." + field.getName(), (PsiElement)field);
            PsiReferenceExpression refToField = (PsiReferenceExpression)e.getRExpression();
            constants.add(refToField);
        }
        if (constants.isEmpty()) {
            return null;
        }
        return constants.toArray(new PsiAnnotationMemberValue[constants.size()]);
    }

    static AllowedValues getAllowedValues(@NotNull PsiModifierListOwner element, PsiType type, Set<PsiClass> visited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getAllowedValues"));
        }
        PsiAnnotation[] annotations = MagicConstantInspection.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            AllowedValues values;
            if (type != null && MagicConstant.class.getName().equals(annotation.getQualifiedName()) && (values = MagicConstantInspection.getAllowedValuesFromMagic(element, type, annotation, manager)) != null) {
                return values;
            }
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass) || (values = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited)) == null) continue;
            return values;
        }
        return MagicConstantInspection.parseBeanInfo(element, manager);
    }

    private static PsiAnnotation[] getAllAnnotations(final PsiModifierListOwner element) {
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<PsiAnnotation[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation[]> compute() {
                return CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static AllowedValues parseBeanInfo(@NotNull PsiModifierListOwner owner, @NotNull PsiManager manager) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "parseBeanInfo"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "parseBeanInfo"));
        }
        PsiMethod method = null;
        if (owner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)owner;
            PsiElement scope = parameter.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return null;
            }
            PsiElement nav = scope.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
            if (method.isConstructor()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"java.beans.ConstructorProperties"});
                if (annotation == null) {
                    return null;
                }
                PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
                if (!(value instanceof PsiArrayInitializerMemberValue)) {
                    return null;
                }
                PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
                PsiElement parent = parameter.getParent();
                if (!(parent instanceof PsiParameterList)) {
                    return null;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                if (index >= initializers.length) {
                    return null;
                }
                String[] initializer = initializers[index];
                if (!(initializer instanceof PsiLiteralExpression)) {
                    return null;
                }
                Object val = ((PsiLiteralExpression)initializer).getValue();
                if (!(val instanceof String)) {
                    return null;
                }
                PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)method.getContainingClass(), (String)((String)val), (boolean)false, (boolean)false);
                if (setter == null) {
                    return null;
                }
                PsiElement navigationElement = setter.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) {
                    return null;
                }
                method = (PsiMethod)navigationElement;
            }
        } else if (owner instanceof PsiMethod) {
            PsiElement nav = owner.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
        }
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            List setters = PropertyUtil.getSetters((PsiClass)aClass, (String)PropertyUtil.getPropertyNameByGetter((PsiMethod)method));
            if (setters.size() != 1) {
                return null;
            }
            method = (PsiMethod)setters.get(0);
        }
        if (!PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiDocComment doc = method.getDocComment();
        if (doc == null) {
            return null;
        }
        PsiDocTag beaninfo = doc.findTagByName("beaninfo");
        if (beaninfo == null) {
            return null;
        }
        String data2 = StringUtil.join((Object[])beaninfo.getDataElements(), (Function)new Function<PsiElement, String>(){

            public String fun(PsiElement element) {
                return element.getText();
            }
        }, (String)"\n");
        int enumIndex = StringUtil.indexOfSubstringEnd((String)data2, (String)"enum:");
        if (enumIndex == -1) {
            return null;
        }
        int colon = (data2 = data2.substring(enumIndex)).indexOf(":");
        int last = colon == -1 ? data2.length() : data2.substring(0, colon).lastIndexOf("\n");
        data2 = data2.substring(0, last);
        ArrayList<PsiReferenceExpression> values = new ArrayList<PsiReferenceExpression>();
        for (String line : StringUtil.splitByLines((String)data2)) {
            List words = StringUtil.split((String)line, (String)" ", (boolean)true, (boolean)true);
            if (words.size() != 2) continue;
            String ref = (String)words.get(1);
            PsiExpression constRef = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(ref, (PsiElement)aClass);
            if (!(constRef instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression expr = (PsiReferenceExpression)constRef;
            values.add(expr);
        }
        if (values.isEmpty()) {
            return null;
        }
        PsiAnnotationMemberValue[] array = values.toArray(new PsiAnnotationMemberValue[values.size()]);
        return new AllowedValues(array, false);
    }

    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getType"));
        }
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void checkMagicParameterArgument(@NotNull PsiParameter parameter, @NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkMagicParameterArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkMagicParameterArgument"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkMagicParameterArgument"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "checkMagicParameterArgument"));
        }
        PsiManager manager = PsiManager.getInstance((Project)holder.getProject());
        if (!argument.getTextRange().isEmpty() && !MagicConstantInspection.isAllowed(parameter.getDeclarationScope(), argument, allowedValues, manager, null)) {
            MagicConstantInspection.registerProblem(argument, allowedValues, holder);
        }
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "registerProblem"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "registerProblem"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "registerProblem"));
        }
        String values = StringUtil.join((Object[])allowedValues.values, (Function)new Function<PsiAnnotationMemberValue, String>(){

            public String fun(PsiAnnotationMemberValue value) {
                PsiElement resolved;
                if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                    return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                }
                return value.getText();
            }
        }, (String)", ");
        holder.registerProblem((PsiElement)argument, "Must be one of: " + values, new LocalQuickFix[0]);
    }

    private static boolean isAllowed(final @NotNull PsiElement scope, @NotNull PsiExpression argument, final @NotNull AllowedValues allowedValues, final @NotNull PsiManager manager, final Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isAllowed"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isAllowed"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isAllowed"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isAllowed"));
        }
        if (MagicConstantInspection.isGoodExpression(argument, allowedValues, scope, manager, visited)) {
            return true;
        }
        return MagicConstantInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                return MagicConstantInspection.isGoodExpression(expression, allowedValues, scope, manager, visited);
            }
        });
    }

    private static boolean isGoodExpression(@NotNull PsiExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        AllowedValues allowedForRef;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isGoodExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isGoodExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isGoodExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isGoodExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return true;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || MagicConstantInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || MagicConstantInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        if (MagicConstantInspection.isOneOf(expression, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = MagicConstantInspection.getLiteralExpression(expression, manager, "0");
            if (MagicConstantInspection.same((PsiElement)expression, (PsiElement)zero, manager)) {
                return true;
            }
            PsiExpression mOne = MagicConstantInspection.getLiteralExpression(expression, manager, "-1");
            if (MagicConstantInspection.same((PsiElement)expression, (PsiElement)mOne, manager)) {
                return true;
            }
            if (expression instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand : ((PsiPolyadicExpression)expression).getOperands()) {
                    if (MagicConstantInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                return operand == null || MagicConstantInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            resolved = ((PsiReference)expression).resolve();
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression.getType());
    }

    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text) {
        PsiExpression expression;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getLiteralExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getLiteralExpression"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "getLiteralExpression"));
        }
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression = (PsiExpression)cache.get(text)) == null) {
            expression = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text, (PsiElement)context);
            cache.put(text, expression);
        }
        return expression;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isOneOf"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isOneOf"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "isOneOf"));
        }
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!MagicConstantInspection.same((PsiElement)allowedValue, (PsiElement)expression, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(PsiElement e1, PsiElement e2, @NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "same"));
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return MagicConstantInspection.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    private static boolean processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Processor<PsiExpression> processor) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "processValuesFlownTo"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "processValuesFlownTo"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "processValuesFlownTo"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/magicConstant/MagicConstantInspection", "processValuesFlownTo"));
        }
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), SliceUsage.createRootUsage((PsiElement)argument, params));
        Collection children = rootNode.getChildren().iterator().next().getChildren();
        for (AbstractTreeNode child : children) {
            SliceUsage usage = (SliceUsage)((Object)child.getValue());
            PsiElement element = usage.getElement();
            if (!(element instanceof PsiExpression) || processor.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    static class AllowedValues {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$AllowedValues", "<init>"));
            }
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value : v1) {
                for (PsiAnnotationMemberValue value2 : v2) {
                    if (!MagicConstantInspection.same((PsiElement)value, (PsiElement)value2, value.getManager())) continue;
                    v2.remove(value2);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        public boolean isSubsetOf(@NotNull AllowedValues other, @NotNull PsiManager manager) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$AllowedValues", "isSubsetOf"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/magicConstant/MagicConstantInspection$AllowedValues", "isSubsetOf"));
            }
            for (PsiAnnotationMemberValue value : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : other.values) {
                    if (!MagicConstantInspection.same((PsiElement)value, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

