/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"$\b)I2\u000b^8sC\u001e,g+\u001b:uk\u0006dg)\u001b7f)J\f7m[3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u00112m\u001c8gS\u001e,(/\u0019;j_:\u001cFo\u001c:f\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015)iWm]:bO\u0016\u0014Uo\u001d\u0006\u000b\u001b\u0016\u001c8/Y4f\u0005V\u001c(\u0002B;uS2T\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0012M&dW\rU1uQR{7\u000b^8sC\u001e,'\"D\"p]\u000e,(O]3oi6\u000b\u0007O\u0003\u0003kCZ\f'BC2p]\u000e,(O]3oi*11\u000b\u001e:j]\u001eTa\u0002\u0016:bG.,Gm\u0015;pe\u0006<WMC\riCN$\u0015N]3di>\u0014\u0018PQ1tK\u0012\u001cFo\u001c:bO\u0016\u001c(b\u0002\"p_2,\u0017M\u001c\u0006\u0011m\u001a\u001cH*[:uK:,'/\u00113eK\u0012TQ\"\u0011;p[&\u001c'i\\8mK\u0006t'BB1u_6L7MC\u000bbI\u00124fm]\"iC:<Wm\u001d'jgR,g.\u001a:\u000b\tUs\u0017\u000e\u001e\u0006\u0004aV$(\u0002\u00029bi\"Tqa\u001d;pe\u0006<WM\u0003\u0003mC:<'\u0002K*u_J\fw-\u001a,jeR,\u0018\r\u001c$jY\u0016$&/Y2lKJ$CK]1dW\u0016$7\u000b^8sC\u001e,'B\u0002:f[>4XMC\u0005qe>\u001cWm]:pe*Ia)\u001e8di&|g.\r\u0006\u0004UZl'\"\u00034v]\u000e$\u0018n\u001c8ty\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0004\t\u0005A\u0001\u0001\u0004\u0001\u0006\u0003!\u0015Qa\u0001\u0003\u0003\u0011\ta\u0001!\u0002\u0002\u0005\u0002!%QA\u0001\u0003\u0004\u0011\u0015)1\u0001b\u0002\t\t1\u0001QA\u0001C\u0004\u0011\u0011)\u0011\u0001#\u0004\u0006\u0005\u0011)\u0001\u0012B\u0003\u0003\t\u0017Aq!B\u0002\u0005\r!1A\u0002A\u0003\u0004\t\tAy\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0003\u0007\u0001\u000b\t!a\u0001\u0003\u0004\u0006\u0007\u0011\u0011\u0001\"\u0003\u0007\u0001\u000b\t!a\u0001#\u0006\u0006\u0007\u0011I\u0001B\u0003\u0007\u0001\u000b\t!\u0011\u0002\u0003\u0006\u0006\u0007\u0011\u0011\u0001r\u0003\u0007\u0001\u000b\t!Q\u0001c\u0007\u0006\u0005\u0011Y\u0001rB\u0003\u0003\t\u0005Aa\"B\u0002\u0005\u0005!}A\u0002A\u0003\u0003\t\tA\u0001#\u0002\u0002\u0005\u001b!\u0005RA\u0001C\u000e\u0011?!\u0001\u0001d\u0001\u001a\u0005\u0015\t\u0001R\u0001\u000f\t[M!\u0011\r\u0002M\u0006C))\u0011\u0001#\u0004\n\u0007%\u0011Q!\u0001\u0005\b\u0013\rI!!B\u0001\t\u0010U\u001bA!B\u0002\u0005\f%\t\u0001\u0002C\u0017\u000e\t\u0007g\u0001\u0014C\u0011\u0003\u000b\u0005A\t\u0002J\u0001)\u0003U\u001bA!B\u0002\u0005\u0012%\tA\u0011A\u0017\f\t\u0005$\u0001tA\u0011\u0003\u000b\u0005AA!V\u0002\u0005\u000b\r!9!C\u0001\t\n5ZA!\u0019\u0003\u0019\u0014\u0005\u0012Q!\u0001E\n+\u000e!Qa\u0001C\n\u0013\u0005A!\"l\u0005\u0005\u0003aY\u0011EA\u0003\u0002\u0011+\t6a\u0001\u0003\f\u0013\u0005!\u0001!,\u000f\u0005\u0001aaQT\u0002\u0003\u0001\u00113i!!B\u0001\t\u000fA\u001b\u0001!(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011\u001f\u00016\u0011A\u0011\u0003\u000b\u0005A)\"U\u0002\b\t1I\u0011\u0001\u0002\u0001\u000e\u0003!]Q\"\u0001\u0005\r[m!\u0001\u0001'\b\u001e\u001e\u0011\u0001\u0001bD\u0007\u000b\u000b\u0005AI\"C\u0002\n\u0005\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001#\u0005Q\u0007\u0001\t#!B\u0001\t\u0016E\u001bQ\u0001\"\b\n\u0003\u0011\u0001Q\"\u0001\u0005\u000f[M!\u0001\u0001'\b\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005Aq\u0001U\u0002\u0001C\t)\u0011\u0001#\u0006R\u0007\u0015!i\"C\u0001\u0005\u00015\t\u0001rC[\u0015\u000bO!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0002#\u000e)AaA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public final class StorageVirtualFileTracker {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ConcurrentMap<String, TrackedStorage> filePathToStorage;
    private volatile boolean hasDirectoryBasedStorages;
    private final AtomicBoolean vfsListenerAdded;
    private final MessageBus messageBus;

    static {
        $kotlinClass = Reflection.createKotlinClass(StorageVirtualFileTracker.class);
    }

    public final void put(@JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="storage") @NotNull TrackedStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        this.filePathToStorage.put(path, storage2);
        if (storage2 instanceof DirectoryBasedStorage) {
            this.hasDirectoryBasedStorages = true;
        }
        if (this.vfsListenerAdded.compareAndSet(false, true)) {
            this.addVfsChangesListener();
        }
    }

    public final void remove(@JetValueParameter(name="path") @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.filePathToStorage.remove(path);
    }

    public final void remove(@JetValueParameter(name="processor") @NotNull Function1<? super TrackedStorage, ? extends Boolean> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Iterator iterator = this.filePathToStorage.values().iterator();
        Iterator iterator2 = KotlinPackage.iterator(iterator);
        while (iterator2.hasNext()) {
            TrackedStorage storage2;
            TrackedStorage trackedStorage = storage2 = (TrackedStorage)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)trackedStorage, (String)"storage");
            if (!((Boolean)processor.invoke((Object)trackedStorage)).booleanValue()) continue;
            iterator.remove();
        }
    }

    private final void addVfsChangesListener() {
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ StorageVirtualFileTracker this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(addVfsChangesListener.1.class);
            }

            public void after(@JetValueParameter(name="events") @NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    ComponentManager componentManager;
                    String path;
                    StateStorage storage2;
                    if (vFileEvent instanceof VFilePropertyChangeEvent && VirtualFile.PROP_NAME.equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        String oldPath = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$0(this.this$0).remove(oldPath);
                        if (storage2 != null) {
                            StorageVirtualFileTracker.access$getFilePathToStorage$0(this.this$0).put(((VFilePropertyChangeEvent)vFileEvent).getPath(), (TrackedStorage)storage2);
                            if (storage2 instanceof FileBasedStorage) {
                                ((FileBasedStorage)storage2).setFile(null, new File(((VFilePropertyChangeEvent)vFileEvent).getPath()));
                            }
                            StateStorageManagerImpl stateStorageManagerImpl = ((TrackedStorage)storage2).getStorageManager();
                            String string = oldPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldPath");
                            String string2 = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.getPath()");
                            stateStorageManagerImpl.pathRenamed(string, string2, vFileEvent);
                        }
                    } else {
                        path = vFileEvent.getPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$0(this.this$0).get(path);
                        if (storage2 == null && StorageVirtualFileTracker.access$getHasDirectoryBasedStorages$1(this.this$0) && StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)FileStorageCoreUtil.DEFAULT_EXT)) {
                            storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$0(this.this$0).get(VfsUtil.getParentDir((String)path));
                        }
                    }
                    if (storage2 == null) continue;
                    path = vFileEvent;
                    if (path instanceof VFileMoveEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, new File(((VFileMoveEvent)vFileEvent).getPath()));
                        }
                    } else if (path instanceof VFileCreateEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(((VFileCreateEvent)vFileEvent).getFile(), null);
                        }
                    } else if (path instanceof VFileDeleteEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, null);
                        } else {
                            StateStorage stateStorage = storage2;
                            if (stateStorage == null) {
                                throw new TypeCastException("com.intellij.openapi.components.StateStorage? cannot be cast to com.intellij.configurationStore.DirectoryBasedStorage");
                            }
                            ((DirectoryBasedStorage)stateStorage).setVirtualDir(null);
                        }
                    } else if (path instanceof VFileCopyEvent) continue;
                    if (((TrackedStorage)storage2).getStorageManager().getComponentManager() == null) {
                        Intrinsics.throwNpe();
                    }
                    ((StateStorageManager.IStorageManagerListener)componentManager.getMessageBus().syncPublisher(StateStorageManager.STORAGE_TOPIC)).storageFileChanged(vFileEvent, storage2, componentManager);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public StorageVirtualFileTracker(@JetValueParameter(name="messageBus") @NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        this.messageBus = messageBus;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.filePathToStorage = concurrentMap;
        this.vfsListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap<String, TrackedStorage> access$getFilePathToStorage$0(@JetValueParameter(name="$this", type="?") StorageVirtualFileTracker $this) {
        return $this.filePathToStorage;
    }

    public static final /* synthetic */ boolean access$getHasDirectoryBasedStorages$1(@JetValueParameter(name="$this", type="?") StorageVirtualFileTracker $this) {
        return $this.hasDirectoryBasedStorages;
    }

    public static final /* synthetic */ void access$setHasDirectoryBasedStorages$1(@JetValueParameter(name="$this", type="?") StorageVirtualFileTracker $this, @JetValueParameter(name="<set-?>") boolean bl) {
        $this.hasDirectoryBasedStorages = bl;
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={".\u0004)qAK]1dW\u0016$7\u000b^8sC\u001e,'\"G*u_J\fw-\u001a,jeR,\u0018\r\u001c$jY\u0016$&/Y2lKJT1aY8n\u0015!Ig\u000e^3mY&T'BE2p]\u001aLw-\u001e:bi&|gn\u0015;pe\u0016TAb\u0015;bi\u0016\u001cFo\u001c:bO\u0016Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006d_6\u0004xN\\3oiNTab\u001d;pe\u0006<W-T1oC\u001e,'OC\fTi\u0006$Xm\u0015;pe\u0006<W-T1oC\u001e,'/S7qY*\tr-\u001a;Ti>\u0014\u0018mZ3NC:\fw-\u001a:C\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011Qa\u0001\u0003\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0003\t\u0003A1!\u0002\u0002\u0005\u0006!\u001dQa\u0001\u0003\u0004\u0011\u000ba\u0001!B\u0002\u0005\u0003!%A\u0002A\u0003\u0003\t\u0005AI\u0001\u0002\u0019\r\u0005e\u0011Q!\u0001E\u0004[-!\u0001\u000f\u0002\r\u0005C\t)\u0011\u0001\u0003\u0003V\u0007\u0011i1\u0001B\u0003\n\u0003!%\u0001"})
    public static interface TrackedStorage
    extends StateStorage {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(TrackedStorage.class);
        }

        @NotNull
        public StateStorageManagerImpl getStorageManager();
    }
}

