/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    @Override
    public boolean isAvailable(SourcePosition position) {
        PsiFile file = position.getFile();
        return file.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        TextRange lineRange;
        int line = position.getLine();
        if (line < 0) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        if (line >= doc.getLineCount()) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        TextRange curLineRange = DocumentUtil.getLineTextRange(doc, line);
        PsiElement element = position.getElementAt();
        PsiElement method = JavaSmartStepIntoHandler.getBody(DebuggerUtilsEx.getContainingMethod(element));
        TextRange textRange = lineRange = method != null ? curLineRange.intersection(method.getTextRange()) : curLineRange;
        if (lineRange == null || lineRange.isEmpty()) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            OrderedSet targets = new OrderedSet();
            Ref textRange2 = new Ref((Object)lineRange);
            JavaRecursiveElementVisitor methodCollector = new JavaRecursiveElementVisitor((List)targets, lineRange, textRange2){
                final Stack<PsiMethod> myContextStack = new Stack();
                final Stack<String> myParamNameStack = new Stack();
                private int myNextLambdaExpressionOrdinal = 0;
                private boolean myInsideLambda = false;
                final /* synthetic */ List val$targets;
                final /* synthetic */ TextRange val$lineRange;
                final /* synthetic */ Ref val$textRange;
                {
                    this.val$targets = list;
                    this.val$lineRange = textRange;
                    this.val$textRange = ref;
                }

                @Nullable
                private String getCurrentParamName() {
                    return this.myParamNameStack.isEmpty() ? null : this.myParamNameStack.peek();
                }

                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                    for (PsiMethod psiMethod : aClass.getMethods()) {
                        this.val$targets.add(new MethodSmartStepTarget(psiMethod, this.getCurrentParamName(), (PsiElement)psiMethod.getBody(), true, null));
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    boolean inLambda = this.myInsideLambda;
                    this.myInsideLambda = true;
                    super.visitLambdaExpression(expression);
                    this.myInsideLambda = inLambda;
                    this.val$targets.add(new LambdaSmartStepTarget(expression, this.getCurrentParamName(), expression.getBody(), this.myNextLambdaExpressionOrdinal++, null));
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    PsiElement navMethod;
                    PsiElement element = expression.resolve();
                    if (element instanceof PsiMethod && (navMethod = element.getNavigationElement()) instanceof PsiMethod) {
                        this.val$targets.add(new MethodSmartStepTarget((PsiMethod)navMethod, null, (PsiElement)expression, true, null));
                    }
                }

                public void visitField(PsiField field) {
                    TextRange range = field.getTextRange();
                    if (this.val$lineRange.intersects(range)) {
                        super.visitField(field);
                    }
                }

                public void visitMethod(PsiMethod method) {
                    TextRange range = method.getTextRange();
                    if (this.val$lineRange.intersects(range)) {
                        super.visitMethod(method);
                    }
                }

                public void visitStatement(PsiStatement statement) {
                    TextRange range = statement.getTextRange();
                    if (this.val$lineRange.intersects(range)) {
                        this.val$textRange.set((Object)((TextRange)this.val$textRange.get()).union(range));
                        super.visitStatement(statement);
                    }
                }

                public void visitExpression(PsiExpression expression) {
                    TextRange range = expression.getTextRange();
                    if (this.val$lineRange.intersects(range)) {
                        this.val$textRange.set((Object)((TextRange)this.val$textRange.get()).union(range));
                    }
                    super.visitExpression(expression);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitExpressionList(PsiExpressionList expressionList) {
                    PsiMethod psiMethod;
                    PsiMethod psiMethod2 = psiMethod = this.myContextStack.isEmpty() ? null : this.myContextStack.peek();
                    if (psiMethod != null) {
                        String methodName = psiMethod.getName();
                        PsiExpression[] expressions = expressionList.getExpressions();
                        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                        for (int idx = 0; idx < expressions.length; ++idx) {
                            String paramName = idx < parameters.length && !parameters[idx].isVarArgs() ? parameters[idx].getName() : "arg" + (idx + 1);
                            this.myParamNameStack.push(methodName + ": " + paramName + ".");
                            PsiExpression argExpression = expressions[idx];
                            try {
                                argExpression.accept((PsiElementVisitor)this);
                                continue;
                            }
                            finally {
                                this.myParamNameStack.pop();
                            }
                        }
                    } else {
                        super.visitExpressionList(expressionList);
                    }
                }

                public void visitCallExpression(PsiCallExpression expression) {
                    PsiMethod psiMethod = expression.resolveMethod();
                    if (psiMethod != null) {
                        this.myContextStack.push(psiMethod);
                        this.val$targets.add(new MethodSmartStepTarget(psiMethod, null, (PsiElement)(expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement() : (expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getClassOrAnonymousClassReference() : expression)), this.myInsideLambda, null));
                    }
                    try {
                        super.visitCallExpression(expression);
                    }
                    finally {
                        if (psiMethod != null) {
                            this.myContextStack.pop();
                        }
                    }
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getEndOffset())));
            for (SmartStepTarget target : targets) {
                target.setCallingExpressionLines((Range<Integer>)lines);
            }
            OrderedSet orderedSet = targets;
            if (orderedSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return orderedSet;
        }
        List<SmartStepTarget> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
        }
        return list;
    }

    private static PsiElement getBody(@Nullable PsiElement containingMethod) {
        if (containingMethod instanceof PsiMethod) {
            return ((PsiMethod)containingMethod).getBody();
        }
        if (containingMethod instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)containingMethod).getBody();
        }
        return null;
    }
}

