/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaWithRuntimeCastSurrounder
extends JavaExpressionSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.runtime.type.template", (Object[])new Object[0]);
    }

    public boolean isApplicable(PsiExpression expr) {
        if (!expr.isPhysical()) {
            return false;
        }
        PsiFile file = expr.getContainingFile();
        if (!(file instanceof PsiCodeFragment)) {
            return false;
        }
        if (file.getUserData(DebuggerExpressionComboBox.KEY) == null) {
            return false;
        }
        return RuntimeTypeEvaluator.isSubtypeable(expr);
    }

    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession != null) {
            ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, expr.getProject());
            SurroundWithCastWorker worker = new SurroundWithCastWorker(editor, expr, debuggerContext, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            debuggerContext.getDebugProcess().getManagerThread().startProgress(worker, progressWindow);
        }
        return null;
    }

    private static class SurroundWithCastWorker
    extends RuntimeTypeEvaluator {
        private final Editor myEditor;

        public SurroundWithCastWorker(Editor editor, PsiExpression expression, DebuggerContextImpl context, ProgressIndicator indicator) {
            super(editor, (PsiElement)expression, context, indicator);
            this.myEditor = editor;
        }

        @Override
        protected void typeCalculationFinished(final @Nullable PsiType type) {
            if (type == null) {
                return;
            }
            this.hold();
            final Project project = this.myElement.getProject();
            DebuggerInvocationUtil.invokeLater(project, new Runnable(){

                @Override
                public void run() {
                    new WriteCommandAction(project, CodeInsightBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0]), new PsiFile[0]){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/codeinsight/JavaWithRuntimeCastSurrounder$SurroundWithCastWorker$1$1", "run"));
                            }
                            try {
                                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)SurroundWithCastWorker.this.myElement.getProject()).getElementFactory();
                                PsiParenthesizedExpression parenth = (PsiParenthesizedExpression)factory.createExpressionFromText("((" + type.getCanonicalText() + ")expr)", null);
                                ((PsiTypeCastExpression)parenth.getExpression()).getOperand().replace(SurroundWithCastWorker.this.myElement);
                                parenth = (PsiParenthesizedExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)parenth);
                                PsiExpression expr = (PsiExpression)SurroundWithCastWorker.this.myElement.replace((PsiElement)parenth);
                                TextRange range = expr.getTextRange();
                                SurroundWithCastWorker.this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                                SurroundWithCastWorker.this.myEditor.getCaretModel().moveToOffset(range.getEndOffset());
                                SurroundWithCastWorker.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                            }
                            finally {
                                SurroundWithCastWorker.this.release();
                            }
                        }
                    }.execute();
                }
            }, this.myProgressIndicator.getModalityState());
        }
    }
}

