/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.apiAdapters.ConnectionServiceWrapper;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.DebugProcessImpl");
    @NonNls
    private static final String SOCKET_ATTACHING_CONNECTOR_NAME = "com.sun.jdi.SocketAttach";
    @NonNls
    private static final String SHMEM_ATTACHING_CONNECTOR_NAME = "com.sun.jdi.SharedMemoryAttach";
    @NonNls
    private static final String SOCKET_LISTENING_CONNECTOR_NAME = "com.sun.jdi.SocketListen";
    @NonNls
    private static final String SHMEM_LISTENING_CONNECTOR_NAME = "com.sun.jdi.SharedMemoryListen";
    private final Project myProject;
    private final RequestManagerImpl myRequestManager;
    private volatile VirtualMachineProxyImpl myVirtualMachineProxy = null;
    protected EventDispatcher<DebugProcessListener> myDebugProcessDispatcher = EventDispatcher.create(DebugProcessListener.class);
    protected EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> myProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_ATTACHED = 1;
    protected static final int STATE_DETACHING = 2;
    protected static final int STATE_DETACHED = 3;
    protected final AtomicInteger myState = new AtomicInteger(0);
    private volatile ExecutionResult myExecutionResult;
    private RemoteConnection myConnection;
    private JavaDebugProcess myXDebugProcess;
    private ConnectionServiceWrapper myConnectionService;
    private Map<String, Connector.Argument> myArguments;
    private final List<NodeRenderer> myRenderers = new ArrayList<NodeRenderer>();
    private final Map<Type, NodeRenderer> myNodeRenderersMap = new HashMap();
    private final NodeRendererSettingsListener mySettingsListener = new NodeRendererSettingsListener(){

        @Override
        public void renderersChanged() {
            DebugProcessImpl.this.myNodeRenderersMap.clear();
            DebugProcessImpl.this.myRenderers.clear();
            DebugProcessImpl.this.loadRenderers();
        }
    };
    private final SuspendManagerImpl mySuspendManager = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = null;
    private final DebuggerManagerThreadImpl myDebuggerManagerThread;
    private static final int LOCAL_START_TIMEOUT = 30000;
    private final Semaphore myWaitFor = new Semaphore();
    private final AtomicBoolean myIsFailed = new AtomicBoolean(false);
    protected DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final Alarm myStatusUpdateAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, this.myDisposable);
    private static final String ourTrace = System.getProperty("idea.debugger.trace");
    private volatile RunToCursorBreakpoint myRunToCursorBreakpoint;

    protected DebugProcessImpl(Project project) {
        this.myProject = project;
        this.myDebuggerManagerThread = new DebuggerManagerThreadImpl(this.myDisposable, this.myProject);
        this.myRequestManager = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this.mySettingsListener);
        this.loadRenderers();
    }

    private void loadRenderers() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() throws Exception {
                try {
                    NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
                    for (NodeRenderer renderer : rendererSettings.getAllRenderers()) {
                        if (!renderer.isEnabled()) continue;
                        DebugProcessImpl.this.myRenderers.add(renderer);
                    }
                }
                catch (Throwable throwable) {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            DebuggerSession session = DebugProcessImpl.this.mySession;
                            if (session != null && session.isAttached()) {
                                session.refresh(true);
                                DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                            }
                        }
                    });
                    throw throwable;
                }
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        if (watcher == null) {
            return null;
        }
        Method method = watcher.getLastExecutedMethod();
        if (method == null) {
            return null;
        }
        return Pair.create((Object)method, (Object)watcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean enabled) {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        if (watcher != null) {
            watcher.setFeatureEnabled(enabled);
        }
    }

    public boolean isWatchMethodReturnValuesEnabled() {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        return watcher != null && watcher.isFeatureEnabled();
    }

    public boolean canGetMethodReturnValue() {
        return this.myReturnValueWatcher != null;
    }

    public NodeRenderer getAutoRenderer(ValueDescriptor descriptor) {
        Type type;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Value value = descriptor.getValue();
        Type type2 = type = value != null ? value.type() : null;
        if (!DebuggerManagerEx.getInstanceEx(this.getProject()).getContext().isEvaluationPossible()) {
            return DebugProcessImpl.getDefaultRenderer(type);
        }
        NodeRenderer renderer = this.myNodeRenderersMap.get(type);
        if (renderer == null) {
            for (NodeRenderer nodeRenderer : this.myRenderers) {
                if (!nodeRenderer.isApplicable(type)) continue;
                renderer = nodeRenderer;
                break;
            }
            if (renderer == null) {
                renderer = DebugProcessImpl.getDefaultRenderer(type);
            }
            this.myNodeRenderersMap.put(type, renderer);
        }
        return renderer;
    }

    public static NodeRenderer getDefaultRenderer(Value value) {
        return DebugProcessImpl.getDefaultRenderer(value != null ? value.type() : null);
    }

    public static NodeRenderer getDefaultRenderer(Type type) {
        NodeRendererSettings settings = NodeRendererSettings.getInstance();
        PrimitiveRenderer primitiveRenderer = settings.getPrimitiveRenderer();
        if (primitiveRenderer.isApplicable(type)) {
            return primitiveRenderer;
        }
        ArrayRenderer arrayRenderer = settings.getArrayRenderer();
        if (arrayRenderer.isApplicable(type)) {
            return arrayRenderer;
        }
        ClassRenderer classRenderer = settings.getClassRenderer();
        LOG.assertTrue(classRenderer.isApplicable(type), (Object)type.name());
        return classRenderer;
    }

    protected void commitVM(VirtualMachine vm) {
        if (!this.isInInitialState()) {
            LOG.error("State is invalid " + this.myState.get());
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = this.createPositionManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("*******************VM attached******************");
        }
        this.checkVirtualMachineVersion(vm);
        this.myVirtualMachineProxy = new VirtualMachineProxyImpl(this, vm);
        if (!StringUtil.isEmpty((String)ourTrace)) {
            int mask = 0;
            StringTokenizer tokenizer = new StringTokenizer(ourTrace);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(token) == 0) {
                    mask |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(token) == 0) {
                    mask |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(token) != 0) continue;
                mask |= 0xFFFFFF;
            }
            vm.setDebugTraceMode(mask);
        }
    }

    private void stopConnecting() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Map<String, Connector.Argument> arguments = this.myArguments;
        try {
            if (arguments == null) {
                return;
            }
            if (this.myConnection.isServerMode()) {
                ListeningConnector connector = (ListeningConnector)DebugProcessImpl.findConnector(SOCKET_LISTENING_CONNECTOR_NAME);
                if (connector == null) {
                    LOG.error("Cannot find connector: com.sun.jdi.SocketListen");
                } else {
                    connector.stopListening(arguments);
                }
            } else if (this.myConnectionService != null) {
                this.myConnectionService.close();
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
        }
        catch (IllegalConnectorArgumentsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.closeProcess(true);
        }
    }

    protected CompoundPositionManager createPositionManager() {
        return new CompoundPositionManager(new PositionManagerImpl(this));
    }

    public void printToConsole(String text) {
        this.myExecutionResult.getProcessHandler().notifyTextAvailable(text, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        return this.myExecutionResult != null ? this.myExecutionResult.getProcessHandler() : null;
    }

    protected void doStep(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, int size, int depth, RequestHint hint) {
        if (stepThread == null) {
            return;
        }
        try {
            String currentClassName;
            List<ClassFilter> activeFilters;
            ThreadReference stepThreadReference = stepThread.getThreadReference();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DO_STEP: creating step request for " + stepThreadReference);
            }
            this.deleteStepRequests(stepThreadReference);
            EventRequestManager requestManager = this.getVirtualMachineProxy().eventRequestManager();
            StepRequest stepRequest = requestManager.createStepRequest(stepThreadReference, size, depth);
            if (!(hint != null && hint.isIgnoreFilters() || (activeFilters = DebugProcessImpl.getActiveFilters()).isEmpty() || (currentClassName = DebugProcessImpl.getCurrentClassName(stepThread)) != null && DebuggerUtilsEx.isFiltered(currentClassName, activeFilters))) {
                for (ClassFilter filter : activeFilters) {
                    stepRequest.addClassExclusionFilter(filter.getPattern());
                }
            }
            stepRequest.setSuspendPolicy(Registry.is((String)"debugger.step.resumes.one.thread") ? 1 : suspendContext.getSuspendPolicy());
            if (hint != null) {
                stepRequest.putProperty("hint", hint);
            }
            stepRequest.enable();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @NotNull
    static List<ClassFilter> getActiveFilters() {
        ArrayList<ClassFilter> activeFilters = new ArrayList<ClassFilter>();
        DebuggerSettings settings = DebuggerSettings.getInstance();
        if (settings.TRACING_FILTERS_ENABLED) {
            for (ClassFilter classFilter : settings.getSteppingFilters()) {
                if (!classFilter.isEnabled()) continue;
                activeFilters.add(classFilter);
            }
        }
        for (ClassFilter classFilter : (DebuggerClassFilterProvider[])Extensions.getExtensions((ExtensionPointName)DebuggerClassFilterProvider.EP_NAME)) {
            for (ClassFilter filter : classFilter.getFilters()) {
                if (!filter.isEnabled()) continue;
                activeFilters.add(filter);
            }
        }
        ArrayList<ClassFilter> arrayList = activeFilters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/DebugProcessImpl", "getActiveFilters"));
        }
        return arrayList;
    }

    void deleteStepRequests(@Nullable ThreadReference stepThread) {
        EventRequestManager requestManager = this.getVirtualMachineProxy().eventRequestManager();
        List<StepRequest> stepRequests = requestManager.stepRequests();
        if (!stepRequests.isEmpty()) {
            ArrayList<StepRequest> toDelete = new ArrayList<StepRequest>(stepRequests.size());
            for (StepRequest request : stepRequests) {
                ThreadReference threadReference = request.thread();
                try {
                    if (threadReference.status() == -1 || stepThread != null && !stepThread.equals(threadReference)) continue;
                    toDelete.add(request);
                }
                catch (IllegalThreadStateException e) {
                    LOG.info((Throwable)e);
                }
                catch (ObjectCollectedException objectCollectedException) {}
            }
            requestManager.deleteEventRequests(toDelete);
        }
    }

    @Nullable
    static String getCurrentClassName(ThreadReferenceProxyImpl thread) {
        try {
            StackFrameProxyImpl stackFrame;
            if (thread != null && thread.frameCount() > 0 && (stackFrame = thread.frame(0)) != null) {
                ReferenceType referenceType;
                Location location = stackFrame.location();
                ReferenceType referenceType2 = referenceType = location == null ? null : location.declaringType();
                if (referenceType != null) {
                    return referenceType.name();
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VirtualMachine createVirtualMachineInt() throws ExecutionException {
        ListeningConnector connector;
        String address;
        block35: {
            Connector.Argument timeoutArg;
            Connector.Argument portArg;
            if (this.myArguments != null) {
                throw new IOException(DebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
            }
            address = this.myConnection.getAddress();
            if (!this.myConnection.isServerMode()) break block35;
            connector = (ListeningConnector)DebugProcessImpl.findConnector(this.myConnection.isUseSockets() ? SOCKET_LISTENING_CONNECTOR_NAME : SHMEM_LISTENING_CONNECTOR_NAME);
            if (connector == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{DebuggerBundle.getTransportName((RemoteConnection)this.myConnection)}));
            }
            this.myArguments = connector.defaultArguments();
            if (this.myArguments == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
            }
            if (address == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
            }
            Connector.Argument argument = portArg = this.myConnection.isUseSockets() ? this.myArguments.get("port") : this.myArguments.get("name");
            if (portArg != null) {
                portArg.setValue(address);
            }
            if ((timeoutArg = this.myArguments.get("timeout")) != null) {
                timeoutArg.setValue("0");
            }
            connector.startListening(this.myArguments);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
            VirtualMachine virtualMachine = connector.accept(this.myArguments);
            return virtualMachine;
        }
        AttachingConnector connector2 = (AttachingConnector)DebugProcessImpl.findConnector(this.myConnection.isUseSockets() ? SOCKET_ATTACHING_CONNECTOR_NAME : SHMEM_ATTACHING_CONNECTOR_NAME);
        if (connector2 == null) {
            throw new CantRunException(DebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{DebuggerBundle.getTransportName((RemoteConnection)this.myConnection)}));
        }
        this.myArguments = connector2.defaultArguments();
        if (this.myConnection.isUseSockets()) {
            Connector.Argument hostnameArg = this.myArguments.get("hostname");
            if (hostnameArg != null && this.myConnection.getHostName() != null) {
                hostnameArg.setValue(this.myConnection.getHostName());
            }
            if (address == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
            }
            Connector.Argument portArg = this.myArguments.get("port");
            if (portArg != null) {
                portArg.setValue(address);
            }
        } else {
            if (address == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
            }
            Connector.Argument nameArg = this.myArguments.get("name");
            if (nameArg != null) {
                nameArg.setValue(address);
            }
        }
        Connector.Argument timeoutArg = this.myArguments.get("timeout");
        if (timeoutArg != null) {
            timeoutArg.setValue("0");
        }
        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
        try {
            return connector2.attach(this.myArguments);
        }
        catch (IllegalArgumentException e) {
            try {
                throw new CantRunException(e.getLocalizedMessage());
            }
            catch (IOException e2) {
                throw new ExecutionException(DebugProcessImpl.processIOException(e2, DebuggerBundle.getAddressDisplayName((RemoteConnection)this.myConnection)), (Throwable)e2);
            }
            catch (IllegalConnectorArgumentsException e3) {}
            throw new ExecutionException(DebugProcessImpl.processError(e3), (Throwable)e3);
            finally {
                if (this.myArguments != null) {
                    try {
                        connector.stopListening(this.myArguments);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {}
                }
            }
        }
        finally {
            this.myArguments = null;
            this.myConnectionService = null;
        }
    }

    public void showStatusText(final String text) {
        if (!this.myStatusUpdateAlarm.isDisposed()) {
            this.myStatusUpdateAlarm.cancelAllRequests();
            this.myStatusUpdateAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    StatusBarUtil.setStatusBarInfo(DebugProcessImpl.this.myProject, text);
                }
            }, 50);
        }
    }

    static Connector findConnector(String connectorName) throws ExecutionException {
        List<Connector> connectors;
        VirtualMachineManager virtualMachineManager;
        try {
            virtualMachineManager = Bootstrap.virtualMachineManager();
        }
        catch (Error e) {
            String error = e.getClass().getName() + " : " + e.getLocalizedMessage();
            throw new ExecutionException(DebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{error}));
        }
        if (SOCKET_ATTACHING_CONNECTOR_NAME.equals(connectorName) || SHMEM_ATTACHING_CONNECTOR_NAME.equals(connectorName)) {
            connectors = virtualMachineManager.attachingConnectors();
        } else if (SOCKET_LISTENING_CONNECTOR_NAME.equals(connectorName) || SHMEM_LISTENING_CONNECTOR_NAME.equals(connectorName)) {
            connectors = virtualMachineManager.listeningConnectors();
        } else {
            return null;
        }
        for (AttachingConnector connector1 : connectors) {
            Connector connector = connector1;
            if (!connectorName.equals(connector.name())) continue;
            return connector;
        }
        return null;
    }

    private void checkVirtualMachineVersion(VirtualMachine vm) {
        String version = vm.version();
        if ("1.4.0".equals(version)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)DebugProcessImpl.this.getProject(), (String)DebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                }
            });
        }
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.addListener((EventListener)listener);
    }

    public void removeDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.myProcessListeners.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.myProcessListeners.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.myConnection;
    }

    public ExecutionResult getExecutionResult() {
        return this.myExecutionResult;
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean canRedefineClasses() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.canRedefineClasses();
    }

    public boolean canWatchFieldModification() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.canWatchFieldModification();
    }

    public boolean isInInitialState() {
        return this.myState.get() == 0;
    }

    public boolean isAttached() {
        return this.myState.get() == 1;
    }

    public boolean isDetached() {
        return this.myState.get() == 3;
    }

    public boolean isDetaching() {
        return this.myState.get() == 2;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.myRequestManager;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        if (vm == null) {
            throw new VMDisconnectedException();
        }
        return vm;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setRunToCursorBreakpoint(@Nullable RunToCursorBreakpoint breakpoint) {
        this.myRunToCursorBreakpoint = breakpoint;
    }

    public void cancelRunToCursorBreakpoint() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RunToCursorBreakpoint runToCursorBreakpoint = this.myRunToCursorBreakpoint;
        if (runToCursorBreakpoint != null) {
            this.setRunToCursorBreakpoint(null);
            this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
            if (runToCursorBreakpoint.isRestoreBreakpoints()) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
                breakpointManager.enableBreakpoints(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcess(boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myState.compareAndSet(0, 2) || this.myState.compareAndSet(1, 2)) {
            try {
                this.getManagerThread().close();
            }
            finally {
                VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
                this.myVirtualMachineProxy = null;
                this.myPositionManager = null;
                this.myReturnValueWatcher = null;
                this.myNodeRenderersMap.clear();
                this.myRenderers.clear();
                DebuggerUtils.cleanupAfterProcessFinish((DebugProcess)this);
                this.myState.set(3);
                try {
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processDetached((DebugProcess)this, closedByUser);
                }
                finally {
                    if (vm != null) {
                        try {
                            vm.dispose();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.myWaitFor.up();
                }
            }
        }
    }

    private static String formatMessage(String message) {
        int lineLength = 90;
        StringBuilder buf = new StringBuilder(message.length());
        for (int index = 0; index < message.length(); index += 90) {
            buf.append(message.substring(index, Math.min(index + 90, message.length()))).append('\n');
        }
        return buf.toString();
    }

    public static String processError(Exception e) {
        String message;
        if (e instanceof VMStartException) {
            VMStartException e1 = (VMStartException)e;
            message = e1.getLocalizedMessage();
        } else if (e instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException e1 = (IllegalConnectorArgumentsException)e;
            List<String> invalidArgumentNames = e1.argumentNames();
            message = DebugProcessImpl.formatMessage(DebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{invalidArgumentNames.size()}) + ": " + e1.getLocalizedMessage()) + invalidArgumentNames;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e1);
            }
        } else if (e instanceof CantRunException) {
            message = e.getLocalizedMessage();
        } else if (e instanceof VMDisconnectedException) {
            message = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (e instanceof IOException) {
            message = DebugProcessImpl.processIOException((IOException)e, null);
        } else if (e instanceof ExecutionException) {
            message = e.getLocalizedMessage();
        } else {
            message = DebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String processIOException(@NotNull IOException e, @Nullable String address) {
        String message;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/engine/DebugProcessImpl", "processIOException"));
        }
        if (e instanceof UnknownHostException) {
            String string = DebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]) + (address != null ? " (" + address + ")" : "") + ":\n" + e.getLocalizedMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/DebugProcessImpl", "processIOException"));
            }
            return string;
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(DebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
            if (address != null) {
                buf.append(" (").append(address).append(")");
            }
            buf.append(": ");
            buf.append(e.getClass().getName()).append(" ");
            String localizedMessage = e.getLocalizedMessage();
            if (!StringUtil.isEmpty((String)localizedMessage)) {
                buf.append('\"');
                buf.append(localizedMessage);
                buf.append('\"');
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            message = buf.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/DebugProcessImpl", "processIOException"));
        }
        return string;
    }

    public void dispose() {
        NodeRendererSettings.getInstance().removeListener(this.mySettingsListener);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myRequestManager.setFilterThread(null);
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.myDebuggerManagerThread;
    }

    private static int getInvokePolicy(SuspendContext suspendContext) {
        return suspendContext.getSuspendPolicy() == 1 ? 1 : 0;
    }

    public void waitFor() {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor();
    }

    public void waitFor(long timeout) {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor(timeout);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, List args) throws EvaluateException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        if (objRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objRef", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List args, final int invocationOptions) throws EvaluateException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/DebugProcessImpl", "invokeInstanceMethod"));
        }
        if (objRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objRef", "com/intellij/debugger/engine/DebugProcessImpl", "invokeInstanceMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/DebugProcessImpl", "invokeInstanceMethod"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/debugger/engine/DebugProcessImpl", "invokeInstanceMethod"));
        }
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        return new InvokeCommand<Value>(method, args){

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoke " + method.name());
                }
                return objRef.invokeMethod(thread, method, args, invokePolicy | invocationOptions);
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    private static ThreadReference getEvaluationThread(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy evaluationThread = evaluationContext.getSuspendContext().getThread();
        if (evaluationThread == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        return evaluationThread.getThreadReference();
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List args) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, args, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List args, boolean internalEvaluate) throws EvaluateException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/debugger/engine/DebugProcessImpl", "invokeMethod"));
        }
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        return new InvokeCommand<Value>(method, args){

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoke " + method.name());
                }
                return classType.invokeMethod(thread, method, args, invokePolicy);
            }
        }.start((EvaluationContextImpl)evaluationContext, internalEvaluate);
    }

    public ArrayReference newInstance(ArrayType arrayType, int dimension) throws EvaluateException {
        try {
            return arrayType.newInstance(dimension);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List args) throws EvaluateException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/DebugProcessImpl", "newInstance"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/debugger/engine/DebugProcessImpl", "newInstance"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/DebugProcessImpl", "newInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/debugger/engine/DebugProcessImpl", "newInstance"));
        }
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        InvokeCommand<ObjectReference> invokeCommand = new InvokeCommand<ObjectReference>(method, args){

            @Override
            protected ObjectReference invokeMethod(int invokePolicy, Method method, List args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New instance " + method.name());
                }
                return classType.newInstance(thread, method, args, invokePolicy);
            }
        };
        return (ObjectReference)invokeCommand.start((EvaluationContextImpl)evaluationContext, false);
    }

    public void clearCashes(int suspendPolicy) {
        if (!this.isAttached()) {
            return;
        }
        switch (suspendPolicy) {
            case 2: {
                this.getVirtualMachineProxy().clearCaches();
                break;
            }
            case 1: {
                this.getVirtualMachineProxy().clearCaches();
            }
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContext) {
        this.clearCashes(suspendContext.getSuspendPolicy());
    }

    private void beforeMethodInvocation(SuspendContextImpl suspendContext, Method method, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("before invocation in  thread " + suspendContext.getThread().name() + " method " + (method == null ? "null" : method.name()));
        }
        if (!internalEvaluate) {
            if (method != null) {
                this.showStatusText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
            } else {
                this.showStatusText(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            }
        }
    }

    private void afterMethodInvocation(SuspendContextImpl suspendContext, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("after invocation in  thread " + suspendContext.getThread().name());
        }
        if (!internalEvaluate) {
            this.showStatusText("");
        }
    }

    public ReferenceType findClass(EvaluationContext evaluationContext, String className, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            VirtualMachineProxyImpl vmProxy = this.getVirtualMachineProxy();
            if (vmProxy == null) {
                throw new VMDisconnectedException();
            }
            ReferenceType result = null;
            for (ReferenceType refType : vmProxy.classesByName(className)) {
                if (!refType.isPrepared() || !DebugProcessImpl.isVisibleFromClassLoader(classLoader, refType)) continue;
                result = refType;
                break;
            }
            EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
            if (result == null && evalContext.isAutoLoadClasses()) {
                return this.loadClass(evalContext, className, classLoader);
            }
            return result;
        }
        catch (InvocationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (ClassNotLoadedException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private static boolean isVisibleFromClassLoader(ClassLoaderReference fromLoader, ReferenceType refType) {
        return fromLoader == null || fromLoader.equals(refType.classLoader()) || fromLoader.visibleClasses().contains(refType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reformatArrayName(String className) {
        if (className.indexOf(91) == -1) {
            return className;
        }
        int dims = 0;
        while (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
            ++dims;
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            for (int i = 0; i < dims; ++i) {
                buffer.append('[');
            }
            String primitiveSignature = JVMNameUtil.getPrimitiveSignature(className);
            if (primitiveSignature != null) {
                buffer.append(primitiveSignature);
            } else {
                buffer.append('L');
                buffer.append(className);
                buffer.append(';');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String qName, ClassLoaderReference classLoader) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        qName = DebugProcessImpl.reformatArrayName(qName);
        ReferenceType refType = null;
        VirtualMachineProxyImpl virtualMachine = this.getVirtualMachineProxy();
        List<ReferenceType> classClasses = virtualMachine.classesByName("java.lang.Class");
        if (!classClasses.isEmpty()) {
            Value value;
            ClassType classClassType = (ClassType)classClasses.get(0);
            Method forNameMethod = classLoader != null ? DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;") : DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            ArrayList<Value> args = new ArrayList<Value>();
            StringReference qNameMirror = virtualMachine.mirrorOf(qName);
            args.add(qNameMirror);
            if (classLoader != null) {
                args.add(virtualMachine.mirrorOf(true));
                args.add(classLoader);
            }
            if ((value = this.invokeMethod((EvaluationContext)evaluationContext, classClassType, forNameMethod, args)) instanceof ClassObjectReference) {
                refType = ((ClassObjectReference)value).reflectedType();
            }
        }
        return refType;
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> allThreads = this.getVirtualMachineProxy().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxy : allThreads) {
                    LOG.debug("Thread name=" + threadReferenceProxy.name() + " suspendCount()=" + threadReferenceProxy.getSuspendCount());
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        SuspendManagerImpl suspendManagerImpl = this.mySuspendManager;
        if (suspendManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/DebugProcessImpl", "getSuspendManager"));
        }
        return suspendManagerImpl;
    }

    public CompoundPositionManager getPositionManager() {
        return this.myPositionManager;
    }

    public void stop(boolean forceTerminate) {
        this.getManagerThread().terminateAndInvoke(this.createStopCommand(forceTerminate), 3000);
    }

    public StopCommand createStopCommand(boolean forceTerminate) {
        return new StopCommand(forceTerminate);
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        LOG.assertTrue(this.mySession != null, (Object)"Accessing debug session before its initialization");
        GlobalSearchScope globalSearchScope = this.mySession.getSearchScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/DebugProcessImpl", "getSearchScope"));
        }
        return globalSearchScope;
    }

    public void reattach(DebugEnvironment environment) throws ExecutionException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((XDebugSessionImpl)this.getXdebugProcess().getSession()).reset();
        this.myState.set(0);
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                DebugProcessImpl.this.myRequestManager.processDetached(DebugProcessImpl.this, false);
            }
        });
        this.myConnection = environment.getRemoteConnection();
        this.getManagerThread().restartIfNeeded();
        this.createVirtualMachine(environment.getSessionName(), environment.isPollConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment environment, DebuggerSession session) throws ExecutionException {
        ExecutionResult executionResult;
        this.mySession = session;
        this.myWaitFor.down();
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isInInitialState());
        this.myConnection = environment.getRemoteConnection();
        this.createVirtualMachine(environment.getSessionName(), environment.isPollConnection());
        try {
            List<ProcessListener> list = this.myProcessListeners;
            synchronized (list) {
                this.myExecutionResult = executionResult = environment.createExecutionResult();
                if (executionResult == null) {
                    this.fail();
                    return null;
                }
                for (ProcessListener processListener : this.myProcessListeners) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.myProcessListeners.clear();
            }
        }
        catch (ExecutionException e) {
            this.fail();
            throw e;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return executionResult;
        }
        return executionResult;
    }

    private void fail() {
        if (this.myIsFailed.compareAndSet(false, true)) {
            this.stop(false);
        }
    }

    private void createVirtualMachine(final String sessionName, final boolean pollConnection) {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean connectorIsReady = new AtomicBoolean(false);
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessAdapter(){

            public void connectorIsReady() {
                connectorIsReady.set(true);
                semaphore.up();
                DebugProcessImpl.this.myDebugProcessDispatcher.removeListener((EventListener)((Object)this));
            }
        });
        DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().reloadBreakpoints();
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                VirtualMachine vm = null;
                try {
                    long time = System.currentTimeMillis();
                    while (System.currentTimeMillis() - time < 30000L) {
                        try {
                            vm = DebugProcessImpl.this.createVirtualMachineInt();
                        }
                        catch (ExecutionException e) {
                            if (pollConnection && !DebugProcessImpl.this.myConnection.isServerMode() && e.getCause() instanceof IOException) {
                                10 var5_5 = this;
                                synchronized (var5_5) {
                                    try {
                                        this.wait(500L);
                                    }
                                    catch (InterruptedException ignored) {
                                        break;
                                    }
                                }
                            }
                            DebugProcessImpl.this.fail();
                            DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new Runnable(){

                                @Override
                                public void run() {
                                    if (DebugProcessImpl.this.myExecutionResult != null || !connectorIsReady.get()) {
                                        ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.myProject, (String)ToolWindowId.DEBUG, (String)sessionName, (ExecutionException)e);
                                    }
                                }
                            });
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (vm != null) {
                    final VirtualMachine vm1 = vm;
                    DebugProcessImpl.this.afterProcessStarted(new Runnable(){

                        @Override
                        public void run() {
                            DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                                @Override
                                protected void action() throws Exception {
                                    DebugProcessImpl.this.commitVM(vm1);
                                }
                            });
                        }
                    });
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private void afterProcessStarted(final Runnable run2) {
        class MyProcessAdapter
        extends ProcessAdapter {
            private boolean alreadyRun = false;

            MyProcessAdapter() {
            }

            public synchronized void run() {
                if (!this.alreadyRun) {
                    this.alreadyRun = true;
                    run2.run();
                }
                DebugProcessImpl.this.removeProcessListener((ProcessListener)this);
            }

            public void startNotified(ProcessEvent event) {
                this.run();
            }
        }
        MyProcessAdapter processListener = new MyProcessAdapter();
        this.addProcessListener((ProcessListener)processListener);
        if (this.myExecutionResult != null && this.myExecutionResult.getProcessHandler().isStartNotified()) {
            processListener.run();
        }
    }

    public boolean isPausePressed() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.isPausePressed();
    }

    public DebuggerCommandImpl createPauseCommand() {
        return new PauseCommand();
    }

    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext) {
        return this.createResumeCommand(suspendContext, PrioritizedTask.Priority.HIGH);
    }

    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext, final PrioritizedTask.Priority priority) {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        return new ResumeCommand(suspendContext){

            @Override
            public void contextAction() {
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, null);
                super.contextAction();
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return priority;
            }
        };
    }

    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        return this.createStepOverCommand(suspendContext, ignoreBreakpoints, -2);
    }

    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        return new StepOverCommand(suspendContext, ignoreBreakpoints, stepSize);
    }

    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext) {
        return this.createStepOutCommand(suspendContext, -2);
    }

    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
        return new StepOutCommand(suspendContext, stepSize);
    }

    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter) {
        return this.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, -2);
    }

    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter, int stepSize) {
        return new StepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
    }

    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) throws EvaluateException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/DebugProcessImpl", "createRunToCursorCommand"));
        }
        RunToCursorCommand runToCursorCommand = new RunToCursorCommand(suspendContext, position, ignoreBreakpoints);
        if (runToCursorCommand.myRunToCursorBreakpoint == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(position.getFile());
            throw new EvaluateException(DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{psiFile != null ? psiFile.getName() : "<No File>", position.getLine()}), null);
        }
        return runToCursorCommand;
    }

    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl thread) {
        return new FreezeThreadCommand(thread);
    }

    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
        return new ResumeThreadCommand(suspendContext, thread);
    }

    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl stackFrame) {
        SuspendContextImpl contextByThread = SuspendManagerUtil.findContextByThread(context.getDebugProcess().getSuspendManager(), stackFrame.threadProxy());
        return new PopFrameCommand(contextByThread, stackFrame);
    }

    public DebuggerContextImpl getDebuggerContext() {
        return this.mySession.getContextManager().getContext();
    }

    public void setXDebugProcess(JavaDebugProcess XDebugProcess2) {
        this.myXDebugProcess = XDebugProcess2;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.myXDebugProcess;
    }

    public boolean areBreakpointsMuted() {
        XDebugSession session = this.mySession.getXDebugSession();
        return session != null && session.areBreakpointsMuted();
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    private class PopFrameCommand
    extends SuspendContextCommandImpl {
        private final StackFrameProxyImpl myStackFrame;

        public PopFrameCommand(SuspendContextImpl context, StackFrameProxyImpl frameProxy) {
            super(context);
            this.myStackFrame = frameProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contextAction() {
            ThreadReferenceProxyImpl thread = this.myStackFrame.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(thread)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (ObjectCollectedException ignored) {
                this.notifyCancelled();
                return;
            }
            SuspendContextImpl suspendContext = this.getSuspendContext();
            if (!suspendContext.suspends(thread)) {
                suspendContext.postponeCommand(this);
                return;
            }
            if (this.myStackFrame.isBottom()) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)DebugProcessImpl.this.myProject, (String)DebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon());
                    }
                });
                return;
            }
            try {
                thread.popFrames(this.myStackFrame);
            }
            catch (EvaluateException e) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)DebugProcessImpl.this.myProject, (String)DebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{e.getLocalizedMessage()}), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon());
                    }
                });
                LOG.info((Throwable)e);
            }
            finally {
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContext);
            }
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        public FreezeThreadCommand(ThreadReferenceProxyImpl thread) {
            this.myThread = thread;
        }

        @Override
        protected void action() throws Exception {
            SuspendManager suspendManager = DebugProcessImpl.this.getSuspendManager();
            if (!suspendManager.isFrozen(this.myThread)) {
                suspendManager.freezeThread(this.myThread);
                SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(1, 0);
                suspendContext.setThread(this.myThread.getThreadReference());
                ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        public ResumeThreadCommand(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            super(suspendContext);
            this.myThread = thread;
        }

        @Override
        public void contextAction() {
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), this.myThread);
            for (SuspendContextImpl suspendContext : suspendingContexts) {
                if (suspendContext.getThread() == this.myThread) {
                    DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                    DebugProcessImpl.this.getManagerThread().invoke(DebugProcessImpl.this.createResumeCommand(suspendContext));
                    continue;
                }
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContext, this.myThread);
            }
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached() || DebugProcessImpl.this.getVirtualMachineProxy().isPausePressed()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            DebugProcessImpl.this.getVirtualMachineProxy().suspend();
            DebugProcessImpl.this.logThreads();
            SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(2, 0);
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        protected final ThreadReferenceProxyImpl myContextThread;

        public ResumeCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
            ThreadReferenceProxyImpl contextThread = DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
            this.myContextThread = contextThread != null ? contextThread : (suspendContext != null ? suspendContext.getThread() : null);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            this.resumeAction();
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).resumed((SuspendContext)this.getSuspendContext());
        }

        protected void resumeAction() {
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        protected void applyThreadFilter(ThreadReferenceProxy thread) {
            if (this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, thread.getThreadReference());
            }
        }
    }

    private abstract class StepCommand
    extends ResumeCommand {
        public StepCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl context = this.getSuspendContext();
            if (context != null && Registry.is((String)"debugger.step.resumes.one.thread") && context.getSuspendPolicy() == 2) {
                DebugProcessImpl.this.getSuspendManager().resumeThread(context, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }
    }

    private class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint myRunToCursorBreakpoint;
        private final boolean myIgnoreBreakpoints;

        private RunToCursorCommand(@NotNull SuspendContextImpl suspendContext, XSourcePosition position, boolean ignoreBreakpoints) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand", "<init>"));
            }
            super(suspendContext);
            this.myIgnoreBreakpoints = ignoreBreakpoints;
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager();
            this.myRunToCursorBreakpoint = breakpointManager.addRunToCursorBreakpoint(position, ignoreBreakpoints);
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
            DebugProcessImpl.this.cancelRunToCursorBreakpoint();
            if (this.myRunToCursorBreakpoint == null) {
                return;
            }
            if (this.myIgnoreBreakpoints) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager();
                breakpointManager.disableBreakpoints(DebugProcessImpl.this);
            }
            this.applyThreadFilter(this.getContextThread());
            final SuspendContextImpl context = this.getSuspendContext();
            this.myRunToCursorBreakpoint.setSuspendPolicy(context.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
            final DebugProcessImpl debugProcess = context.getDebugProcess();
            this.myRunToCursorBreakpoint.createRequest(debugProcess);
            DebugProcessImpl.this.setRunToCursorBreakpoint(this.myRunToCursorBreakpoint);
            if (debugProcess.getRequestsManager().getWarning(this.myRunToCursorBreakpoint) == null) {
                super.contextAction();
            } else {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{RunToCursorCommand.this.myRunToCursorBreakpoint.getSourcePosition().getFile().getName(), RunToCursorCommand.this.myRunToCursorBreakpoint.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                        DebuggerSession session = debugProcess.getSession();
                        session.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, context), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                    }
                });
            }
        }
    }

    private class StepOverCommand
    extends StepCommand {
        private final boolean myIsIgnoreBreakpoints;
        private final int myStepSize;

        public StepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
            super(suspendContext);
            this.myIsIgnoreBreakpoints = ignoreBreakpoints;
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]));
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = new RequestHint(stepThread, suspendContext, 2);
            hint.setRestoreBreakpoints(this.myIsIgnoreBreakpoints);
            hint.setIgnoreFilters(this.myIsIgnoreBreakpoints || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(stepThread);
            MethodReturnValueWatcher rvWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            if (rvWatcher != null) {
                rvWatcher.enable(stepThread.getThreadReference());
            }
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, 2, hint);
            if (this.myIsIgnoreBreakpoints) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            super.contextAction();
        }
    }

    private class StepIntoCommand
    extends StepCommand {
        private final boolean myForcedIgnoreFilters;
        private final MethodFilter mySmartStepFilter;
        @Nullable
        private final StepIntoBreakpoint myBreakpoint;
        private final int myStepSize;

        public StepIntoCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreFilters, MethodFilter methodFilter, int stepSize) {
            super(suspendContext);
            this.myForcedIgnoreFilters = ignoreFilters || methodFilter != null;
            this.mySmartStepFilter = methodFilter;
            this.myBreakpoint = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = this.mySmartStepFilter != null ? new RequestHint(stepThread, suspendContext, this.mySmartStepFilter) : new RequestHint(stepThread, suspendContext, 1);
            hint.setResetIgnoreFilters(this.mySmartStepFilter != null && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            if (this.myForcedIgnoreFilters) {
                try {
                    DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(stepThread.frameCount());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
            }
            hint.setIgnoreFilters(this.myForcedIgnoreFilters || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(stepThread);
            if (this.myBreakpoint != null) {
                this.myBreakpoint.setSuspendPolicy(suspendContext.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
                this.myBreakpoint.createRequest(suspendContext.getDebugProcess());
                DebugProcessImpl.this.setRunToCursorBreakpoint(this.myBreakpoint);
            }
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, 1, hint);
            super.contextAction();
        }
    }

    private class StepOutCommand
    extends StepCommand {
        private final int myStepSize;

        public StepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
            super(suspendContext);
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl thread = this.getContextThread();
            RequestHint hint = new RequestHint(thread, suspendContext, 3);
            hint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(thread);
            MethodReturnValueWatcher rvWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            if (rvWatcher != null) {
                rvWatcher.enable(thread.getThreadReference());
            }
            DebugProcessImpl.this.doStep(suspendContext, thread, this.myStepSize, 3, hint);
            super.contextAction();
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean myIsTerminateTargetVM;

        public StopCommand(boolean isTerminateTargetVM) {
            this.myIsTerminateTargetVM = isTerminateTargetVM;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        protected void action() throws Exception {
            if (DebugProcessImpl.this.isAttached()) {
                VirtualMachineProxyImpl virtualMachineProxy = DebugProcessImpl.this.getVirtualMachineProxy();
                if (this.myIsTerminateTargetVM) {
                    virtualMachineProxy.exit(-1);
                } else {
                    try {
                        virtualMachineProxy.resume();
                    }
                    finally {
                        virtualMachineProxy.dispose();
                    }
                }
            } else {
                DebugProcessImpl.this.stopConnecting();
            }
        }
    }

    private abstract class InvokeCommand<E extends Value> {
        private final Method myMethod;
        private final List myArgs;

        protected InvokeCommand(@NotNull Method method, List args) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/engine/DebugProcessImpl$InvokeCommand", "<init>"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/debugger/engine/DebugProcessImpl$InvokeCommand", "<init>"));
            }
            this.myMethod = method;
            this.myArgs = !args.isEmpty() ? new ArrayList(args) : args;
        }

        public String toString() {
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(int var1, Method var2, List var3) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException {
            while (true) {
                try {
                    return this.startInternal(evaluationContext, internalEvaluate);
                }
                catch (ClassNotLoadedException e) {
                    ReferenceType loadedClass = null;
                    try {
                        if (!evaluationContext.isAutoLoadClasses()) continue;
                        loadedClass = DebugProcessImpl.this.loadClass(evaluationContext, e.className(), evaluationContext.getClassLoader());
                        continue;
                    }
                    catch (Exception ignored) {
                        loadedClass = null;
                    }
                    if (loadedClass != null) continue;
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                break;
            }
        }

        E startInternal(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException, ClassNotLoadedException {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContextImpl suspendContext = evaluationContext.getSuspendContext();
            SuspendManagerUtil.assertSuspendContext(suspendContext);
            ThreadReferenceProxyImpl invokeThread = suspendContext.getThread();
            if (SuspendManagerUtil.isEvaluating(DebugProcessImpl.this.getSuspendManager(), invokeThread)) {
                throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
            }
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), invokeThread);
            ThreadReference invokeThreadRef = invokeThread.getThreadReference();
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(suspendContext);
            DebugProcessImpl.this.beforeMethodInvocation(suspendContext, this.myMethod, internalEvaluate);
            Object resumeData = null;
            try {
                for (SuspendContextImpl suspendingContext : suspendingContexts) {
                    ThreadReferenceProxyImpl suspendContextThread = suspendingContext.getThread();
                    if (suspendContextThread == invokeThread) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resuming " + invokeThread + " that is paused by " + suspendContextThread);
                    }
                    LOG.assertTrue(suspendContextThread == null || !invokeThreadRef.equals(suspendContextThread.getThreadReference()));
                    DebugProcessImpl.this.getSuspendManager().resumeThread(suspendingContext, invokeThread);
                }
                resumeData = SuspendManagerUtil.prepareForResume(suspendContext);
                suspendContext.setIsEvaluating(evaluationContext);
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                Iterator<SuspendContextImpl> iterator = this.invokeMethodAndFork(suspendContext);
                return (E)iterator;
            }
            catch (InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InvalidTypeException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InternalException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            finally {
                suspendContext.setIsEvaluating(null);
                if (resumeData != null) {
                    SuspendManagerUtil.restoreAfterResume(suspendContext, resumeData);
                }
                for (SuspendContextImpl suspendingContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                    if (!suspendingContexts.contains((Object)suspendingContext) || suspendingContext.isEvaluating() || suspendingContext.suspends(invokeThread)) continue;
                    DebugProcessImpl.this.mySuspendManager.suspendThread(suspendingContext, invokeThread);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getVirtualMachine().clearCaches()");
                }
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                DebugProcessImpl.this.afterMethodInvocation(suspendContext, internalEvaluate);
                ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContext);
            }
        }

        private E invokeMethodAndFork(final SuspendContextImpl context) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            final int invokePolicy = DebugProcessImpl.getInvokePolicy(context);
            final Exception[] exception = new Exception[1];
            final Value[] result = new Value[1];
            DebugProcessImpl.this.getManagerThread().startLongProcessAndFork(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ThreadReferenceProxyImpl thread = context.getThread();
                    try {
                        try {
                            List<String> argTypes;
                            ArrayReference arrayRef;
                            Object lastArg;
                            int lastIndex;
                            if (LOG.isDebugEnabled()) {
                                VirtualMachineProxyImpl virtualMachineProxy = DebugProcessImpl.this.getVirtualMachineProxy();
                                virtualMachineProxy.logThreads();
                                LOG.debug("Invoke in " + thread.name());
                                InvokeCommand.this.assertThreadSuspended(thread, context);
                            }
                            if (InvokeCommand.this.myMethod.isVarArgs() && (lastIndex = InvokeCommand.this.myArgs.size() - 1) >= 0 && (lastArg = InvokeCommand.this.myArgs.get(lastIndex)) instanceof ArrayReference && ((ArrayType)(arrayRef = (ArrayReference)lastArg).referenceType()).componentType() instanceof InterfaceType && (argTypes = InvokeCommand.this.myMethod.argumentTypeNames()).size() > lastIndex && argTypes.get(lastIndex).startsWith("java.lang.Object")) {
                                InvokeCommand.this.myArgs.remove(lastIndex);
                                InvokeCommand.this.myArgs.addAll(arrayRef.getValues());
                            }
                            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                                for (Object arg : InvokeCommand.this.myArgs) {
                                    if (!(arg instanceof ObjectReference)) continue;
                                    DebuggerUtilsEx.disableCollection((ObjectReference)arg);
                                }
                            }
                            if (!StringUtil.isEmpty((String)ourTrace)) {
                                for (Object arg : InvokeCommand.this.myArgs) {
                                    arg.toString();
                                }
                            }
                            result[0] = InvokeCommand.this.invokeMethod(invokePolicy, InvokeCommand.this.myMethod, InvokeCommand.this.myArgs);
                        }
                        finally {
                            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                                for (Object arg : InvokeCommand.this.myArgs) {
                                    if (!(arg instanceof ObjectReference)) continue;
                                    DebuggerUtilsEx.enableCollection((ObjectReference)arg);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        exception[0] = e;
                    }
                }
            });
            if (exception[0] != null) {
                if (exception[0] instanceof InvocationException) {
                    throw (InvocationException)exception[0];
                }
                if (exception[0] instanceof ClassNotLoadedException) {
                    throw (ClassNotLoadedException)exception[0];
                }
                if (exception[0] instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)exception[0];
                }
                if (exception[0] instanceof InvalidTypeException) {
                    throw (InvalidTypeException)exception[0];
                }
                if (exception[0] instanceof RuntimeException) {
                    throw (RuntimeException)exception[0];
                }
                LOG.error("Unexpected exception", new Throwable().initCause(exception[0]));
            }
            return (E)result[0];
        }

        private void assertThreadSuspended(ThreadReferenceProxyImpl thread, SuspendContextImpl context) {
            LOG.assertTrue(context.isEvaluating());
            try {
                boolean isSuspended = thread.isSuspended();
                LOG.assertTrue(isSuspended, (Object)thread);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }
    }
}

