/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaLineBreakpointTypeBase<P extends JavaBreakpointProperties>
extends XLineBreakpointType<P> {
    public JavaLineBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "<init>"));
        }
        super(id, title);
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public final boolean isSuspendThreadSupported() {
        return true;
    }

    @Nullable
    public final XBreakpointCustomPropertiesPanel<XLineBreakpoint<P>> createCustomRightPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "createCustomRightPropertiesPanel"));
        }
        return new JavaBreakpointFiltersPanel(project);
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<P> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "getEditorsProvider"));
        }
        return new JavaDebuggerEditorsProvider();
    }

    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        BreakpointWithHighlighter javaBreakpoint = (BreakpointWithHighlighter)BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null) {
            return javaBreakpoint.getDescription();
        }
        return super.getDisplayText(breakpoint);
    }

    public boolean canPutAt(@NotNull VirtualFile file, final int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase", "canPutAt"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || psiFile.getViewProvider().getFileType() == StdFileTypes.XHTML) {
            return false;
        }
        if (!StdFileTypes.CLASS.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        final Ref result = Ref.create();
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiImportStatementBase.class, PsiPackageStatement.class}) != null) {
                    return true;
                }
                PsiElement parent = element;
                while (element != null) {
                    if (element instanceof PsiModifierList) {
                        element = element.getParent();
                        continue;
                    }
                    int offset = element.getTextOffset();
                    if (offset >= 0 && document.getLineNumber(offset) != line) break;
                    parent = element;
                    element = element.getParent();
                }
                if (parent instanceof PsiMethod) {
                    PsiStatement[] statements;
                    PsiCodeBlock body;
                    if (parent.getTextRange().getEndOffset() >= document.getLineEndOffset(line) && (body = ((PsiMethod)parent).getBody()) != null && (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == line) {
                        result.set(JavaLineBreakpointType.class);
                    }
                    if (result.isNull()) {
                        result.set(JavaMethodBreakpointType.class);
                    }
                } else if (parent instanceof PsiField) {
                    if (result.isNull()) {
                        result.set(JavaFieldBreakpointType.class);
                    }
                } else {
                    result.set(JavaLineBreakpointType.class);
                }
                return true;
            }
        });
        return result.get() == ((Object)((Object)this)).getClass();
    }
}

