/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class ArgumentValueDescriptorImpl
extends ValueDescriptorImpl {
    private final int myIndex;
    private final Value myValue;
    private String myName;
    private boolean myParameterNameCalcutated;
    private final String myDefaultName;
    private final boolean myIsParam;

    public ArgumentValueDescriptorImpl(Project project, int index, Value value, String name) {
        super(project);
        this.myIndex = index;
        this.myValue = value;
        this.myIsParam = name == null;
        this.myName = this.myDefaultName = name != null ? name : "arg" + String.valueOf(index);
        this.setLvalue(true);
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.myValue instanceof PrimitiveValue;
    }

    @Override
    public Value calcValue(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PsiMethod method;
                SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
                if (position != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiMethod.class)) != null) {
                    PsiParameterList params = method.getParameterList();
                    if (ArgumentValueDescriptorImpl.this.myIndex < params.getParametersCount()) {
                        PsiParameter param = params.getParameters()[ArgumentValueDescriptorImpl.this.myIndex];
                        ArgumentValueDescriptorImpl.this.myName = param.getName();
                        ArgumentValueDescriptorImpl.this.myParameterNameCalcutated = true;
                    } else {
                        PsiCodeBlock body = method.getBody();
                        if (body != null) {
                            StringBuilder nameBuilder = new StringBuilder();
                            try {
                                body.accept((PsiElementVisitor)new LocalVariableNameFinder(ArgumentValueDescriptorImpl.getFirstLocalsSlot(method), nameBuilder));
                                ArgumentValueDescriptorImpl.this.myName = nameBuilder.length() > 0 ? ArgumentValueDescriptorImpl.this.myDefaultName + ": " + nameBuilder.toString() : ArgumentValueDescriptorImpl.this.myDefaultName;
                            }
                            catch (Throwable throwable) {
                                ArgumentValueDescriptorImpl.this.myName = nameBuilder.length() > 0 ? ArgumentValueDescriptorImpl.this.myDefaultName + ": " + nameBuilder.toString() : ArgumentValueDescriptorImpl.this.myDefaultName;
                                throw throwable;
                            }
                        }
                    }
                }
            }
        });
        return this.myValue;
    }

    private static int getFirstLocalsSlot(PsiMethod method) {
        int startSlot = method.hasModifierProperty("static") ? 0 : 1;
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            startSlot += ArgumentValueDescriptorImpl.getTypeSlotSize(parameter.getType());
        }
        return startSlot;
    }

    private static int getTypeSlotSize(PsiType varType) {
        if (varType == PsiType.DOUBLE || varType == PsiType.LONG) {
            return 2;
        }
        return 1;
    }

    public static int getFirstLocalsSlot(Method method) {
        int firstLocalVariableSlot = method.isStatic() ? 0 : 1;
        for (String type : method.argumentTypeNames()) {
            firstLocalVariableSlot += ArgumentValueDescriptorImpl.getTypeSlotSize(type);
        }
        return firstLocalVariableSlot;
    }

    private static int getTypeSlotSize(String name) {
        if ("double".equals(name) || "long".equals(name)) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public boolean isParameter() {
        return this.myIsParam;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        if (!this.myParameterNameCalcutated) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }

    private class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final int myStartSlot;
        private final StringBuilder myNameBuilder;
        private final Set<String> myVisitedNames = new HashSet<String>();
        private int myCurrentSlotIndex;
        private final Stack<Integer> myIndexStack;

        public LocalVariableNameFinder(int startSlot, StringBuilder nameBuilder) {
            this.myStartSlot = startSlot;
            this.myNameBuilder = nameBuilder;
            this.myCurrentSlotIndex = this.myStartSlot;
            this.myIndexStack = new Stack();
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.appendName(variable.getName());
            this.myCurrentSlotIndex += ArgumentValueDescriptorImpl.getTypeSlotSize(variable.getType());
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                this.appendName("<monitor>");
                ++this.myCurrentSlotIndex;
                super.visitSynchronizedStatement(statement);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        private void appendName(String varName) {
            if (this.myCurrentSlotIndex == ArgumentValueDescriptorImpl.this.myIndex && this.myVisitedNames.add(varName)) {
                if (this.myNameBuilder.length() != 0) {
                    this.myNameBuilder.append(" | ");
                }
                this.myNameBuilder.append(varName);
            }
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                super.visitCodeBlock(block);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        public void visitForStatement(PsiForStatement statement) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                super.visitForStatement(statement);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                super.visitForeachStatement(statement);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        public void visitCatchSection(PsiCatchSection section) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                super.visitCatchSection(section);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            this.myIndexStack.push(this.myCurrentSlotIndex);
            try {
                super.visitResourceList(resourceList);
            }
            finally {
                this.myCurrentSlotIndex = this.myIndexStack.pop();
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }
}

