/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewerEx
extends ThreesideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(ThreesideTextDiffViewerEx.class);
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable1;
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable2;
    @NotNull
    protected final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    protected final MyStatusPanel myStatusPanel;
    @NotNull
    protected final MyFoldingModel myFoldingModel;
    @NotNull
    protected final MyInitialScrollHelper myInitialScrollHelper;
    private int myChangesCount;
    private int myConflictsCount;

    public ThreesideTextDiffViewerEx(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "<init>"));
        }
        super(context, request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myChangesCount = -1;
        this.myConflictsCount = -1;
        this.mySyncScrollable1 = new MySyncScrollable(Side.LEFT);
        this.mySyncScrollable2 = new MySyncScrollable(Side.RIGHT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getEditors().toArray(new EditorEx[3]), (Disposable)this);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter(Side.LEFT), Side.LEFT);
        this.myContentPanel.setPainter(new MyDividerPainter(Side.RIGHT), Side.RIGHT);
        this.myContentPanel.setScrollbarPainter(new MyScrollbarPainter());
    }

    @Override
    protected void onDispose() {
        this.destroyChangedBlocks();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getFoldingModelSettings"));
        }
        return settings;
    }

    @NotNull
    protected Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ThreesideTextDiffViewerEx.this.clearDiffPresentation();
                if (notification != null) {
                    ThreesideTextDiffViewerEx.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "applyNotification"));
        }
        return runnable;
    }

    protected void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
        this.myContentPanel.repaintDividers();
        this.myStatusPanel.update();
    }

    protected void destroyChangedBlocks() {
        this.myFoldingModel.destroy();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        this.myFoldingModel.onDocumentChanged(e);
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        if (scrollToPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToPolicy", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "doScrollToChange"));
        }
        ThreesideDiffChangeBase targetChange = scrollToPolicy.select(this.getChanges());
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    protected void doScrollToChange(@NotNull ThreesideDiffChangeBase change, boolean animated) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "doScrollToChange"));
        }
        int[] startLines = new int[3];
        int[] endLines = new int[3];
        for (int i = 0; i < 3; ++i) {
            ThreeSide side = ThreeSide.fromIndex((int)i);
            startLines[i] = change.getStartLine(side);
            endLines[i] = change.getEndLine(side);
            DiffUtil.moveCaret(this.getEditor(side), startLines[i]);
        }
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), startLines, endLines, animated);
    }

    public int getChangesCount() {
        return this.myChangesCount;
    }

    public int getConflictsCount() {
        return this.myConflictsCount;
    }

    protected void resetChangeCounters() {
        this.myChangesCount = 0;
        this.myConflictsCount = 0;
    }

    protected void onChangeAdded(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "onChangeAdded"));
        }
        if (change.isConflict()) {
            ++this.myConflictsCount;
        } else {
            ++this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    protected void onChangeRemoved(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "onChangeRemoved"));
        }
        if (change.isConflict()) {
            --this.myConflictsCount;
        } else {
            --this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    @NotNull
    protected abstract DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side var1);

    @NotNull
    protected List<? extends ThreesideDiffChangeBase> getAllChanges() {
        List<? extends ThreesideDiffChangeBase> list = this.getChanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getAllChanges"));
        }
        return list;
    }

    @NotNull
    protected abstract List<? extends ThreesideDiffChangeBase> getChanges();

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getSyncScrollable"));
        }
        SyncScrollSupport.SyncScrollable syncScrollable = (SyncScrollSupport.SyncScrollable)side.select((Object)this.mySyncScrollable1, (Object)this.mySyncScrollable2);
        if (syncScrollable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getSyncScrollable"));
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    @NotNull
    public SyncScrollSupport.ThreesideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.ThreesideSyncScrollSupport threesideSyncScrollSupport = this.mySyncScrollSupport;
        if (threesideSyncScrollSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getSyncScrollSupport"));
        }
        return threesideSyncScrollSupport;
    }

    @Nullable
    protected ThreesideDiffChangeBase getSelectedChange(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx", "getSelectedChange"));
        }
        int caretLine = this.getEditor((ThreeSide)side).getCaretModel().getLogicalPosition().line;
        for (ThreesideDiffChangeBase threesideDiffChangeBase : this.getChanges()) {
            int line2;
            int line1 = threesideDiffChangeBase.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = threesideDiffChangeBase.getEndLine(side))) continue;
            return threesideDiffChangeBase;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        ThreesideDiffChangeBase change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    protected class MyInitialScrollHelper
    extends ThreesideTextDiffViewer.MyInitialScrollPositionHelper {
        protected MyInitialScrollHelper() {
            super(ThreesideTextDiffViewerEx.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return ThreesideTextDiffViewerEx.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return ThreesideTextDiffViewerEx.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }
    }

    protected static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable1;
        private final FoldingModelSupport.MyPaintable myPaintable2;

        public MyFoldingModel(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "<init>"));
            }
            super(editors, disposable);
            this.myPaintable1 = new FoldingModelSupport.MyPaintable(this, 0, 1);
            this.myPaintable2 = new FoldingModelSupport.MyPaintable(this, 1, 2);
            assert (editors.length == 3);
        }

        public void install(@Nullable List<MergeLineFragment> fragments, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "install"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(fragments, new Function<MergeLineFragment, int[]>(){

                public int[] fun(MergeLineFragment fragment) {
                    return new int[]{fragment.getStartLine(ThreeSide.LEFT), fragment.getEndLine(ThreeSide.LEFT), fragment.getStartLine(ThreeSide.BASE), fragment.getEndLine(ThreeSide.BASE), fragment.getStartLine(ThreeSide.RIGHT), fragment.getEndLine(ThreeSide.RIGHT)};
                }
            });
            this.install(it, context, settings);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider, @NotNull Side side) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "paintOnDivider"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "paintOnDivider"));
            }
            FoldingModelSupport.MyPaintable paintable = (FoldingModelSupport.MyPaintable)side.select((Object)this.myPaintable1, (Object)this.myPaintable2);
            paintable.paintOnDivider(gg, divider);
        }

        public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel", "paintOnScrollbar"));
            }
            this.myPaintable2.paintOnScrollbar(gg, width);
        }
    }

    protected class MyStatusPanel
    extends StatusPanel {
        protected MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (ThreesideTextDiffViewerEx.this.myChangesCount < 0 || ThreesideTextDiffViewerEx.this.myConflictsCount < 0) {
                return null;
            }
            if (ThreesideTextDiffViewerEx.this.myChangesCount == 0 && ThreesideTextDiffViewerEx.this.myConflictsCount == 0) {
                return DiffBundle.message((String)"merge.dialog.all.conflicts.resolved.message.text", (Object[])new Object[0]);
            }
            return this.makeCounterWord(ThreesideTextDiffViewerEx.this.myChangesCount, "change") + ". " + this.makeCounterWord(ThreesideTextDiffViewerEx.this.myConflictsCount, "conflict");
        }

        @NotNull
        private String makeCounterWord(int number, @NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyStatusPanel", "makeCounterWord"));
            }
            if (number == 0) {
                String string = "No " + StringUtil.pluralize((String)word);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyStatusPanel", "makeCounterWord"));
                }
                return string;
            }
            String string = number + " " + StringUtil.pluralize((String)word, (int)number);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyStatusPanel", "makeCounterWord"));
            }
            return string;
        }
    }

    protected class MyScrollbarPainter
    implements ButtonlessScrollBarUI.ScrollbarRepaintCallback {
        @NotNull
        private final DiffDividerDrawUtil.DividerPaintable myPaintable;

        protected MyScrollbarPainter() {
            this.myPaintable = ThreesideTextDiffViewerEx.this.getDividerPaintable(Side.RIGHT);
        }

        public void call(Graphics g) {
            EditorEx editor1 = ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE);
            EditorEx editor2 = ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.RIGHT);
            int width = editor1.getScrollPane().getVerticalScrollBar().getWidth();
            DiffDividerDrawUtil.paintPolygonsOnScrollbar((Graphics2D)g, width, editor1, editor2, this.myPaintable);
            ThreesideTextDiffViewerEx.this.myFoldingModel.paintOnScrollbar((Graphics2D)g, width);
        }
    }

    protected class MyDividerPainter
    implements DiffSplitter.Painter {
        @NotNull
        private final Side mySide;
        @NotNull
        private final DiffDividerDrawUtil.DividerPaintable myPaintable;

        public MyDividerPainter(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyDividerPainter", "<init>"));
            }
            this.mySide = side;
            this.myPaintable = ThreesideTextDiffViewerEx.this.getDividerPaintable(side);
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyDividerPainter", "paint"));
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE).getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE)));
            gg.fill(gg.getClipBounds());
            Editor editor1 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.LEFT), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE));
            Editor editor2 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.RIGHT));
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), editor1, editor2, this.myPaintable);
            ThreesideTextDiffViewerEx.this.myFoldingModel.paintOnDivider(gg, divider, this.mySide);
            gg.dispose();
        }
    }

    protected class MySyncScrollable
    extends BaseSyncScrollable {
        @NotNull
        private final Side mySide;

        public MySyncScrollable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MySyncScrollable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return ThreesideTextDiffViewerEx.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MySyncScrollable", "processHelper"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            if (!helper.process(0, 0)) {
                return;
            }
            for (ThreesideDiffChangeBase threesideDiffChangeBase : ThreesideTextDiffViewerEx.this.getAllChanges()) {
                if (!helper.process(threesideDiffChangeBase.getStartLine(left), threesideDiffChangeBase.getStartLine(right))) {
                    return;
                }
                if (helper.process(threesideDiffChangeBase.getEndLine(left), threesideDiffChangeBase.getEndLine(right))) continue;
                return;
            }
            helper.process(ThreesideTextDiffViewerEx.this.getEditor(left).getDocument().getLineCount(), ThreesideTextDiffViewerEx.this.getEditor(right).getDocument().getLineCount());
        }
    }

    protected class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(ThreesideTextDiffViewerEx.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            ThreesideTextDiffViewerEx.this.myFoldingModel.expandAll(expand);
        }
    }

    protected class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ThreesideDiffChangeBase> {
        protected MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<? extends ThreesideDiffChangeBase> getChanges() {
            List<? extends ThreesideDiffChangeBase> list = ThreesideTextDiffViewerEx.this.getChanges();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable", "getChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = ThreesideTextDiffViewerEx.this.getCurrentEditor();
            if (editorEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable", "getEditor"));
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable", "getStartLine"));
            }
            return change.getStartLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable", "getEndLine"));
            }
            return change.getEndLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable", "scrollToChange"));
            }
            ThreesideTextDiffViewerEx.this.doScrollToChange(change, true);
        }
    }
}

