/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
implements RepositoryManager<T> {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final String myRepoDirName;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;

    protected AbstractRepositoryManager(@NotNull VcsRepositoryManager globalRepositoryManager, @NotNull AbstractVcs vcs, @NotNull String repoDirName) {
        if (globalRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalRepositoryManager", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        if (repoDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoDirName", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        this.myGlobalRepositoryManager = globalRepositoryManager;
        this.myVcs = vcs;
        this.myRepoDirName = repoDirName;
    }

    @Nullable
    public T getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRoot(root));
    }

    @Nullable
    public T getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(root));
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull T repository) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/repo/AbstractRepositoryManager", "addExternalRepository"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/repo/AbstractRepositoryManager", "addExternalRepository"));
        }
        this.myGlobalRepositoryManager.addExternalRepository(root, (Repository)repository);
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/repo/AbstractRepositoryManager", "removeExternalRepository"));
        }
        this.myGlobalRepositoryManager.removeExternalRepository(root);
    }

    public boolean isExternal(@NotNull T repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/repo/AbstractRepositoryManager", "isExternal"));
        }
        return this.myGlobalRepositoryManager.isExternal((Repository)repository);
    }

    @Nullable
    public T getRepositoryForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositoryForFile"));
        }
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file));
    }

    @Nullable
    public T getRepositoryForFile(@NotNull FilePath file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositoryForFile"));
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file);
        return vFile != null ? (T)this.getRepositoryForFile(vFile) : null;
    }

    @NotNull
    protected List<T> getRepositories(Class<T> type) {
        List list = ContainerUtil.findAll(this.myGlobalRepositoryManager.getRepositories(), type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositories"));
        }
        return list;
    }

    @NotNull
    public abstract List<T> getRepositories();

    public boolean moreThanOneRoot() {
        return this.getRepositories().size() > 1;
    }

    public void updateRepository(@Nullable VirtualFile root) {
        T repo = this.getRepositoryForRoot(root);
        if (repo != null) {
            repo.update();
        }
    }

    public void updateAllRepositories() {
        ContainerUtil.process(this.getRepositories(), (Processor)new Processor<T>(){

            public boolean process(T repo) {
                repo.update();
                return true;
            }
        });
    }

    @Nullable
    private T validateAndGetRepository(@Nullable Repository repository) {
        if (repository == null || !this.myVcs.equals((Object)repository.getVcs())) {
            return null;
        }
        VirtualFile vcsDir = repository.getRoot().findChild(this.myRepoDirName);
        return (T)(vcsDir != null && vcsDir.exists() ? repository : null);
    }
}

