/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public abstract class BaseJavaApplicationCommandLineState<T extends RunConfigurationBase>
extends JavaCommandLineState {
    protected final T myConfiguration;

    public BaseJavaApplicationCommandLineState(ExecutionEnvironment environment, @NotNull T configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/application/BaseJavaApplicationCommandLineState", "<init>"));
        }
        super(environment);
        this.myConfiguration = configuration;
    }

    protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)this.myConfiguration);
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])RunConfigurationExtension.EP_NAME.getExtensions()) {
            ext.updateJavaParameters(this.getConfiguration(), params, this.getRunnerSettings());
        }
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        Object handler2;
        if (SystemInfo.isWindows) {
            handler2 = super.startProcess();
        } else {
            handler2 = KillableColoredProcessHandler.create(this.createCommandLine());
            ProcessTerminatedListener.attach((ProcessHandler)handler2);
        }
        RunnerSettings runnerSettings = this.getRunnerSettings();
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler2, runnerSettings);
        Object object = handler2;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/BaseJavaApplicationCommandLineState", "startProcess"));
        }
        return object;
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected T getConfiguration() {
        return this.myConfiguration;
    }
}

