/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.Nullable;

public class JavaScratchPositionManager
extends PositionManagerImpl {
    private final VirtualFile myScratchFile;

    public JavaScratchPositionManager(DebugProcessImpl debugProcess, VirtualFile scratchFile) {
        super(debugProcess);
        this.myScratchFile = scratchFile;
    }

    @Override
    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        String alternativeQName;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.myScratchFile);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        String originalQName = refType.name();
        for (PsiClass aClass : classes) {
            if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)aClass.getQualifiedName())) continue;
            return psiFile;
        }
        int dollar = originalQName.indexOf(36);
        String string = alternativeQName = dollar > 0 ? originalQName.substring(0, dollar) : null;
        if (!StringUtil.isEmpty((String)alternativeQName)) {
            for (PsiClass aClass : classes) {
                if (!StringUtil.equals((CharSequence)alternativeQName, (CharSequence)aClass.getQualifiedName())) continue;
                return psiFile;
            }
        }
        return null;
    }
}

