/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.JavaScratchPositionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchRunConfigurationExtension
extends RunConfigurationExtension {
    private static final Key<Integer> SCRATCH_FILE_ID = Key.create((String)"_scratch_file_id_");

    @Override
    public void cleanUserData(RunConfigurationBase configuration) {
        super.cleanUserData(configuration);
        configuration.putCopyableUserData(SCRATCH_FILE_ID, null);
    }

    protected void extendCreatedConfiguration(@NotNull RunConfigurationBase configuration, @NotNull Location location) {
        PsiFile psiFile;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "extendCreatedConfiguration"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "extendCreatedConfiguration"));
        }
        VirtualFile vFile = location.getVirtualFile();
        if (vFile instanceof VirtualFileWithId && vFile.getFileType() == ScratchFileType.INSTANCE && (psiFile = location.getPsiElement().getContainingFile()) != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            configuration.putCopyableUserData(SCRATCH_FILE_ID, (Object)((VirtualFileWithId)vFile).getId());
        }
    }

    protected void validateConfiguration(@NotNull RunConfigurationBase configuration, boolean isExecution) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "validateConfiguration"));
        }
        super.validateConfiguration(configuration, isExecution);
    }

    @Override
    public <T extends RunConfigurationBase> void updateJavaParameters(T configuration, JavaParameters params, RunnerSettings runnerSettings) throws ExecutionException {
        File scrachesOutput;
        if (JavaScratchRunConfigurationExtension.getScratchFileId(configuration) >= 0 && (scrachesOutput = JavaScratchRunConfigurationExtension.getScratchOutputDirectory(configuration.getProject())) != null) {
            params.getClassPath().add(scrachesOutput);
        }
    }

    protected void attachToProcess(@NotNull RunConfigurationBase configuration, @NotNull ProcessHandler handler2, @Nullable RunnerSettings runnerSettings) {
        VirtualFile vFile;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "attachToProcess"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "attachToProcess"));
        }
        if (runnerSettings instanceof DebuggingRunnerData && JavaScratchRunConfigurationExtension.getScratchFileId((RunConfiguration)configuration) >= 0 && (vFile = JavaScratchRunConfigurationExtension.getScratchVirtualFile((RunConfiguration)configuration)) != null) {
            DebuggerManager.getInstance((Project)configuration.getProject()).addDebugProcessListener(handler2, (DebugProcessListener)new DebugProcessAdapter(){

                public void processAttached(DebugProcess process) {
                    if (vFile.isValid()) {
                        process.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process, vFile));
                    }
                    process.removeDebugProcessListener((DebugProcessListener)this);
                }
            });
        }
    }

    @NotNull
    protected String getSerializationId() {
        if ("java-scratch-properties" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "getSerializationId"));
        }
        return "java-scratch-properties";
    }

    @Nullable
    public static String getScratchFileUrl(RunConfiguration configuration) {
        VirtualFile vFile = JavaScratchRunConfigurationExtension.getScratchVirtualFile(configuration);
        return vFile != null ? vFile.getUrl() : null;
    }

    @Nullable
    private static VirtualFile getScratchVirtualFile(RunConfiguration configuration) {
        int id = JavaScratchRunConfigurationExtension.getScratchFileId(configuration);
        if (id < 0) {
            return null;
        }
        return ManagingFS.getInstance().findFileById(id);
    }

    private static int getScratchFileId(RunConfiguration configuration) {
        Integer id = configuration instanceof RunConfigurationBase ? (Integer)((RunConfigurationBase)configuration).getCopyableUserData(SCRATCH_FILE_ID) : null;
        return id == null ? -1 : id;
    }

    @Nullable
    public static File getScratchOutputDirectory(Project project) {
        File root = CompilerManager.getInstance((Project)project).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/out") : null;
    }

    @Nullable
    public static File getScratchTempDirectory(Project project) {
        File root = CompilerManager.getInstance((Project)project).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/src") : null;
    }

    protected void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        String idStr;
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "readExternal"));
        }
        Element sourceElement = element.getChild("source");
        if (sourceElement != null && (idStr = sourceElement.getAttributeValue("fileId")) != null) {
            try {
                runConfiguration.putCopyableUserData(SCRATCH_FILE_ID, (Object)Integer.parseInt(idStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "writeExternal"));
        }
        int id = JavaScratchRunConfigurationExtension.getScratchFileId((RunConfiguration)runConfiguration);
        if (id < 0) {
            super.writeExternal(runConfiguration, element);
        } else {
            Element sourceElement = new Element("source");
            sourceElement.setAttribute("fileId", String.valueOf(id));
            element.addContent(sourceElement);
        }
    }

    @Nullable
    protected <P extends RunConfigurationBase> SettingsEditor<P> createEditor(@NotNull P configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "createEditor"));
        }
        return null;
    }

    @Nullable
    protected String getEditorTitle() {
        return null;
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/impl/JavaScratchRunConfigurationExtension", "isApplicableFor"));
        }
        return configuration instanceof ApplicationConfiguration;
    }
}

