/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module, FacetType<F, ?> type) {
        final ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
        F facet = FacetUtil.createFacet(module, type);
        ApplicationManager.getApplication().runWriteAction(new Runnable((Facet)facet){
            final /* synthetic */ Facet val$facet;
            {
                this.val$facet = facet;
            }

            @Override
            public void run() {
                model.addFacet(this.val$facet);
                model.commit();
            }
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module, FacetType<F, C> type) {
        return (F)FacetManager.getInstance((Module)module).createFacet(type, type.getPresentableName(), type.createDefaultConfiguration(), null);
    }

    public static void deleteFacet(final Facet facet) {
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/facet/impl/FacetUtil$2", "run"));
                }
                if (!FacetUtil.isRegistered(facet)) {
                    return;
                }
                ModifiableFacetModel model = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
                model.removeFacet(facet);
                model.commit();
            }
        }.execute();
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration, @Nullable Element config) throws InvalidDataException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/facet/impl/FacetUtil", "loadFacetConfiguration"));
        }
        if (config != null) {
            if (configuration instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)configuration, config);
            } else {
                configuration.readExternal(config);
            }
        }
    }

    public static Element saveFacetConfiguration(FacetConfiguration configuration) throws WriteExternalException {
        if (configuration instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration).getState();
            if (state instanceof Element) {
                return (Element)state;
            }
            return XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        Element config = new Element("configuration");
        configuration.writeExternal(config);
        return config;
    }
}

