/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.BundleBase;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindResult;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectTask;
import com.intellij.find.impl.FindResultUsageInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectUtil {
    private static final int USAGES_PER_READ_ACTION = 100;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(@NotNull FindModel model, @NotNull DataContext dataContext) {
        Module module;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindInProjectUtil", "setDirectoryName"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/impl/FindInProjectUtil", "setDirectoryName"));
        }
        PsiElement psiElement = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && !DumbServiceImpl.getInstance(project).isDumb()) {
            try {
                psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model.setModuleName(module.getName());
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (model.getModuleName() == null || editor == null) {
            model.setDirectoryName(directoryName);
            model.setProjectScope(directoryName == null && module == null && !model.isCustomScope() || editor != null);
            if (directoryName != null) {
                model.setCustomScope(false);
            }
            if (directoryName == null) {
                VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
                if (virtualFile != null && !virtualFile.isDirectory()) {
                    virtualFile = virtualFile.getParent();
                }
                if (virtualFile != null) {
                    model.setDirectoryName(virtualFile.getPresentableUrl());
                }
            }
        }
    }

    @Nullable
    public static PsiDirectory getPsiDirectory(@NotNull FindModel findModel, @NotNull Project project) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getPsiDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "getPsiDirectory"));
        }
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        return directory == null ? null : PsiManager.getInstance((Project)project).findDirectory(directory);
    }

    @Nullable
    public static VirtualFile getDirectory(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getDirectory"));
        }
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || StringUtil.isEmpty((String)directoryName)) {
            return null;
        }
        String path = directoryName.replace(File.separatorChar, '/');
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            virtualFile = null;
            for (LocalFileProvider provider : ((VirtualFileManagerEx)VirtualFileManager.getInstance()).getLocalFileProviders()) {
                VirtualFile file = provider.findLocalVirtualFileByPath(path);
                if (file == null || !file.isDirectory()) continue;
                if (file.getChildren().length > 0) {
                    virtualFile = file;
                    break;
                }
                if (virtualFile != null) continue;
                virtualFile = file;
            }
        }
        return virtualFile;
    }

    @Nullable
    public static Pattern createFileMaskRegExp(@Nullable String filter) {
        if (filter == null) {
            return null;
        }
        List strings = StringUtil.split((String)filter, (String)",");
        String pattern = strings.size() == 1 ? PatternUtil.convertToRegex((String)filter.trim()) : StringUtil.join((Collection)strings, (Function)new Function<String, String>(){

            @NotNull
            public String fun(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindInProjectUtil$1", "fun"));
                }
                String string = "(" + PatternUtil.convertToRegex((String)s.trim()) + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$1", "fun"));
                }
                return string;
            }
        }, (String)"|");
        return Pattern.compile(pattern, 2);
    }

    public static void findUsages(@NotNull FindModel findModel, @Nullable PsiDirectory psiDirectory, @NotNull Project project, @NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        FindInProjectUtil.findUsages(findModel, project, consumer, processPresentation);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project, @NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        new FindInProjectTask(findModel, project).findUsages(consumer, processPresentation);
    }

    static int processUsagesInFile(final @NotNull PsiFile psiFile, final @NotNull FindModel findModel, final @NotNull Processor<UsageInfo> consumer) {
        int found;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (findModel.getStringToFind().isEmpty()) {
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return consumer.process((Object)new UsageInfo((PsiElement)psiFile, 0, 0, true));
                }
            })).booleanValue()) {
                throw new ProcessCanceledException();
            }
            return 1;
        }
        final VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return 0;
        }
        if (virtualFile.getFileType().isBinary()) {
            return 0;
        }
        final Document document = (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

            public Document compute() {
                return virtualFile.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            }
        });
        if (document == null) {
            return 0;
        }
        final int[] offset = new int[]{0};
        int count = 0;
        ProgressIndicator indicator = ProgressWrapper.unwrap(ProgressManager.getInstance().getProgressIndicator());
        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(indicator);
        do {
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            found = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                @NotNull
                public Integer compute() {
                    if (!psiFile.isValid()) {
                        Integer n = 0;
                        if (n == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$4", "compute"));
                        }
                        return n;
                    }
                    Integer n = FindInProjectUtil.addToUsages(document, (Processor<UsageInfo>)consumer, findModel, psiFile, offset, 100);
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$4", "compute"));
                    }
                    return n;
                }
            });
            count += found;
        } while (found != 0);
        return count;
    }

    private static int addToUsages(@NotNull Document document, @NotNull Processor<UsageInfo> consumer, @NotNull FindModel findModel, @NotNull PsiFile psiFile, @NotNull int[] offsetRef, int maxUsages) {
        TextRange range;
        SearchScope customScope;
        FindResult result;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (offsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetRef", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        int count = 0;
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        int offset = offsetRef[0];
        Project project = psiFile.getProject();
        FindManager findManager = FindManager.getInstance((Project)project);
        while (offset < textLength && (result = findManager.findString(text, offset, findModel, psiFile.getVirtualFile())).isStringFound() && (!((customScope = findModel.getCustomScope()) instanceof LocalSearchScope) || ((LocalSearchScope)customScope).containsRange(psiFile, range = new TextRange(result.getStartOffset(), result.getEndOffset())))) {
            FindResultUsageInfo info = new FindResultUsageInfo(findManager, psiFile, offset, findModel, result);
            if (!consumer.process((Object)info)) {
                throw new ProcessCanceledException();
            }
            ++count;
            int prevOffset = offset;
            if (prevOffset == (offset = result.getEndOffset())) {
                ++offset;
            }
            if (maxUsages <= 0 || count < maxUsages) continue;
            break;
        }
        offsetRef[0] = offset;
        return count;
    }

    @NotNull
    private static String getTitleForScope(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getTitleForScope"));
        }
        String scopeName = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        String result = scopeName;
        if (findModel.getFileFilter() != null) {
            result = result + " " + FindBundle.message("find.scope.files.with.mask", findModel.getFileFilter());
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "getTitleForScope"));
        }
        return string;
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "setupViewPresentation"));
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scope = FindInProjectUtil.getTitleForScope(findModel);
        String stringToFind = findModel.getStringToFind();
        presentation.setScopeText(scope);
        if (stringToFind.isEmpty()) {
            presentation.setTabText("Files");
            presentation.setToolwindowTitle(BundleBase.format((String)"Files in {0}", (Object[])new Object[]{scope}));
            presentation.setUsagesString("files");
        } else {
            FindModel.SearchContext searchContext = findModel.getSearchContext();
            String contextText = "";
            if (searchContext != FindModel.SearchContext.ANY) {
                contextText = FindBundle.message("find.context.presentation.scope.label", FindDialog.getPresentableName(searchContext));
            }
            presentation.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind, contextText));
            presentation.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope, contextText));
            presentation.setUsagesString(FindBundle.message("find.usage.view.usages.text", stringToFind));
            presentation.setUsagesWord(FindBundle.message("occurrence", new Object[0]));
            presentation.setCodeUsagesString(FindBundle.message("found.occurrences", new Object[0]));
            presentation.setContextText(contextText);
        }
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "setupViewPresentation"));
        }
        return usageViewPresentation;
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(final @NotNull Project project, boolean showPanelIfOnlyOneUsage, final @NotNull UsageViewPresentation presentation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        processPresentation.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            @NotNull
            public ProgressIndicator create() {
                FindProgressIndicator findProgressIndicator = new FindProgressIndicator(project, presentation.getScopeText());
                if (findProgressIndicator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$5", "create"));
                }
                return findProgressIndicator;
            }
        });
        FindUsagesProcessPresentation findUsagesProcessPresentation = processPresentation;
        if (findUsagesProcessPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        return findUsagesProcessPresentation;
    }

    private static void addSourceDirectoriesFromLibraries(@NotNull Project project, @NotNull VirtualFile file, @NotNull Collection<VirtualFile> outSourceRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        if (outSourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outSourceRoots", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (index.isInLibrarySource(file)) {
            return;
        }
        VirtualFile classRoot = index.getClassRootForFile(file);
        if (classRoot == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)classRoot);
        if (relativePath == null) {
            return;
        }
        for (OrderEntry orderEntry : index.getOrderEntriesForFile(file)) {
            for (VirtualFile sourceRoot : orderEntry.getFiles(OrderRootType.SOURCES)) {
                VirtualFile sourceFile = sourceRoot.findFileByRelativePath(relativePath);
                if (sourceFile == null) continue;
                outSourceRoots.add(sourceFile);
            }
        }
    }

    @NotNull
    static SearchScope getScopeFromModel(@NotNull Project project, @NotNull FindModel findModel) {
        Module module;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        SearchScope customScope = findModel.getCustomScope();
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        Module module2 = module = findModel.getModuleName() == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(findModel.getModuleName());
        Object object = findModel.isCustomScope() && customScope != null ? customScope : (directory != null ? FindInProjectUtil.forDirectory(project, findModel.isWithSubdirectories(), directory) : (module != null ? module.getModuleContentScope() : (findModel.isProjectScope() ? ProjectScope.getContentScope((Project)project) : GlobalSearchScope.allScope((Project)project))));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        return object;
    }

    @NotNull
    private static GlobalSearchScope forDirectory(@NotNull Project project, boolean withSubdirectories, @NotNull VirtualFile directory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        result.add(directory);
        FindInProjectUtil.addSourceDirectoriesFromLibraries(project, directory, result);
        VirtualFile[] array = result.toArray(new VirtualFile[result.size()]);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)withSubdirectories, (VirtualFile[])array);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        return globalSearchScope;
    }

    public static class StringUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation,
    TypeSafeDataProvider {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final FindModel myFindModel;

        public StringUsageTarget(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "<init>"));
            }
            if (findModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "<init>"));
            }
            this.myProject = project;
            this.myFindModel = findModel;
        }

        @NotNull
        public String getPresentableText() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = presentation.getToolwindowTitle();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "getPresentableText"));
            }
            return string;
        }

        @NotNull
        public String getLongDescriptiveName() {
            String string = this.getPresentableText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "getLongDescriptiveName"));
            }
            return string;
        }

        public String getLocationString() {
            return this.myFindModel + "!!";
        }

        public Icon getIcon(boolean open2) {
            return AllIcons.Actions.Menu_find;
        }

        public void findUsages() {
            FindInProjectManager.getInstance(this.myProject).startFindInProject(this.myFindModel);
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "findUsagesInEditor"));
            }
        }

        public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "highlightUsages"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "highlightUsages"));
            }
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        public String getName() {
            return this.myFindModel.getStringToFind().isEmpty() ? this.myFindModel.getFileFilter() : this.myFindModel.getStringToFind();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void showSettings() {
            Content selectedContent = UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component = selectedContent == null ? null : selectedContent.getComponent();
            FindInProjectManager findInProjectManager = FindInProjectManager.getInstance(this.myProject);
            findInProjectManager.findInProject(DataManager.getInstance().getDataContext((Component)component));
        }

        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("FindInPath");
        }

        public void calcData(DataKey key, DataSink sink) {
            if (UsageView.USAGE_SCOPE.equals(key)) {
                SearchScope scope = FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel);
                sink.put(UsageView.USAGE_SCOPE, (Object)scope);
            }
        }
    }
}

