/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExportableFileTemplateSettings", storages={@Storage(file="$APP_CONFIG$/file.template.settings.xml")}, additionalExportFile="fileTemplates")
public class ExportableFileTemplateSettings
extends FileTemplatesLoader
implements PersistentStateComponent<Element> {
    public static final String EXPORTABLE_SETTINGS_FILE = "file.template.settings.xml";
    static final String ELEMENT_TEMPLATE = "template";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_REFORMAT = "reformat";
    static final String ATTRIBUTE_ENABLED = "enabled";
    private boolean myLoaded;

    public ExportableFileTemplateSettings(@NotNull FileTypeManagerEx typeManager) {
        if (typeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeManager", "com/intellij/ide/fileTemplates/impl/ExportableFileTemplateSettings", "<init>"));
        }
        super(typeManager);
        this.myLoaded = false;
    }

    public static ExportableFileTemplateSettings getInstance() {
        return (ExportableFileTemplateSettings)ServiceManager.getService(ExportableFileTemplateSettings.class);
    }

    @Nullable
    public Element getState() {
        Element element = null;
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = null;
            for (FileTemplateBase template : manager.getAllTemplates(true)) {
                boolean shouldSave;
                boolean bl = shouldSave = !template.isReformatCode();
                if (template instanceof BundledFileTemplate) {
                    shouldSave |= !((BundledFileTemplate)template).isEnabled();
                }
                if (!shouldSave) continue;
                Element templateElement = new Element(ELEMENT_TEMPLATE);
                templateElement.setAttribute(ATTRIBUTE_NAME, template.getQualifiedName());
                templateElement.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isReformatCode()));
                if (template instanceof BundledFileTemplate) {
                    templateElement.setAttribute(ATTRIBUTE_ENABLED, Boolean.toString(((BundledFileTemplate)template).isEnabled()));
                }
                if (templatesGroup == null) {
                    templatesGroup = new Element(ExportableFileTemplateSettings.getXmlElementGroupName(manager));
                    if (element == null) {
                        element = new Element("fileTemplateSettings");
                    }
                    element.addContent(templatesGroup);
                }
                templatesGroup.addContent(templateElement);
            }
        }
        return element;
    }

    public void loadState(Element state) {
        this.doLoad(state);
        this.myLoaded = true;
    }

    private void doLoad(Element element) {
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = element.getChild(ExportableFileTemplateSettings.getXmlElementGroupName(manager));
            if (templatesGroup == null) continue;
            List children = templatesGroup.getChildren(ELEMENT_TEMPLATE);
            for (Object elem : children) {
                Element child = (Element)elem;
                String qName = child.getAttributeValue(ATTRIBUTE_NAME);
                FileTemplateBase template = manager.getTemplate(qName);
                if (template == null) continue;
                boolean reformat = Boolean.TRUE.toString().equals(child.getAttributeValue(ATTRIBUTE_REFORMAT));
                template.setReformatCode(reformat);
                if (!(template instanceof BundledFileTemplate)) continue;
                boolean enabled = Boolean.parseBoolean(child.getAttributeValue(ATTRIBUTE_ENABLED, "true"));
                ((BundledFileTemplate)template).setEnabled(enabled);
            }
        }
    }

    private static String getXmlElementGroupName(FTManager manager) {
        return manager.getName().toLowerCase(Locale.US) + "_templates";
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }
}

