/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InstallPluginAction
extends AnAction
implements DumbAware {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private static final Set<IdeaPluginDescriptor> ourInstallingNodes = new HashSet<IdeaPluginDescriptor>();
    private final PluginManagerMain myHost;
    private final PluginManagerMain myInstalled;

    public InstallPluginAction(PluginManagerMain mgr, PluginManagerMain installed) {
        super(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), AllIcons.Actions.Install);
        this.myHost = mgr;
        this.myInstalled = installed;
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Presentation presentation = e.getPresentation();
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        boolean bl = enabled = selection != null;
        if (enabled) {
            for (IdeaPluginDescriptor descr : selection) {
                presentation.setText(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                enabled &= !ourInstallingNodes.contains(descr);
                if (descr instanceof PluginNode) {
                    enabled &= !PluginManagerColumnInfo.isDownloaded((PluginNode)descr);
                    if (((PluginNode)descr).getStatus() != 1) continue;
                    presentation.setText(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                    presentation.setDescription(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                    enabled &= ourState.hasNewerVersion(descr.getPluginId());
                    continue;
                }
                if (!(descr instanceof IdeaPluginDescriptorImpl)) continue;
                presentation.setText(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]));
                PluginId id = descr.getPluginId();
                enabled = enabled && ourState.hasNewerVersion(id);
            }
        }
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        this.install(null);
    }

    public static boolean isInstalling(IdeaPluginDescriptor node) {
        return ourInstallingNodes.contains(node);
    }

    public void install(@Nullable Runnable onSuccess) {
        this.install(onSuccess, false);
    }

    public void install(final @Nullable Runnable onSuccess, boolean confirmed) {
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        if (confirmed || this.userConfirm(selection)) {
            PluginId pluginId;
            final ArrayList<PluginNode> list = new ArrayList<PluginNode>();
            for (IdeaPluginDescriptor descr : selection) {
                PluginNode pluginNode = null;
                if (descr instanceof PluginNode) {
                    pluginNode = (PluginNode)descr;
                } else if (descr instanceof IdeaPluginDescriptorImpl) {
                    pluginId = descr.getPluginId();
                    pluginNode = new PluginNode(pluginId);
                    pluginNode.setName(descr.getName());
                    pluginNode.setDepends(Arrays.asList(descr.getDependentPluginIds()), descr.getOptionalDependentPluginIds());
                    pluginNode.setSize("-1");
                    pluginNode.setRepositoryName("__unknown_repository__");
                }
                if (pluginNode == null) continue;
                list.add(pluginNode);
                ourInstallingNodes.add(pluginNode);
            }
            final InstalledPluginsTableModel installedModel = (InstalledPluginsTableModel)this.myInstalled.getPluginsModel();
            HashSet<IdeaPluginDescriptor> disabled = new HashSet<IdeaPluginDescriptor>();
            HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
            for (PluginNode node : list) {
                List<PluginId> depends;
                pluginId = node.getPluginId();
                if (installedModel.isDisabled(pluginId)) {
                    disabled.add(node);
                }
                if ((depends = node.getDepends()) == null) continue;
                HashSet<PluginId> optionalDeps = new HashSet<PluginId>(Arrays.asList(node.getOptionalDependentPluginIds()));
                for (PluginId dependantId : depends) {
                    IdeaPluginDescriptor pluginDescriptor;
                    if (optionalDeps.contains(dependantId) || (pluginDescriptor = PluginManager.getPlugin(dependantId)) == null || !installedModel.isDisabled(dependantId)) continue;
                    disabledDependants.add(pluginDescriptor);
                }
            }
            if (InstallPluginAction.suggestToEnableInstalledPlugins(installedModel, disabled, disabledDependants, list)) {
                this.myInstalled.setRequireShutdown(true);
            }
            try {
                Runnable onInstallRunnable = new Runnable(){

                    @Override
                    public void run() {
                        for (PluginNode node : list) {
                            installedModel.appendOrUpdateDescriptor(node);
                        }
                        if (!InstallPluginAction.this.myInstalled.isDisposed()) {
                            InstallPluginAction.this.getPluginTable().updateUI();
                            InstallPluginAction.this.myInstalled.setRequireShutdown(true);
                        } else {
                            boolean needToRestart = false;
                            for (PluginNode node : list) {
                                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(node.getPluginId());
                                if (pluginDescriptor != null && !pluginDescriptor.isEnabled()) continue;
                                needToRestart = true;
                                break;
                            }
                            if (needToRestart) {
                                PluginManagerMain.notifyPluginsUpdated(null);
                            }
                        }
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    }
                };
                Runnable cleanupRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ourInstallingNodes.removeAll(list);
                    }
                };
                List<IdeaPluginDescriptor> plugins = this.myHost.getPluginsModel().getAllPlugins();
                PluginManagerMain.downloadPlugins(list, PluginManagerMain.mapToPluginIds(plugins), onInstallRunnable, cleanupRunnable);
            }
            catch (IOException e1) {
                ourInstallingNodes.removeAll(list);
                PluginManagerMain.LOG.error((Throwable)e1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IOExceptionDialog.showErrorDialog((String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (String)IdeBundle.message((String)"error.plugin.download.failed", (Object[])new Object[0]));
                    }
                });
            }
        }
    }

    private static boolean suggestToEnableInstalledPlugins(InstalledPluginsTableModel pluginsModel, Set<IdeaPluginDescriptor> disabled, Set<IdeaPluginDescriptor> disabledDependants, List<PluginNode> list) {
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            int result;
            String message = "";
            if (disabled.size() == 1) {
                message = message + "Updated plugin '" + disabled.iterator().next().getName() + "' is disabled.";
            } else if (!disabled.isEmpty()) {
                message = message + "Updated plugins " + StringUtil.join(disabled, (Function)new Function<IdeaPluginDescriptor, String>(){

                    public String fun(IdeaPluginDescriptor pluginDescriptor) {
                        return pluginDescriptor.getName();
                    }
                }, (String)", ") + " are disabled.";
            }
            if (!disabledDependants.isEmpty()) {
                message = message + "<br>";
                message = message + "Updated plugin" + (list.size() > 1 ? "s depend " : " depends ") + "on disabled";
                message = disabledDependants.size() == 1 ? message + " plugin '" + disabledDependants.iterator().next().getName() + "'." : message + " plugins " + StringUtil.join(disabledDependants, (Function)new Function<IdeaPluginDescriptor, String>(){

                    public String fun(IdeaPluginDescriptor pluginDescriptor) {
                        return pluginDescriptor.getName();
                    }
                }, (String)", ") + ".";
            }
            message = message + " Disabled plugins " + (disabled.isEmpty() ? "and plugins which depend on disabled " : "") + "won't be activated after restart.";
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                result = Messages.showYesNoCancelDialog((String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)CommonBundle.getWarningTitle(), (String)"Enable all", (String)("Enable updated plugin" + (disabled.size() > 1 ? "s" : "")), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (result == 2) {
                    return false;
                }
            } else {
                message = message + "<br>Would you like to enable ";
                message = !disabled.isEmpty() ? message + "updated plugin" + (disabled.size() > 1 ? "s" : "") : message + "plugin dependenc" + (disabledDependants.size() > 1 ? "ies" : "y");
                result = Messages.showYesNoDialog((String)XmlStringUtil.wrapInHtml((CharSequence)(message = message + "?")), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon());
                if (result == 1) {
                    return false;
                }
            }
            if (result == 0) {
                disabled.addAll(disabledDependants);
                pluginsModel.enableRows(disabled.toArray(new IdeaPluginDescriptor[disabled.size()]), true);
            } else if (result == 1 && !disabled.isEmpty()) {
                pluginsModel.enableRows(disabled.toArray(new IdeaPluginDescriptor[disabled.size()]), true);
            }
            return true;
        }
        return false;
    }

    public PluginTable getPluginTable() {
        return this.myHost.getPluginTable();
    }

    private boolean userConfirm(IdeaPluginDescriptor[] selection) {
        String message = selection.length == 1 ? (selection[0] instanceof IdeaPluginDescriptorImpl ? IdeBundle.message((String)"prompt.update.plugin", (Object[])new Object[]{selection[0].getName()}) : IdeBundle.message((String)"prompt.download.and.install.plugin", (Object[])new Object[]{selection[0].getName()})) : IdeBundle.message((String)"prompt.install.several.plugins", (Object[])new Object[]{selection.length});
        return Messages.showYesNoDialog((Component)this.myHost.getMainPanel(), (String)message, (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }
}

