/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        ScratchRootType scratchRootType = ScratchRootType.findByClass(ScratchRootType.class);
        if (scratchRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchRootType", "getInstance"));
        }
        return scratchRootType;
    }

    ScratchRootType() {
        super("scratches", "Scratches");
    }

    public boolean isScratchFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ScratchFileService service2 = ScratchFileService.getInstance();
        return service2 != null && service2.getRootType(file) == this;
    }

    @Override
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        Language language = (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file);
        return ScratchRootType.substituteLanguageImpl(language, file, project);
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        Icon icon = (Icon)ObjectUtils.chooseNotNull((Object)super.substituteIcon(project, file), (Object)ScratchFileType.INSTANCE.getIcon());
        return LayeredIcon.create((Icon)icon, (Icon)AllIcons.Actions.Scratch);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project, String fileName, Language language, String text) {
        return this.createScratchFile(project, fileName, language, text, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project, final String fileName, final Language language, final String text, final ScratchFileService.Option option) {
        RunResult result = new WriteCommandAction<VirtualFile>(project, UIBundle.message((String)"file.chooser.create.new.file.command.name", (Object[])new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/scratch/ScratchRootType$1", "run"));
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file = fileService.findFile(ScratchRootType.this, fileName, option);
                fileService.getScratchesMapping().setMapping(file, (Object)language);
                VfsUtil.saveText((VirtualFile)file, (String)text);
                result.setResult((Object)file);
            }
        }.execute();
        if (result.hasException()) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
        return (VirtualFile)result.getResultObject();
    }
}

