/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class MacIntelliJComboBoxUI
extends BasicComboBoxUI {
    private static final Icon DEFAULT_ICON = EmptyIcon.create((Icon)MacIntelliJIconCache.getIcon("comboRight"));
    private final JComboBox myComboBox;

    public MacIntelliJComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.currentValuePane = new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                c.setBackground((Color)(MacIntelliJComboBoxUI.this.myComboBox.isEnabled() ? Gray.xFF : Gray.xF6));
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJComboBoxUI((JComboBox)c);
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Icon icon = MacIntelliJIconCache.getIcon("comboRight", false, MacIntelliJComboBoxUI.this.myComboBox.hasFocus(), !MacIntelliJComboBoxUI.this.myComboBox.isEnabled());
                icon.paintIcon(this, g2, 0, 0);
            }

            @Override
            public Dimension getPreferredSize() {
                return JBUI.size((int)DEFAULT_ICON.getIconWidth(), (int)DEFAULT_ICON.getIconHeight());
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MacIntelliJComboBoxUI.getSizeWithIcon(super.getMinimumSize(c));
    }

    private static Dimension getSizeWithIcon(Dimension d) {
        return new Dimension(Math.max(d.width + 7, DEFAULT_ICON.getIconWidth()), Math.max(d.height, DEFAULT_ICON.getIconHeight()));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return MacIntelliJComboBoxUI.getSizeWithIcon(super.getPreferredSize(c));
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){
                    {
                        this.setOpaque(false);
                        this.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
                    }

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, DEFAULT_ICON.getIconHeight() - 6);
                    }
                };
            }
        };
        if (comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code = e.getKeyCode();
                    if ((code == 38 || code == 40) && e.getModifiers() == 0) {
                        MacIntelliJComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            });
            comboBoxEditor.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                void update() {
                    if (MacIntelliJComboBoxUI.this.comboBox != null) {
                        MacIntelliJComboBoxUI.this.comboBox.revalidate();
                        MacIntelliJComboBoxUI.this.comboBox.repaint();
                    }
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = super.rectangleForCurrentValue();
        rect.height = Math.min(rect.height, DEFAULT_ICON.getIconHeight() - 8);
        rect.y += 4;
        rect.x += 8;
        rect.width -= 8;
        return rect;
    }

    @Override
    protected Dimension getDefaultSize() {
        return super.getDefaultSize();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                int width = cb.getWidth();
                int height = cb.getHeight();
                Insets insets = MacIntelliJComboBoxUI.this.getInsets();
                int buttonHeight = height - (insets.top + insets.bottom);
                int buttonWidth = DEFAULT_ICON.getIconWidth();
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    Insets arrowInsets = MacIntelliJComboBoxUI.this.arrowButton.getInsets();
                    buttonWidth = ((MacIntelliJComboBoxUI)MacIntelliJComboBoxUI.this).arrowButton.getPreferredSize().width + arrowInsets.left + arrowInsets.right;
                }
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    MacIntelliJComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                }
                if (MacIntelliJComboBoxUI.this.editor != null) {
                    Rectangle cvb = MacIntelliJComboBoxUI.this.rectangleForCurrentValue();
                    MacIntelliJComboBoxUI.this.editor.setBounds(cvb);
                }
            }
        };
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.setColor((Color)(this.myComboBox.isEnabled() ? Gray.xFF : Gray.xF6));
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValue(g, bounds, this.comboBox.isPopupVisible());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle r = this.arrowButton.getBounds();
        int stop2 = r.x;
        Insets clip = this.getInsets();
        Graphics gg = g.create(clip.left, r.y, stop2 - clip.left, DEFAULT_ICON.getIconHeight());
        boolean disabled = !c.isEnabled();
        boolean hasFocus = c.hasFocus();
        Icon icon = MacIntelliJIconCache.getIcon("comboLeft", false, hasFocus, disabled);
        icon.paintIcon(c, gg, 0, 0);
        int x = icon.getIconWidth();
        icon = MacIntelliJIconCache.getIcon("comboMiddle", false, hasFocus, disabled);
        while (x < stop2) {
            icon.paintIcon(c, gg, x, 0);
            x += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("comboRight", false, hasFocus, disabled);
        icon.paintIcon(c, g, r.x, r.y);
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), false);
        }
    }
}

