/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.ide.DataManager;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffTableCellRenderer;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffToolbarActions;
import com.intellij.openapi.diff.impl.dir.actions.RefreshDirDiffAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffPanel
implements Disposable,
DataProvider {
    public static final String DIVIDER_PROPERTY = "dir.diff.panel.divider.location";
    private static final int DIVIDER_PROPERTY_DEFAULT_VALUE = 200;
    private JPanel myDiffPanel;
    private JBTable myTable;
    private JPanel myComponent;
    private JSplitPane mySplitPanel;
    private TextFieldWithBrowseButton mySourceDirField;
    private TextFieldWithBrowseButton myTargetDirField;
    private JBLabel myTargetDirLabel;
    private JBLabel mySourceDirLabel;
    private JPanel myToolBarPanel;
    private JPanel myRootPanel;
    private JPanel myFilterPanel;
    private JBLabel myFilterLabel;
    private JPanel myFilesPanel;
    private JPanel myHeaderPanel;
    private FilterComponent myFilter;
    private final DirDiffTableModel myModel;
    public JLabel myErrorLabel;
    private final DirDiffWindow myDiffWindow;
    private JComponent myDiffPanelComponent;
    private JComponent myViewComponent;
    private DiffElement myCurrentElement;
    private String oldFilter;
    public static final DataKey<DirDiffTableModel> DIR_DIFF_MODEL = DataKey.create((String)"DIR_DIFF_MODEL");
    public static final DataKey<JTable> DIR_DIFF_TABLE = DataKey.create((String)"DIR_DIFF_TABLE");

    public DirDiffPanel(DirDiffTableModel model, DirDiffWindow wnd) {
        Dimension preferredSize;
        this.myModel = model;
        this.myDiffWindow = wnd;
        this.$$$setupUI$$$();
        this.mySourceDirField.setText(model.getSourceDir().getPath());
        this.myTargetDirField.setText(model.getTargetDir().getPath());
        this.mySourceDirField.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myTargetDirField.setBorder((Border)JBUI.Borders.emptyRight((int)12));
        this.mySourceDirLabel.setIcon(model.getSourceDir().getIcon());
        this.myTargetDirLabel.setIcon(model.getTargetDir().getIcon());
        this.myTargetDirLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.myModel.setTable(this.myTable);
        this.myModel.setPanel(this);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable.setModel((TableModel)this.myModel);
        new TableSpeedSearch((JTable)this.myTable);
        DirDiffTableCellRenderer renderer = new DirDiffTableCellRenderer();
        this.myTable.setExpandableItemsEnabled(false);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        this.myTable.getSelectionModel().setSelectionMode(2);
        final Project project = this.myModel.getProject();
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int lastIndex = e.getLastIndex();
                int firstIndex = e.getFirstIndex();
                DirDiffElementImpl last = DirDiffPanel.this.myModel.getElementAt(lastIndex);
                DirDiffElementImpl first = DirDiffPanel.this.myModel.getElementAt(firstIndex);
                if (last == null || first == null) {
                    DirDiffPanel.this.update(false);
                    return;
                }
                if (last.isSeparator()) {
                    int ind = lastIndex + (lastIndex < firstIndex ? 1 : -1);
                    DirDiffPanel.this.myTable.getSelectionModel().addSelectionInterval(ind, ind);
                } else if (first.isSeparator()) {
                    int ind = firstIndex + (firstIndex < lastIndex ? 1 : -1);
                    DirDiffPanel.this.myTable.getSelectionModel().addSelectionInterval(ind, ind);
                } else {
                    DirDiffPanel.this.update(false);
                }
                DirDiffPanel.this.myDiffWindow.setTitle(DirDiffPanel.this.myModel.getTitle());
            }
        });
        if (model.isOperationsEnabled()) {
            new AnAction("Change diff operation"){

                public void actionPerformed(AnActionEvent e) {
                    DirDiffPanel.this.changeOperationForSelection();
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"SPACE"}), (JComponent)this.myTable);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$3", "onClick"));
                    }
                    if (e.getButton() == 3) {
                        return false;
                    }
                    if (DirDiffPanel.this.myTable.getRowCount() > 0) {
                        int row = DirDiffPanel.this.myTable.rowAtPoint(e.getPoint());
                        int col = DirDiffPanel.this.myTable.columnAtPoint(e.getPoint());
                        if (row != -1 && col == (DirDiffPanel.this.myTable.getColumnCount() - 1) / 2) {
                            DirDiffPanel.this.changeOperationForSelection();
                        }
                    }
                    return true;
                }
            }.installOn((Component)this.myTable);
        }
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DirDiffElementImpl element;
                int keyCode = e.getKeyCode();
                int rowCount = DirDiffPanel.this.myTable.getRowCount();
                int row = DirDiffPanel.this.myTable.getSelectionModel().getLeadSelectionIndex();
                int[] rows = DirDiffPanel.this.myTable.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                if (keyCode == 40 && row < rowCount - 1) {
                    element = DirDiffPanel.this.myModel.getElementAt(++row);
                    if (element == null) {
                        return;
                    }
                    if (element.isSeparator()) {
                        ++row;
                    }
                } else if (keyCode == 38 && row > 0) {
                    element = DirDiffPanel.this.myModel.getElementAt(--row);
                    if (element == null) {
                        return;
                    }
                    if (element.isSeparator()) {
                        --row;
                    }
                } else {
                    return;
                }
                element = DirDiffPanel.this.myModel.getElementAt(row);
                if (element == null) {
                    return;
                }
                if (!element.isSeparator()) {
                    e.consume();
                    DirDiffPanel.this.myTable.changeSelection(row, (DirDiffPanel.this.myModel.getColumnCount() - 1) / 2, false, e.isShiftDown());
                }
            }
        });
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn operationColumn = columnModel.getColumn((columnModel.getColumnCount() - 1) / 2);
        operationColumn.setMaxWidth(JBUI.scale((int)25));
        operationColumn.setMinWidth(JBUI.scale((int)25));
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            String name = this.myModel.getColumnName(i);
            TableColumn column = columnModel.getColumn(i);
            if ("Date".equals(name)) {
                column.setMaxWidth(JBUI.scale((int)90));
                column.setMinWidth(JBUI.scale((int)90));
                continue;
            }
            if (!"Size".equals(name)) continue;
            column.setMaxWidth(JBUI.scale((int)120));
            column.setMinWidth(JBUI.scale((int)120));
        }
        DirDiffToolbarActions actions2 = new DirDiffToolbarActions(this.myModel, this.myDiffPanel);
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("DirDiff", (ActionGroup)actions2, true);
        this.registerCustomShortcuts(actions2, (JComponent)this.myTable);
        this.myToolBarPanel.add((Component)toolbar.getComponent(), "Center");
        JBLabel label = new JBLabel("Use Space button or mouse click to change operation for the selected elements. Enter to perform.", 0);
        label.setForeground(UIUtil.getInactiveTextColor());
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)label);
        DataManager.registerDataProvider((JComponent)this.myFilesPanel, (DataProvider)this);
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                JPopupMenu popupMenu = actionManager.createActionPopupMenu("DirDiffPanel", (ActionGroup)actionManager.getAction("DirDiffMenu")).getComponent();
                popupMenu.show(comp, x, y);
            }
        });
        this.myFilesPanel.add((Component)label, "South");
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), wnd.getDisposable());
        loadingPanel.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){
            boolean showHelp = true;

            public void onLoadingFinish() {
                long count;
                if (this.showHelp && DirDiffPanel.this.myModel.isOperationsEnabled() && DirDiffPanel.this.myModel.getRowCount() > 0 && (count = PropertiesComponent.getInstance().getOrInitLong("dir.diff.space.button.info", 0L)) < 3L) {
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(" Use Space button to change operation")).setFadeoutTime(5000L).setContentInsets((Insets)JBUI.insets((int)15)).createBalloon().show(new RelativePoint((Component)DirDiffPanel.this.myTable, new Point(DirDiffPanel.this.myTable.getWidth() / 2, 0)), Balloon.Position.above);
                    PropertiesComponent.getInstance().setValue("dir.diff.space.button.info", String.valueOf(count + 1L));
                }
                this.showHelp = false;
            }
        });
        loadingPanel.add((Component)this.myComponent, (Object)"Center");
        this.myTable.putClientProperty((Object)this.myModel.DECORATOR, (Object)loadingPanel);
        this.myTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DirDiffPanel.this.myTable.removeComponentListener((ComponentListener)this);
                DirDiffPanel.this.myModel.reloadModel(false);
            }
        });
        this.myRootPanel.removeAll();
        this.myRootPanel.add((Component)loadingPanel, "Center");
        this.myFilter = new FilterComponent("dir.diff.filter", 15, false){

            public void filter() {
                DirDiffPanel.this.fireFilterUpdated();
            }

            protected void onEscape(KeyEvent e) {
                e.consume();
                DirDiffPanel.this.focusTable();
            }

            protected JComponent getPopupLocationComponent() {
                return UIUtil.findComponentOfType((JComponent)super.getPopupLocationComponent(), JTextComponent.class);
            }
        };
        this.myModel.addModelListener(new DirDiffModelListener(){

            @Override
            public void updateStarted() {
                DirDiffPanel.this.myFilter.setEnabled(false);
            }

            @Override
            public void updateFinished() {
                DirDiffPanel.this.myFilter.setEnabled(true);
            }
        });
        this.myFilter.getTextEditor().setColumns(10);
        this.myFilter.setFilter(this.myModel.getSettings().getFilter());
        this.oldFilter = this.myFilter.getFilter();
        this.myFilterPanel.add((Component)this.myFilter, "Center");
        this.myFilterLabel.setLabelFor((Component)this.myFilter);
        Callable srcChooser = this.myModel.getSourceDir().getElementChooser(project);
        Callable trgChooser = this.myModel.getTargetDir().getElementChooser(project);
        this.mySourceDirField.setEditable(false);
        this.myTargetDirField.setEditable(false);
        if (srcChooser != null && this.myModel.getSettings().enableChoosers) {
            this.mySourceDirField.setButtonEnabled(true);
            this.mySourceDirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Callable chooser = DirDiffPanel.this.myModel.getSourceDir().getElementChooser(project);
                        if (chooser == null) {
                            return;
                        }
                        DiffElement newElement = (DiffElement)chooser.call();
                        if (newElement != null && !StringUtil.equals((CharSequence)DirDiffPanel.this.mySourceDirField.getText(), (CharSequence)newElement.getPath())) {
                            DirDiffPanel.this.myModel.setSourceDir(newElement);
                            DirDiffPanel.this.mySourceDirField.setText(newElement.getPath());
                            DirDiffPanel.this.myModel.clearWithMessage("Source or Target has been changed. Please run Refresh (" + KeymapUtil.getShortcutsText((Shortcut[])RefreshDirDiffAction.REFRESH_SHORTCUT.getShortcuts()) + ")");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            preferredSize = this.mySourceDirField.getPreferredSize();
            this.mySourceDirField.setButtonEnabled(false);
            this.mySourceDirField.getButton().setVisible(false);
            this.mySourceDirField.setPreferredSize(preferredSize);
        }
        if (trgChooser != null && this.myModel.getSettings().enableChoosers) {
            this.myTargetDirField.setButtonEnabled(true);
            this.myTargetDirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Callable chooser = DirDiffPanel.this.myModel.getTargetDir().getElementChooser(project);
                        if (chooser == null) {
                            return;
                        }
                        DiffElement newElement = (DiffElement)chooser.call();
                        if (newElement != null) {
                            DirDiffPanel.this.myModel.setTargetDir(newElement);
                            DirDiffPanel.this.myTargetDirField.setText(newElement.getPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            preferredSize = this.myTargetDirField.getPreferredSize();
            this.myTargetDirField.setButtonEnabled(false);
            this.myTargetDirField.getButton().setVisible(false);
            this.myTargetDirField.setPreferredSize(preferredSize);
        }
    }

    public AnAction[] getActions() {
        return new DirDiffToolbarActions(this.myModel, this.myDiffPanel).getChildren(null);
    }

    public JComponent extractFilterPanel() {
        this.myHeaderPanel.setVisible(false);
        return this.myFilterPanel;
    }

    private void changeOperationForSelection() {
        for (int row : this.myTable.getSelectedRows()) {
            DirDiffElementImpl element;
            if (row == -1 || (element = this.myModel.getElementAt(row)) == null) continue;
            element.setNextOperation();
            this.myModel.fireTableRowsUpdated(row, row);
        }
    }

    public void update(boolean force) {
        Project project = this.myModel.getProject();
        DirDiffElementImpl element = this.myModel.getElementAt(this.myTable.getSelectedRow());
        if (element == null) {
            this.clearDiffPanel();
            return;
        }
        if (!(force || this.myCurrentElement == null || this.myCurrentElement != element.getSource() && this.myCurrentElement != element.getTarget())) {
            return;
        }
        this.clearDiffPanel();
        if (element.getType() == DiffType.CHANGED) {
            try {
                this.myDiffPanelComponent = element.getSource().getDiffComponent(element.getTarget(), project, this.myDiffWindow.getWindow(), (Disposable)this.myModel);
            }
            catch (FilesTooBigForDiffException e) {
                this.myDiffPanelComponent = null;
                this.myErrorLabel = new JLabel("Can not build diff for file " + element.getTarget().getPath() + ". File is too big and there are too many changes.");
            }
            if (this.myDiffPanelComponent != null) {
                this.myDiffPanel.add((Component)this.myDiffPanelComponent, "Center");
                this.myCurrentElement = element.getSource();
            } else {
                this.myDiffPanel.add((Component)this.getErrorLabel(), "Center");
            }
        } else {
            DiffElement target;
            DiffElement object;
            if (element.getType() == DiffType.ERROR) {
                object = element.getSource() == null ? element.getTarget() : element.getSource();
                target = element.getSource() == null ? element.getSource() : element.getTarget();
            } else {
                object = element.isSource() ? element.getSource() : element.getTarget();
                target = element.isSource() ? element.getTarget() : element.getSource();
            }
            this.myViewComponent = object.getViewComponent(project, target, (Disposable)this.myModel);
            if (this.myViewComponent != null) {
                this.myCurrentElement = object;
                this.myDiffPanel.add((Component)this.myViewComponent, "Center");
                DataProvider dataProvider = this.myCurrentElement.getDataProvider(project);
                if (dataProvider != null) {
                    DataManager.registerDataProvider((JComponent)this.myDiffPanel, (DataProvider)dataProvider);
                } else {
                    DataManager.removeDataProvider((JComponent)this.myDiffPanel);
                }
            } else {
                this.myDiffPanel.add((Component)this.getErrorLabel(), "Center");
            }
        }
        this.myDiffPanel.revalidate();
        this.myDiffPanel.repaint();
    }

    private void registerCustomShortcuts(DirDiffToolbarActions actions2, JComponent component) {
        for (AnAction action : actions2.getChildren(null)) {
            ShortcutSet shortcut;
            if (!(action instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action).getShortcut()) == null) continue;
            action.registerCustomShortcutSet(shortcut, component);
        }
    }

    public void focusTable() {
        Project project = this.myModel.getProject();
        final IdeFocusManager focusManager = project == null || project.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)project);
        focusManager.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                focusManager.requestFocus((Component)DirDiffPanel.this.myTable, true);
            }
        });
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private void fireFilterUpdated() {
        String newFilter = this.myFilter.getFilter();
        if (!StringUtil.equals((CharSequence)this.oldFilter, (CharSequence)newFilter)) {
            this.oldFilter = newFilter;
            this.myModel.getSettings().setFilter(newFilter);
            this.myModel.applySettings();
        }
    }

    private JLabel getErrorLabel() {
        return this.myErrorLabel == null ? (this.myErrorLabel = new JLabel("Unknown or binary file type", 0)) : this.myErrorLabel;
    }

    private void clearDiffPanel() {
        if (this.myDiffPanelComponent != null) {
            this.myDiffPanel.remove(this.myDiffPanelComponent);
            this.myDiffPanelComponent = null;
            if (this.myCurrentElement != null) {
                this.myCurrentElement.disposeDiffComponent();
            }
        }
        if (this.myViewComponent != null) {
            this.myDiffPanel.remove(this.myViewComponent);
            this.myViewComponent = null;
            if (this.myCurrentElement != null) {
                this.myCurrentElement.disposeViewComponent();
            }
        }
        this.myCurrentElement = null;
        this.myDiffPanel.remove(this.getErrorLabel());
        DataManager.removeDataProvider((JComponent)this.myDiffPanel);
        this.myDiffPanel.repaint();
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void dispose() {
        this.myModel.stopUpdating();
        PropertiesComponent.getInstance().setValue(DIVIDER_PROPERTY, this.mySplitPanel.getDividerLocation(), 200);
        this.clearDiffPanel();
    }

    private void createUIComponents() {
        this.mySourceDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.myTargetDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        final AtomicBoolean callUpdate = new AtomicBoolean(true);
        this.myRootPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (callUpdate.get()) {
                    callUpdate.set(false);
                    DirDiffPanel.this.myModel.reloadModel(false);
                }
            }
        };
    }

    public void setupSplitter() {
        this.mySplitPanel.setDividerLocation(PropertiesComponent.getInstance().getInt(DIVIDER_PROPERTY, 200));
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myModel.getProject();
        }
        if (DIR_DIFF_MODEL.is(dataId)) {
            return this.myModel;
        }
        if (DIR_DIFF_TABLE.is(dataId)) {
            return this.myTable;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getOpenFileDescriptorsArray();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        if (DiffDataKeys.OPEN_FILE_DESCRIPTOR.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        DataProvider provider = DataManager.getDataProvider((JComponent)this.myDiffPanel);
        return provider != null ? provider.getData(dataId) : null;
    }

    @Nullable
    private OpenFileDescriptor getOpenFileDescriptor() {
        Project project = this.myModel.getProject();
        List<DirDiffElementImpl> elements = this.myModel.getSelectedElements();
        if (elements.isEmpty()) {
            return null;
        }
        DirDiffElement element = elements.get(0);
        DiffElement source = element.getSource();
        DiffElement target = element.getTarget();
        OpenFileDescriptor descriptor1 = source != null ? source.getOpenFileDescriptor(project) : null;
        OpenFileDescriptor descriptor2 = target != null ? target.getOpenFileDescriptor(project) : null;
        return descriptor2 != null ? descriptor2 : descriptor1;
    }

    @Nullable
    private OpenFileDescriptor[] getOpenFileDescriptorsArray() {
        Project project = this.myModel.getProject();
        List<DirDiffElementImpl> elements = this.myModel.getSelectedElements();
        ArrayList<OpenFileDescriptor> descriptors = new ArrayList<OpenFileDescriptor>();
        for (DirDiffElementImpl element : elements) {
            OpenFileDescriptor descriptor2;
            DiffElement source = element.getSource();
            DiffElement target = element.getTarget();
            OpenFileDescriptor descriptor1 = source != null ? source.getOpenFileDescriptor(project) : null;
            OpenFileDescriptor openFileDescriptor = descriptor2 = target != null ? target.getOpenFileDescriptor(project) : null;
            if (descriptor1 != null) {
                descriptors.add(descriptor1);
            }
            if (descriptor2 == null) continue;
            descriptors.add(descriptor2);
        }
        return (OpenFileDescriptor[])ContainerUtil.toArray(descriptors, (Object[])new OpenFileDescriptor[descriptors.size()]);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel5;
        JSplitPane jSplitPane;
        JPanel jPanel6;
        this.createUIComponents();
        JPanel jPanel7 = this.myRootPanel;
        jPanel7.setLayout(new BorderLayout(0, 0));
        this.myComponent = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, "Center");
        this.mySplitPanel = jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jSplitPane.setDividerLocation(422);
        jPanel6.add((Component)jSplitPane, "Center");
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDiffPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySourceDirLabel = jBLabel3 = new JBLabel();
        jPanel10.add((Component)jBLabel3, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySourceDirField;
        jPanel10.add((Component)textFieldWithBrowseButton, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel11, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTargetDirLabel = jBLabel2 = new JBLabel();
        jPanel11.add((Component)jBLabel2, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myTargetDirField;
        jPanel11.add((Component)textFieldWithBrowseButton2, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myHeaderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel4, "Center");
        this.myToolBarPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFilterPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 1, 1, 0, 0, null, null, null));
        this.myFilterLabel = jBLabel = new JBLabel();
        jBLabel.setIconTextGap(0);
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setText("Filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, "West");
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myTable = jBTable = new JBTable();
        jBTable.setShowVerticalLines(false);
        jBTable.setShowHorizontalLines(false);
        jBTable.setIntercellSpacing(new Dimension(0, 0));
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

