/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import gnu.trove.TLongArrayList;

class DelayMeter {
    private final TLongArrayList myStartTimes = new TLongArrayList();
    private SummaryStatistics myStats = new SummaryStatistics();

    DelayMeter() {
    }

    void registerStart() {
        this.myStartTimes.add(System.nanoTime());
    }

    void registerFinish() {
        if (!this.myStartTimes.isEmpty()) {
            long now = System.nanoTime();
            for (int i = 0; i < this.myStartTimes.size(); ++i) {
                long elapsed = now - this.myStartTimes.get(i);
                this.myStats.accept(elapsed);
            }
            this.myStartTimes.clear();
        }
    }

    void reset() {
        this.myStats = new SummaryStatistics();
    }

    double getMin() {
        return this.myStats.getMin() / 1000000.0;
    }

    double getMax() {
        return this.myStats.getMax() / 1000000.0;
    }

    double getMean() {
        return this.myStats.getMean() / 1000000.0;
    }

    double getStandardDeviation() {
        return this.myStats.getStandardDeviation() / 1000000.0;
    }

    private static class SummaryStatistics {
        private int myCount = 0;
        private double myMin = Double.MAX_VALUE;
        private double myMax = 0.0;
        private double myMean = 0.0;
        private double myS = 0.0;

        private SummaryStatistics() {
        }

        void accept(double value) {
            ++this.myCount;
            this.myMin = Math.min(this.myMin, value);
            this.myMax = Math.max(this.myMax, value);
            if (this.myCount == 1) {
                this.myMean = value;
            } else {
                double previousMean = this.myMean;
                this.myMean += (value - this.myMean) / (double)this.myCount;
                this.myS += (value - previousMean) * (value - this.myMean);
            }
        }

        double getMin() {
            return this.myMin == Double.MAX_VALUE ? 0.0 : this.myMin;
        }

        double getMax() {
            return this.myMax;
        }

        double getMean() {
            return this.myMean;
        }

        double getStandardDeviation() {
            return Math.sqrt(this.myS / (double)(this.myCount - 1));
        }
    }
}

